/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.UnicodeEscaper;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtCompatible
public abstract class ArrayBasedUnicodeEscaper
extends UnicodeEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final int safeMin;
    private final int safeMax;
    private final char safeMinChar;
    private final char safeMaxChar;

    protected ArrayBasedUnicodeEscaper(Map<Character, String> map, int n2, int n3, @Nullable String string) {
        this(ArrayBasedEscaperMap.create(map), n2, n3, string);
    }

    protected ArrayBasedUnicodeEscaper(ArrayBasedEscaperMap arrayBasedEscaperMap, int n2, int n3, @Nullable String string) {
        Preconditions.checkNotNull(arrayBasedEscaperMap);
        this.replacements = arrayBasedEscaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (n3 < n2) {
            n3 = -1;
            n2 = Integer.MAX_VALUE;
        }
        this.safeMin = n2;
        this.safeMax = n3;
        if (n2 >= 55296) {
            this.safeMinChar = (char)65535;
            this.safeMaxChar = '\u0000';
        } else {
            this.safeMinChar = (char)n2;
            this.safeMaxChar = (char)Math.min(n3, 55295);
        }
    }

    @Override
    public final String escape(String string) {
        Preconditions.checkNotNull(string);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ((c2 >= this.replacementsLength || this.replacements[c2] == null) && c2 <= this.safeMaxChar && c2 >= this.safeMinChar) continue;
            return this.escapeSlow(string, i2);
        }
        return string;
    }

    @Override
    protected final char[] escape(int n2) {
        char[] cArray;
        if (n2 < this.replacementsLength && (cArray = this.replacements[n2]) != null) {
            return cArray;
        }
        if (n2 >= this.safeMin && n2 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(n2);
    }

    @Override
    protected final int nextEscapeIndex(CharSequence charSequence, int n2, int n3) {
        char c2;
        while (n2 < n3 && ((c2 = charSequence.charAt(n2)) >= this.replacementsLength || this.replacements[c2] == null) && c2 <= this.safeMaxChar && c2 >= this.safeMinChar) {
            ++n2;
        }
        return n2;
    }

    protected abstract char[] escapeUnsafe(int var1);
}

