/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;

@Beta
@GwtCompatible
public final class ArrayBasedEscaperMap {
    private final char[][] replacementArray;
    private static final char[][] EMPTY_REPLACEMENT_ARRAY = new char[0][0];

    public static ArrayBasedEscaperMap create(Map<Character, String> map) {
        return new ArrayBasedEscaperMap(ArrayBasedEscaperMap.createReplacementArray(map));
    }

    private ArrayBasedEscaperMap(char[][] cArray) {
        this.replacementArray = cArray;
    }

    char[][] getReplacementArray() {
        return this.replacementArray;
    }

    @VisibleForTesting
    static char[][] createReplacementArray(Map<Character, String> map) {
        Preconditions.checkNotNull(map);
        if (map.isEmpty()) {
            return EMPTY_REPLACEMENT_ARRAY;
        }
        char c2 = Collections.max(map.keySet()).charValue();
        char[][] cArrayArray = new char[c2 + '\u0001'][];
        for (char c3 : map.keySet()) {
            cArrayArray[c3] = map.get(Character.valueOf(c3)).toCharArray();
        }
        return cArrayArray;
    }
}

