/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.escape.ArrayBasedEscaperMap;
import com.google.common.escape.CharEscaper;
import java.util.Map;

@Beta
@GwtCompatible
public abstract class ArrayBasedCharEscaper
extends CharEscaper {
    private final char[][] replacements;
    private final int replacementsLength;
    private final char safeMin;
    private final char safeMax;

    protected ArrayBasedCharEscaper(Map<Character, String> map, char c2, char c3) {
        this(ArrayBasedEscaperMap.create(map), c2, c3);
    }

    protected ArrayBasedCharEscaper(ArrayBasedEscaperMap arrayBasedEscaperMap, char c2, char c3) {
        Preconditions.checkNotNull(arrayBasedEscaperMap);
        this.replacements = arrayBasedEscaperMap.getReplacementArray();
        this.replacementsLength = this.replacements.length;
        if (c3 < c2) {
            c3 = '\u0000';
            c2 = (char)65535;
        }
        this.safeMin = c2;
        this.safeMax = c3;
    }

    @Override
    public final String escape(String string) {
        Preconditions.checkNotNull(string);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ((c2 >= this.replacementsLength || this.replacements[c2] == null) && c2 <= this.safeMax && c2 >= this.safeMin) continue;
            return this.escapeSlow(string, i2);
        }
        return string;
    }

    @Override
    protected final char[] escape(char c2) {
        char[] cArray;
        if (c2 < this.replacementsLength && (cArray = this.replacements[c2]) != null) {
            return cArray;
        }
        if (c2 >= this.safeMin && c2 <= this.safeMax) {
            return null;
        }
        return this.escapeUnsafe(c2);
    }

    protected abstract char[] escapeUnsafe(char var1);
}

