/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import java.util.function.Consumer;

@Deprecated
@Beta
@GwtCompatible
public abstract class TreeTraverser<T> {
    @Deprecated
    public static <T> TreeTraverser<T> using(final Function<T, ? extends Iterable<T>> function) {
        Preconditions.checkNotNull(function);
        return new TreeTraverser<T>(){

            @Override
            public Iterable<T> children(T t2) {
                return (Iterable)function.apply(t2);
            }
        };
    }

    public abstract Iterable<T> children(T var1);

    @Deprecated
    public final FluentIterable<T> preOrderTraversal(final T t2) {
        Preconditions.checkNotNull(t2);
        return new FluentIterable<T>(){

            @Override
            public UnmodifiableIterator<T> iterator() {
                return TreeTraverser.this.preOrderIterator(t2);
            }

            @Override
            public void forEach(final Consumer<? super T> consumer) {
                Preconditions.checkNotNull(consumer);
                new Consumer<T>(){

                    @Override
                    public void accept(T t2) {
                        consumer.accept(t2);
                        TreeTraverser.this.children(t2).forEach(this);
                    }
                }.accept(t2);
            }
        };
    }

    UnmodifiableIterator<T> preOrderIterator(T t2) {
        return new PreOrderIterator(t2);
    }

    @Deprecated
    public final FluentIterable<T> postOrderTraversal(final T t2) {
        Preconditions.checkNotNull(t2);
        return new FluentIterable<T>(){

            @Override
            public UnmodifiableIterator<T> iterator() {
                return TreeTraverser.this.postOrderIterator(t2);
            }

            @Override
            public void forEach(final Consumer<? super T> consumer) {
                Preconditions.checkNotNull(consumer);
                new Consumer<T>(){

                    @Override
                    public void accept(T t2) {
                        TreeTraverser.this.children(t2).forEach(this);
                        consumer.accept(t2);
                    }
                }.accept(t2);
            }
        };
    }

    UnmodifiableIterator<T> postOrderIterator(T t2) {
        return new PostOrderIterator(t2);
    }

    @Deprecated
    public final FluentIterable<T> breadthFirstTraversal(final T t2) {
        Preconditions.checkNotNull(t2);
        return new FluentIterable<T>(){

            @Override
            public UnmodifiableIterator<T> iterator() {
                return new BreadthFirstIterator(t2);
            }
        };
    }

    private final class BreadthFirstIterator
    extends UnmodifiableIterator<T>
    implements PeekingIterator<T> {
        private final Queue<T> queue = new ArrayDeque();

        BreadthFirstIterator(T t2) {
            this.queue.add(t2);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T peek() {
            return this.queue.element();
        }

        @Override
        public T next() {
            Object t2 = this.queue.remove();
            Iterables.addAll(this.queue, TreeTraverser.this.children(t2));
            return t2;
        }
    }

    private final class PostOrderIterator
    extends AbstractIterator<T> {
        private final ArrayDeque<PostOrderNode<T>> stack = new ArrayDeque();

        PostOrderIterator(T t2) {
            this.stack.addLast(this.expand(t2));
        }

        @Override
        protected T computeNext() {
            while (!this.stack.isEmpty()) {
                PostOrderNode postOrderNode = this.stack.getLast();
                if (postOrderNode.childIterator.hasNext()) {
                    Object t2 = postOrderNode.childIterator.next();
                    this.stack.addLast(this.expand(t2));
                    continue;
                }
                this.stack.removeLast();
                return postOrderNode.root;
            }
            return this.endOfData();
        }

        private PostOrderNode<T> expand(T t2) {
            return new PostOrderNode(t2, TreeTraverser.this.children(t2).iterator());
        }
    }

    private static final class PostOrderNode<T> {
        final T root;
        final Iterator<T> childIterator;

        PostOrderNode(T t2, Iterator<T> iterator) {
            this.root = Preconditions.checkNotNull(t2);
            this.childIterator = Preconditions.checkNotNull(iterator);
        }
    }

    private final class PreOrderIterator
    extends UnmodifiableIterator<T> {
        private final Deque<Iterator<T>> stack = new ArrayDeque();

        PreOrderIterator(T t2) {
            this.stack.addLast(Iterators.singletonIterator(Preconditions.checkNotNull(t2)));
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public T next() {
            Iterator iterator;
            Iterator iterator2 = this.stack.getLast();
            Object t2 = Preconditions.checkNotNull(iterator2.next());
            if (!iterator2.hasNext()) {
                this.stack.removeLast();
            }
            if ((iterator = TreeTraverser.this.children(t2).iterator()).hasNext()) {
                this.stack.addLast(iterator);
            }
            return t2;
        }
    }
}

