/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
final class TopKSelector<T> {
    private final int k;
    private final Comparator<? super T> comparator;
    private final T[] buffer;
    private int bufferSize;
    private @Nullable T threshold;

    public static <T extends Comparable<? super T>> TopKSelector<T> least(int n2) {
        return TopKSelector.least(n2, Ordering.natural());
    }

    public static <T> TopKSelector<T> least(int n2, Comparator<? super T> comparator) {
        return new TopKSelector<T>(comparator, n2);
    }

    public static <T extends Comparable<? super T>> TopKSelector<T> greatest(int n2) {
        return TopKSelector.greatest(n2, Ordering.natural());
    }

    public static <T> TopKSelector<T> greatest(int n2, Comparator<? super T> comparator) {
        return new TopKSelector(Ordering.from(comparator).reverse(), n2);
    }

    private TopKSelector(Comparator<? super T> comparator, int n2) {
        this.comparator = Preconditions.checkNotNull(comparator, "comparator");
        this.k = n2;
        Preconditions.checkArgument(n2 >= 0, "k must be nonnegative, was %s", n2);
        this.buffer = new Object[n2 * 2];
        this.bufferSize = 0;
        this.threshold = null;
    }

    public void offer(@Nullable T t2) {
        if (this.k == 0) {
            return;
        }
        if (this.bufferSize == 0) {
            this.buffer[0] = t2;
            this.threshold = t2;
            this.bufferSize = 1;
        } else if (this.bufferSize < this.k) {
            this.buffer[this.bufferSize++] = t2;
            if (this.comparator.compare(t2, this.threshold) > 0) {
                this.threshold = t2;
            }
        } else if (this.comparator.compare(t2, this.threshold) < 0) {
            this.buffer[this.bufferSize++] = t2;
            if (this.bufferSize == 2 * this.k) {
                this.trim();
            }
        }
    }

    private void trim() {
        int n2;
        int n3 = 0;
        int n4 = 2 * this.k - 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = IntMath.log2(n4 - n3, RoundingMode.CEILING) * 3;
        while (n3 < n4) {
            n2 = n3 + n4 + 1 >>> 1;
            int n8 = this.partition(n3, n4, n2);
            if (n8 > this.k) {
                n4 = n8 - 1;
            } else {
                if (n8 >= this.k) break;
                n3 = Math.max(n8, n3 + 1);
                n5 = n8;
            }
            if (++n6 < n7) continue;
            Arrays.sort(this.buffer, n3, n4, this.comparator);
            break;
        }
        this.bufferSize = this.k;
        this.threshold = this.buffer[n5];
        for (n2 = n5 + 1; n2 < this.k; ++n2) {
            if (this.comparator.compare(this.buffer[n2], this.threshold) <= 0) continue;
            this.threshold = this.buffer[n2];
        }
    }

    private int partition(int n2, int n3, int n4) {
        T t2 = this.buffer[n4];
        this.buffer[n4] = this.buffer[n3];
        int n5 = n2;
        for (int i2 = n2; i2 < n3; ++i2) {
            if (this.comparator.compare(this.buffer[i2], t2) >= 0) continue;
            this.swap(n5, i2);
            ++n5;
        }
        this.buffer[n3] = this.buffer[n5];
        this.buffer[n5] = t2;
        return n5;
    }

    private void swap(int n2, int n3) {
        T t2 = this.buffer[n2];
        this.buffer[n2] = this.buffer[n3];
        this.buffer[n3] = t2;
    }

    TopKSelector<T> combine(TopKSelector<T> topKSelector) {
        for (int i2 = 0; i2 < topKSelector.bufferSize; ++i2) {
            this.offer(topKSelector.buffer[i2]);
        }
        return this;
    }

    public void offerAll(Iterable<? extends T> iterable) {
        this.offerAll(iterable.iterator());
    }

    public void offerAll(Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            this.offer(iterator.next());
        }
    }

    public List<T> topK() {
        Arrays.sort(this.buffer, 0, this.bufferSize, this.comparator);
        if (this.bufferSize > this.k) {
            Arrays.fill(this.buffer, this.k, this.buffer.length, null);
            this.bufferSize = this.k;
            this.threshold = this.buffer[this.k - 1];
        }
        return Collections.unmodifiableList(Arrays.asList(Arrays.copyOf(this.buffer, this.bufferSize)));
    }
}

