/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import com.google.errorprone.annotations.Immutable;
import java.util.AbstractCollection;
import java.util.LinkedHashMap;
import java.util.Map;

@Immutable(containerOf={"R", "C", "V"})
@GwtCompatible
final class SparseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    static final ImmutableTable<Object, Object, Object> EMPTY = new SparseImmutableTable<Object, Object, Object>(ImmutableList.of(), ImmutableSet.of(), ImmutableSet.of());
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final int[] cellRowIndices;
    private final int[] cellColumnInRowIndices;

    SparseImmutableTable(ImmutableList<Table.Cell<R, C, V>> immutableList, ImmutableSet<R> immutableSet, ImmutableSet<C> immutableSet2) {
        ImmutableMap.Builder builder;
        Object object32;
        Object object222;
        ImmutableMap<R, Integer> immutableMap = Maps.indexMap(immutableSet);
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (Object object222 : immutableSet) {
            linkedHashMap.put(object222, new LinkedHashMap());
        }
        LinkedHashMap linkedHashMap2 = Maps.newLinkedHashMap();
        for (Object object32 : immutableSet2) {
            linkedHashMap2.put(object32, new LinkedHashMap());
        }
        object222 = new int[immutableList.size()];
        object32 = new int[immutableList.size()];
        for (int i2 = 0; i2 < immutableList.size(); ++i2) {
            builder = (Table.Cell)immutableList.get(i2);
            Object object4 = builder.getRowKey();
            Object c2 = builder.getColumnKey();
            Object v2 = builder.getValue();
            object222[i2] = (Integer)immutableMap.get(object4);
            Map map = (Map)linkedHashMap.get(object4);
            object32[i2] = map.size();
            Object v3 = map.put(c2, v2);
            this.checkNoDuplicate(object4, c2, v3, v2);
            ((Map)linkedHashMap2.get(c2)).put(object4, v2);
        }
        this.cellRowIndices = (int[])object222;
        this.cellColumnInRowIndices = (int[])object32;
        ImmutableMap.Builder builder2 = new ImmutableMap.Builder(linkedHashMap.size());
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            builder2.put(entry.getKey(), ImmutableMap.copyOf((Map)entry.getValue()));
        }
        this.rowMap = builder2.build();
        builder = new ImmutableMap.Builder(linkedHashMap2.size());
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            builder.put(entry.getKey(), ImmutableMap.copyOf((Map)entry.getValue()));
        }
        this.columnMap = builder.build();
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        ImmutableMap<C, ImmutableMap<R, V>> immutableMap = this.columnMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        ImmutableMap<R, ImmutableMap<C, V>> immutableMap = this.rowMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public int size() {
        return this.cellRowIndices.length;
    }

    @Override
    Table.Cell<R, C, V> getCell(int n2) {
        int n3 = this.cellRowIndices[n2];
        Map.Entry entry = (Map.Entry)((ImmutableSet)this.rowMap.entrySet()).asList().get(n3);
        ImmutableMap immutableMap = (ImmutableMap)entry.getValue();
        int n4 = this.cellColumnInRowIndices[n2];
        Map.Entry entry2 = (Map.Entry)((ImmutableSet)immutableMap.entrySet()).asList().get(n4);
        return SparseImmutableTable.cellOf(entry.getKey(), entry2.getKey(), entry2.getValue());
    }

    @Override
    V getValue(int n2) {
        int n3 = this.cellRowIndices[n2];
        ImmutableMap immutableMap = (ImmutableMap)((ImmutableCollection)this.rowMap.values()).asList().get(n3);
        int n4 = this.cellColumnInRowIndices[n2];
        return (V)((ImmutableCollection)immutableMap.values()).asList().get(n4);
    }

    @Override
    ImmutableTable.SerializedForm createSerializedForm() {
        ImmutableMap immutableMap = Maps.indexMap(this.columnKeySet());
        int[] nArray = new int[((AbstractCollection)((Object)this.cellSet())).size()];
        int n2 = 0;
        for (Table.Cell cell : this.cellSet()) {
            nArray[n2++] = (Integer)immutableMap.get(cell.getColumnKey());
        }
        return ImmutableTable.SerializedForm.create(this, this.cellRowIndices, nArray);
    }
}

