/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SortedMultiset;
import com.google.j2objc.annotations.Weak;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
final class SortedMultisets {
    private SortedMultisets() {
    }

    private static <E> E getElementOrThrow(Multiset.Entry<E> entry) {
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return entry.getElement();
    }

    private static <E> E getElementOrNull(@Nullable Multiset.Entry<E> entry) {
        return entry == null ? null : (E)entry.getElement();
    }

    @GwtIncompatible
    static class NavigableElementSet<E>
    extends ElementSet<E>
    implements NavigableSet<E> {
        NavigableElementSet(SortedMultiset<E> sortedMultiset) {
            super(sortedMultiset);
        }

        @Override
        public E lower(E e2) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(e2, BoundType.OPEN).lastEntry());
        }

        @Override
        public E floor(E e2) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().headMultiset(e2, BoundType.CLOSED).lastEntry());
        }

        @Override
        public E ceiling(E e2) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(e2, BoundType.CLOSED).firstEntry());
        }

        @Override
        public E higher(E e2) {
            return (E)SortedMultisets.getElementOrNull(this.multiset().tailMultiset(e2, BoundType.OPEN).firstEntry());
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new NavigableElementSet(this.multiset().descendingMultiset());
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.descendingSet().iterator();
        }

        @Override
        public E pollFirst() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollFirstEntry());
        }

        @Override
        public E pollLast() {
            return (E)SortedMultisets.getElementOrNull(this.multiset().pollLastEntry());
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
            return new NavigableElementSet<E>(this.multiset().subMultiset(e2, BoundType.forBoolean(bl2), e3, BoundType.forBoolean(bl3)));
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl2) {
            return new NavigableElementSet<E>(this.multiset().headMultiset(e2, BoundType.forBoolean(bl2)));
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl2) {
            return new NavigableElementSet<E>(this.multiset().tailMultiset(e2, BoundType.forBoolean(bl2)));
        }
    }

    static class ElementSet<E>
    extends Multisets.ElementSet<E>
    implements SortedSet<E> {
        @Weak
        private final SortedMultiset<E> multiset;

        ElementSet(SortedMultiset<E> sortedMultiset) {
            this.multiset = sortedMultiset;
        }

        @Override
        final SortedMultiset<E> multiset() {
            return this.multiset;
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.elementIterator(this.multiset().entrySet().iterator());
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.multiset().comparator();
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return this.multiset().subMultiset(e2, BoundType.CLOSED, e3, BoundType.OPEN).elementSet();
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return this.multiset().headMultiset(e2, BoundType.OPEN).elementSet();
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return this.multiset().tailMultiset(e2, BoundType.CLOSED).elementSet();
        }

        @Override
        public E first() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().firstEntry());
        }

        @Override
        public E last() {
            return (E)SortedMultisets.getElementOrThrow(this.multiset().lastEntry());
        }
    }
}

