/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.CartesianList;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.Synchronized;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Sets {
    private Sets() {
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(E e2, E ... EArray) {
        return ImmutableEnumSet.asImmutable(EnumSet.of(e2, EArray));
    }

    @GwtCompatible(serializable=true)
    public static <E extends Enum<E>> ImmutableSet<E> immutableEnumSet(Iterable<E> iterable) {
        if (iterable instanceof ImmutableEnumSet) {
            return (ImmutableEnumSet)iterable;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.isEmpty()) {
                return ImmutableSet.of();
            }
            return ImmutableEnumSet.asImmutable(EnumSet.copyOf(collection));
        }
        Iterator<E> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            EnumSet<Enum> enumSet = EnumSet.of((Enum)iterator.next());
            Iterators.addAll(enumSet, iterator);
            return ImmutableEnumSet.asImmutable(enumSet);
        }
        return ImmutableSet.of();
    }

    public static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return Accumulator.TO_IMMUTABLE_ENUM_SET;
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(Iterable<E> iterable, Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.noneOf(clazz);
        Iterables.addAll(enumSet, iterable);
        return enumSet;
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E> HashSet<E> newHashSet(E ... EArray) {
        HashSet<E> hashSet = Sets.newHashSetWithExpectedSize(EArray.length);
        Collections.addAll(hashSet, EArray);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> iterable) {
        return iterable instanceof Collection ? new HashSet<E>(Collections2.cast(iterable)) : Sets.newHashSet(iterable.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> iterator) {
        HashSet<E> hashSet = Sets.newHashSet();
        Iterators.addAll(hashSet, iterator);
        return hashSet;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int n2) {
        return new HashSet(Maps.capacity(n2));
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <E> Set<E> newConcurrentHashSet(Iterable<? extends E> iterable) {
        Set<E> set = Sets.newConcurrentHashSet();
        Iterables.addAll(set, iterable);
        return set;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <E> LinkedHashSet<E> newLinkedHashSet(Iterable<? extends E> iterable) {
        if (iterable instanceof Collection) {
            return new LinkedHashSet<E>(Collections2.cast(iterable));
        }
        LinkedHashSet<E> linkedHashSet = Sets.newLinkedHashSet();
        Iterables.addAll(linkedHashSet, iterable);
        return linkedHashSet;
    }

    public static <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int n2) {
        return new LinkedHashSet(Maps.capacity(n2));
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> iterable) {
        TreeSet<E> treeSet = Sets.newTreeSet();
        Iterables.addAll(treeSet, iterable);
        return treeSet;
    }

    public static <E> TreeSet<E> newTreeSet(Comparator<? super E> comparator) {
        return new TreeSet<E>(Preconditions.checkNotNull(comparator));
    }

    public static <E> Set<E> newIdentityHashSet() {
        return Collections.newSetFromMap(Maps.newIdentityHashMap());
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet() {
        return new CopyOnWriteArraySet();
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArraySet<E> newCopyOnWriteArraySet(Iterable<? extends E> iterable) {
        Collection<? extends E> collection = iterable instanceof Collection ? Collections2.cast(iterable) : Lists.newArrayList(iterable);
        return new CopyOnWriteArraySet<E>(collection);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection) {
        if (collection instanceof EnumSet) {
            return EnumSet.complementOf((EnumSet)collection);
        }
        Preconditions.checkArgument(!collection.isEmpty(), "collection is empty; use the other version of this method");
        Class clazz = ((Enum)collection.iterator().next()).getDeclaringClass();
        return Sets.makeComplementByHand(collection, clazz);
    }

    public static <E extends Enum<E>> EnumSet<E> complementOf(Collection<E> collection, Class<E> clazz) {
        Preconditions.checkNotNull(collection);
        return collection instanceof EnumSet ? EnumSet.complementOf((EnumSet)collection) : Sets.makeComplementByHand(collection, clazz);
    }

    private static <E extends Enum<E>> EnumSet<E> makeComplementByHand(Collection<E> collection, Class<E> clazz) {
        EnumSet<E> enumSet = EnumSet.allOf(clazz);
        enumSet.removeAll(collection);
        return enumSet;
    }

    @Deprecated
    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return Collections.newSetFromMap(map);
    }

    public static <E> SetView<E> union(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public int size() {
                int n2 = set.size();
                for (Object e2 : set2) {
                    if (set.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return set.isEmpty() && set2.isEmpty();
            }

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<? extends E> itr1;
                    final Iterator<? extends E> itr2;
                    {
                        this.itr1 = set.iterator();
                        this.itr2 = set2.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        if (this.itr1.hasNext()) {
                            return this.itr1.next();
                        }
                        while (this.itr2.hasNext()) {
                            Object e2 = this.itr2.next();
                            if (set.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return Stream.concat(set.stream(), set2.stream().filter(object -> !set.contains(object)));
            }

            @Override
            public Stream<E> parallelStream() {
                return (Stream)this.stream().parallel();
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) || set2.contains(object);
            }

            @Override
            public <S extends Set<E>> S copyInto(S s2) {
                s2.addAll(set);
                s2.addAll(set2);
                return s2;
            }

            @Override
            public ImmutableSet<E> immutableCopy() {
                return ((ImmutableSet.Builder)((ImmutableSet.Builder)new ImmutableSet.Builder().addAll((Iterable)set)).addAll((Iterable)set2)).build();
            }
        };
    }

    public static <E> SetView<E> intersection(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (!set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(set2::contains);
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(set2::contains);
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Object e2 : set) {
                    if (!set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return Collections.disjoint(set2, set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && set2.contains(object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return set.containsAll(collection) && set2.containsAll(collection);
            }
        };
    }

    public static <E> SetView<E> difference(final Set<E> set, final Set<?> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                return new AbstractIterator<E>(){
                    final Iterator<E> itr;
                    {
                        this.itr = set.iterator();
                    }

                    @Override
                    protected E computeNext() {
                        while (this.itr.hasNext()) {
                            Object e2 = this.itr.next();
                            if (set2.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public Stream<E> stream() {
                return set.stream().filter(object -> !set2.contains(object));
            }

            @Override
            public Stream<E> parallelStream() {
                return set.parallelStream().filter(object -> !set2.contains(object));
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Object e2 : set) {
                    if (set2.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return set2.containsAll(set);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) && !set2.contains(object);
            }
        };
    }

    public static <E> SetView<E> symmetricDifference(final Set<? extends E> set, final Set<? extends E> set2) {
        Preconditions.checkNotNull(set, "set1");
        Preconditions.checkNotNull(set2, "set2");
        return new SetView<E>(){

            @Override
            public UnmodifiableIterator<E> iterator() {
                final Iterator iterator = set.iterator();
                final Iterator iterator2 = set2.iterator();
                return new AbstractIterator<E>(){

                    @Override
                    public E computeNext() {
                        Object e2;
                        while (iterator.hasNext()) {
                            e2 = iterator.next();
                            if (set2.contains(e2)) continue;
                            return e2;
                        }
                        while (iterator2.hasNext()) {
                            e2 = iterator2.next();
                            if (set.contains(e2)) continue;
                            return e2;
                        }
                        return this.endOfData();
                    }
                };
            }

            @Override
            public int size() {
                int n2 = 0;
                for (Object e2 : set) {
                    if (set2.contains(e2)) continue;
                    ++n2;
                }
                for (Object e2 : set2) {
                    if (set.contains(e2)) continue;
                    ++n2;
                }
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return set.equals(set2);
            }

            @Override
            public boolean contains(Object object) {
                return set.contains(object) ^ set2.contains(object);
            }
        };
    }

    public static <E> Set<E> filter(Set<E> set, com.google.common.base.Predicate<? super E> predicate) {
        if (set instanceof SortedSet) {
            return Sets.filter((SortedSet)set, predicate);
        }
        if (set instanceof FilteredSet) {
            FilteredSet filteredSet = (FilteredSet)set;
            com.google.common.base.Predicate<? super E> predicate2 = Predicates.and(filteredSet.predicate, predicate);
            return new FilteredSet<E>((Set)filteredSet.unfiltered, predicate2);
        }
        return new FilteredSet<E>(Preconditions.checkNotNull(set), Preconditions.checkNotNull(predicate));
    }

    public static <E> SortedSet<E> filter(SortedSet<E> sortedSet, com.google.common.base.Predicate<? super E> predicate) {
        if (sortedSet instanceof FilteredSet) {
            FilteredSet filteredSet = (FilteredSet)((Object)sortedSet);
            com.google.common.base.Predicate<? super E> predicate2 = Predicates.and(filteredSet.predicate, predicate);
            return new FilteredSortedSet<E>((SortedSet)filteredSet.unfiltered, predicate2);
        }
        return new FilteredSortedSet<E>(Preconditions.checkNotNull(sortedSet), Preconditions.checkNotNull(predicate));
    }

    @GwtIncompatible
    public static <E> NavigableSet<E> filter(NavigableSet<E> navigableSet, com.google.common.base.Predicate<? super E> predicate) {
        if (navigableSet instanceof FilteredSet) {
            FilteredSet filteredSet = (FilteredSet)((Object)navigableSet);
            com.google.common.base.Predicate<? super E> predicate2 = Predicates.and(filteredSet.predicate, predicate);
            return new FilteredNavigableSet<E>((NavigableSet)filteredSet.unfiltered, predicate2);
        }
        return new FilteredNavigableSet<E>(Preconditions.checkNotNull(navigableSet), Preconditions.checkNotNull(predicate));
    }

    public static <B> Set<List<B>> cartesianProduct(List<? extends Set<? extends B>> list) {
        return CartesianSet.create(list);
    }

    @SafeVarargs
    public static <B> Set<List<B>> cartesianProduct(Set<? extends B> ... setArray) {
        return Sets.cartesianProduct(Arrays.asList(setArray));
    }

    @GwtCompatible(serializable=false)
    public static <E> Set<Set<E>> powerSet(Set<E> set) {
        return new PowerSet<E>(set);
    }

    @Beta
    public static <E> Set<Set<E>> combinations(Set<E> set, final int n2) {
        final ImmutableMap<E, Integer> immutableMap = Maps.indexMap(set);
        CollectPreconditions.checkNonnegative(n2, "size");
        Preconditions.checkArgument(n2 <= immutableMap.size(), "size (%s) must be <= set.size() (%s)", n2, immutableMap.size());
        if (n2 == 0) {
            return ImmutableSet.of(ImmutableSet.of());
        }
        if (n2 == immutableMap.size()) {
            return ImmutableSet.of(immutableMap.keySet());
        }
        return new AbstractSet<Set<E>>(){

            @Override
            public boolean contains(@Nullable Object object) {
                if (object instanceof Set) {
                    Set set = (Set)object;
                    return set.size() == n2 && ((AbstractCollection)((Object)immutableMap.keySet())).containsAll(set);
                }
                return false;
            }

            @Override
            public Iterator<Set<E>> iterator() {
                return new AbstractIterator<Set<E>>(){
                    final BitSet bits;
                    {
                        this.bits = new BitSet(immutableMap.size());
                    }

                    @Override
                    protected Set<E> computeNext() {
                        if (this.bits.isEmpty()) {
                            this.bits.set(0, n2);
                        } else {
                            int n2 = this.bits.nextSetBit(0);
                            int n3 = this.bits.nextClearBit(n2);
                            if (n3 == immutableMap.size()) {
                                return (Set)this.endOfData();
                            }
                            this.bits.set(0, n3 - n2 - 1);
                            this.bits.clear(n3 - n2 - 1, n3);
                            this.bits.set(n3);
                        }
                        final BitSet bitSet = (BitSet)this.bits.clone();
                        return new AbstractSet<E>(){

                            @Override
                            public boolean contains(@Nullable Object object) {
                                Integer n2 = (Integer)immutableMap.get(object);
                                return n2 != null && bitSet.get(n2);
                            }

                            @Override
                            public Iterator<E> iterator() {
                                return new AbstractIterator<E>(){
                                    int i = -1;

                                    @Override
                                    protected E computeNext() {
                                        this.i = bitSet.nextSetBit(this.i + 1);
                                        if (this.i == -1) {
                                            return this.endOfData();
                                        }
                                        return ((ImmutableSet)immutableMap.keySet()).asList().get(this.i);
                                    }
                                };
                            }

                            @Override
                            public int size() {
                                return n2;
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return IntMath.binomial(immutableMap.size(), n2);
            }

            @Override
            public String toString() {
                return "Sets.combinations(" + immutableMap.keySet() + ", " + n2 + ")";
            }
        };
    }

    static int hashCodeImpl(Set<?> set) {
        int n2 = 0;
        for (Object obj : set) {
            n2 += obj != null ? obj.hashCode() : 0;
            n2 = ~(~n2);
        }
        return n2;
    }

    static boolean equalsImpl(Set<?> set, @Nullable Object object) {
        if (set == object) {
            return true;
        }
        if (object instanceof Set) {
            Set set2 = (Set)object;
            try {
                return set.size() == set2.size() && set.containsAll(set2);
            }
            catch (ClassCastException | NullPointerException runtimeException) {
                return false;
            }
        }
        return false;
    }

    public static <E> NavigableSet<E> unmodifiableNavigableSet(NavigableSet<E> navigableSet) {
        if (navigableSet instanceof ImmutableCollection || navigableSet instanceof UnmodifiableNavigableSet) {
            return navigableSet;
        }
        return new UnmodifiableNavigableSet<E>(navigableSet);
    }

    @GwtIncompatible
    public static <E> NavigableSet<E> synchronizedNavigableSet(NavigableSet<E> navigableSet) {
        return Synchronized.navigableSet(navigableSet);
    }

    static boolean removeAllImpl(Set<?> set, Iterator<?> iterator) {
        boolean bl2 = false;
        while (iterator.hasNext()) {
            bl2 |= set.remove(iterator.next());
        }
        return bl2;
    }

    static boolean removeAllImpl(Set<?> set, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        if (collection instanceof Multiset) {
            collection = ((Multiset)collection).elementSet();
        }
        if (collection instanceof Set && collection.size() > set.size()) {
            return Iterators.removeAll(set.iterator(), collection);
        }
        return Sets.removeAllImpl(set, collection.iterator());
    }

    @Beta
    @GwtIncompatible
    public static <K extends Comparable<? super K>> NavigableSet<K> subSet(NavigableSet<K> navigableSet, Range<K> range) {
        if (navigableSet.comparator() != null && navigableSet.comparator() != Ordering.natural() && range.hasLowerBound() && range.hasUpperBound()) {
            Preconditions.checkArgument(navigableSet.comparator().compare(range.lowerEndpoint(), range.upperEndpoint()) <= 0, "set is using a custom comparator which is inconsistent with the natural ordering.");
        }
        if (range.hasLowerBound() && range.hasUpperBound()) {
            return navigableSet.subSet(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED, range.upperEndpoint(), range.upperBoundType() == BoundType.CLOSED);
        }
        if (range.hasLowerBound()) {
            return navigableSet.tailSet(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED);
        }
        if (range.hasUpperBound()) {
            return navigableSet.headSet(range.upperEndpoint(), range.upperBoundType() == BoundType.CLOSED);
        }
        return Preconditions.checkNotNull(navigableSet);
    }

    @GwtIncompatible
    static class DescendingSet<E>
    extends ForwardingNavigableSet<E> {
        private final NavigableSet<E> forward;

        DescendingSet(NavigableSet<E> navigableSet) {
            this.forward = navigableSet;
        }

        @Override
        protected NavigableSet<E> delegate() {
            return this.forward;
        }

        @Override
        public E lower(E e2) {
            return this.forward.higher(e2);
        }

        @Override
        public E floor(E e2) {
            return this.forward.ceiling(e2);
        }

        @Override
        public E ceiling(E e2) {
            return this.forward.floor(e2);
        }

        @Override
        public E higher(E e2) {
            return this.forward.lower(e2);
        }

        @Override
        public E pollFirst() {
            return this.forward.pollLast();
        }

        @Override
        public E pollLast() {
            return this.forward.pollFirst();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return this.forward;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.forward.iterator();
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
            return this.forward.subSet(e3, bl3, e2, bl2).descendingSet();
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return this.standardSubSet(e2, e3);
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl2) {
            return this.forward.tailSet(e2, bl2).descendingSet();
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return this.standardHeadSet(e2);
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl2) {
            return this.forward.headSet(e2, bl2).descendingSet();
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return this.standardTailSet(e2);
        }

        @Override
        public Comparator<? super E> comparator() {
            Comparator comparator = this.forward.comparator();
            if (comparator == null) {
                return Ordering.natural().reverse();
            }
            return DescendingSet.reverse(comparator);
        }

        private static <T> Ordering<T> reverse(Comparator<T> comparator) {
            return Ordering.from(comparator).reverse();
        }

        @Override
        public E first() {
            return this.forward.last();
        }

        @Override
        public E last() {
            return this.forward.first();
        }

        @Override
        public Iterator<E> iterator() {
            return this.forward.descendingIterator();
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.standardToArray(TArray);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    static final class UnmodifiableNavigableSet<E>
    extends ForwardingSortedSet<E>
    implements Serializable,
    NavigableSet<E> {
        private final NavigableSet<E> delegate;
        private final SortedSet<E> unmodifiableDelegate;
        private transient @MonotonicNonNull UnmodifiableNavigableSet<E> descendingSet;
        private static final long serialVersionUID = 0L;

        UnmodifiableNavigableSet(NavigableSet<E> navigableSet) {
            this.delegate = Preconditions.checkNotNull(navigableSet);
            this.unmodifiableDelegate = Collections.unmodifiableSortedSet(navigableSet);
        }

        @Override
        protected SortedSet<E> delegate() {
            return this.unmodifiableDelegate;
        }

        @Override
        public boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Stream<E> stream() {
            return this.delegate.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.delegate.parallelStream();
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            this.delegate.forEach(consumer);
        }

        @Override
        public E lower(E e2) {
            return this.delegate.lower(e2);
        }

        @Override
        public E floor(E e2) {
            return this.delegate.floor(e2);
        }

        @Override
        public E ceiling(E e2) {
            return this.delegate.ceiling(e2);
        }

        @Override
        public E higher(E e2) {
            return this.delegate.higher(e2);
        }

        @Override
        public E pollFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public E pollLast() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            UnmodifiableNavigableSet<E> unmodifiableNavigableSet = this.descendingSet;
            if (unmodifiableNavigableSet == null) {
                unmodifiableNavigableSet = this.descendingSet = new UnmodifiableNavigableSet<E>(this.delegate.descendingSet());
                unmodifiableNavigableSet.descendingSet = this;
            }
            return unmodifiableNavigableSet;
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.unmodifiableIterator(this.delegate.descendingIterator());
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
            return Sets.unmodifiableNavigableSet(this.delegate.subSet(e2, bl2, e3, bl3));
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl2) {
            return Sets.unmodifiableNavigableSet(this.delegate.headSet(e2, bl2));
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl2) {
            return Sets.unmodifiableNavigableSet(this.delegate.tailSet(e2, bl2));
        }
    }

    private static final class PowerSet<E>
    extends AbstractSet<Set<E>> {
        final ImmutableMap<E, Integer> inputSet;

        PowerSet(Set<E> set) {
            Preconditions.checkArgument(set.size() <= 30, "Too many elements to create power set: %s > 30", set.size());
            this.inputSet = Maps.indexMap(set);
        }

        @Override
        public int size() {
            return 1 << this.inputSet.size();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new AbstractIndexedListIterator<Set<E>>(this.size()){

                @Override
                protected Set<E> get(int n2) {
                    return new SubSet(inputSet, n2);
                }
            };
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Set) {
                Set set = (Set)object;
                return ((AbstractCollection)((Object)this.inputSet.keySet())).containsAll(set);
            }
            return false;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof PowerSet) {
                PowerSet powerSet = (PowerSet)object;
                return this.inputSet.equals(powerSet.inputSet);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return ((ImmutableSet)this.inputSet.keySet()).hashCode() << this.inputSet.size() - 1;
        }

        @Override
        public String toString() {
            return "powerSet(" + this.inputSet + ")";
        }
    }

    private static final class SubSet<E>
    extends AbstractSet<E> {
        private final ImmutableMap<E, Integer> inputSet;
        private final int mask;

        SubSet(ImmutableMap<E, Integer> immutableMap, int n2) {
            this.inputSet = immutableMap;
            this.mask = n2;
        }

        @Override
        public Iterator<E> iterator() {
            return new UnmodifiableIterator<E>(){
                final ImmutableList<E> elements;
                int remainingSetBits;
                {
                    this.elements = ((ImmutableSet)inputSet.keySet()).asList();
                    this.remainingSetBits = mask;
                }

                @Override
                public boolean hasNext() {
                    return this.remainingSetBits != 0;
                }

                @Override
                public E next() {
                    int n2 = Integer.numberOfTrailingZeros(this.remainingSetBits);
                    if (n2 == 32) {
                        throw new NoSuchElementException();
                    }
                    this.remainingSetBits &= ~(1 << n2);
                    return this.elements.get(n2);
                }
            };
        }

        @Override
        public int size() {
            return Integer.bitCount(this.mask);
        }

        @Override
        public boolean contains(@Nullable Object object) {
            Integer n2 = this.inputSet.get(object);
            return n2 != null && (this.mask & 1 << n2) != 0;
        }
    }

    private static final class CartesianSet<E>
    extends ForwardingCollection<List<E>>
    implements Set<List<E>> {
        private final transient ImmutableList<ImmutableSet<E>> axes;
        private final transient CartesianList<E> delegate;

        static <E> Set<List<E>> create(List<? extends Set<? extends E>> list) {
            ImmutableList.Builder builder = new ImmutableList.Builder(list.size());
            for (Set<E> collection2 : list) {
                ImmutableSet<E> immutableSet = ImmutableSet.copyOf(collection2);
                if (immutableSet.isEmpty()) {
                    return ImmutableSet.of();
                }
                builder.add(immutableSet);
            }
            ImmutableCollection immutableCollection = builder.build();
            ImmutableList immutableList = new ImmutableList<List<E>>((ImmutableList)immutableCollection){
                final /* synthetic */ ImmutableList val$axes;
                {
                    this.val$axes = immutableList;
                }

                @Override
                public int size() {
                    return this.val$axes.size();
                }

                @Override
                public List<E> get(int n2) {
                    return ((ImmutableSet)this.val$axes.get(n2)).asList();
                }

                @Override
                boolean isPartialView() {
                    return true;
                }
            };
            return new CartesianSet(immutableCollection, new CartesianList(immutableList));
        }

        private CartesianSet(ImmutableList<ImmutableSet<E>> immutableList, CartesianList<E> cartesianList) {
            this.axes = immutableList;
            this.delegate = cartesianList;
        }

        @Override
        protected Collection<List<E>> delegate() {
            return this.delegate;
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (object instanceof CartesianSet) {
                CartesianSet cartesianSet = (CartesianSet)object;
                return this.axes.equals(cartesianSet.axes);
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int n2;
            int n3 = this.size() - 1;
            for (n2 = 0; n2 < this.axes.size(); ++n2) {
                n3 *= 31;
                n3 = ~(~n3);
            }
            n2 = 1;
            for (Set set : this.axes) {
                n2 = 31 * n2 + this.size() / set.size() * set.hashCode();
                n2 = ~(~n2);
            }
            return ~(~(n2 += n3));
        }
    }

    @GwtIncompatible
    private static class FilteredNavigableSet<E>
    extends FilteredSortedSet<E>
    implements NavigableSet<E> {
        FilteredNavigableSet(NavigableSet<E> navigableSet, com.google.common.base.Predicate<? super E> predicate) {
            super(navigableSet, predicate);
        }

        NavigableSet<E> unfiltered() {
            return (NavigableSet)this.unfiltered;
        }

        @Override
        public @Nullable E lower(E e2) {
            return Iterators.find(this.unfiltered().headSet(e2, false).descendingIterator(), this.predicate, null);
        }

        @Override
        public @Nullable E floor(E e2) {
            return Iterators.find(this.unfiltered().headSet(e2, true).descendingIterator(), this.predicate, null);
        }

        @Override
        public E ceiling(E e2) {
            return Iterables.find(this.unfiltered().tailSet(e2, true), this.predicate, null);
        }

        @Override
        public E higher(E e2) {
            return Iterables.find(this.unfiltered().tailSet(e2, false), this.predicate, null);
        }

        @Override
        public E pollFirst() {
            return Iterables.removeFirstMatching(this.unfiltered(), this.predicate);
        }

        @Override
        public E pollLast() {
            return Iterables.removeFirstMatching(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return Sets.filter(this.unfiltered().descendingSet(), this.predicate);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return Iterators.filter(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        public E last() {
            return Iterators.find(this.unfiltered().descendingIterator(), this.predicate);
        }

        @Override
        public NavigableSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
            return Sets.filter(this.unfiltered().subSet(e2, bl2, e3, bl3), this.predicate);
        }

        @Override
        public NavigableSet<E> headSet(E e2, boolean bl2) {
            return Sets.filter(this.unfiltered().headSet(e2, bl2), this.predicate);
        }

        @Override
        public NavigableSet<E> tailSet(E e2, boolean bl2) {
            return Sets.filter(this.unfiltered().tailSet(e2, bl2), this.predicate);
        }
    }

    private static class FilteredSortedSet<E>
    extends FilteredSet<E>
    implements SortedSet<E> {
        FilteredSortedSet(SortedSet<E> sortedSet, com.google.common.base.Predicate<? super E> predicate) {
            super(sortedSet, predicate);
        }

        @Override
        public Comparator<? super E> comparator() {
            return ((SortedSet)this.unfiltered).comparator();
        }

        @Override
        public SortedSet<E> subSet(E e2, E e3) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).subSet(e2, e3), this.predicate);
        }

        @Override
        public SortedSet<E> headSet(E e2) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).headSet(e2), this.predicate);
        }

        @Override
        public SortedSet<E> tailSet(E e2) {
            return new FilteredSortedSet<E>(((SortedSet)this.unfiltered).tailSet(e2), this.predicate);
        }

        @Override
        public E first() {
            return Iterators.find(this.unfiltered.iterator(), this.predicate);
        }

        @Override
        public E last() {
            SortedSet sortedSet = (SortedSet)this.unfiltered;
            Object e2;
            while (!this.predicate.apply(e2 = sortedSet.last())) {
                sortedSet = sortedSet.headSet(e2);
            }
            return e2;
        }
    }

    private static class FilteredSet<E>
    extends Collections2.FilteredCollection<E>
    implements Set<E> {
        FilteredSet(Set<E> set, com.google.common.base.Predicate<? super E> predicate) {
            super(set, predicate);
        }

        @Override
        public boolean equals(@Nullable Object object) {
            return Sets.equalsImpl(this, object);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    public static abstract class SetView<E>
    extends AbstractSet<E> {
        private SetView() {
        }

        public ImmutableSet<E> immutableCopy() {
            return ImmutableSet.copyOf(this);
        }

        @CanIgnoreReturnValue
        public <S extends Set<E>> S copyInto(S s2) {
            s2.addAll(this);
            return s2;
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean add(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean addAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean removeAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean removeIf(Predicate<? super E> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        @CanIgnoreReturnValue
        public final boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public abstract UnmodifiableIterator<E> iterator();
    }

    private static final class Accumulator<E extends Enum<E>> {
        static final Collector<Enum<?>, ?, ImmutableSet<? extends Enum<?>>> TO_IMMUTABLE_ENUM_SET = Collector.of(Accumulator::new, Accumulator::add, Accumulator::combine, Accumulator::toImmutableSet, Collector.Characteristics.UNORDERED);
        private @MonotonicNonNull EnumSet<E> set;

        private Accumulator() {
        }

        void add(E e2) {
            if (this.set == null) {
                this.set = EnumSet.of(e2);
            } else {
                this.set.add(e2);
            }
        }

        Accumulator<E> combine(Accumulator<E> accumulator) {
            if (this.set == null) {
                return accumulator;
            }
            if (accumulator.set == null) {
                return this;
            }
            this.set.addAll(accumulator.set);
            return this;
        }

        ImmutableSet<E> toImmutableSet() {
            return this.set == null ? ImmutableSet.of() : ImmutableEnumSet.asImmutable(this.set);
        }
    }

    static abstract class ImprovedAbstractSet<E>
    extends AbstractSet<E> {
        ImprovedAbstractSet() {
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return Sets.removeAllImpl(this, collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return super.retainAll(Preconditions.checkNotNull(collection));
        }
    }
}

