/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.JdkBackedImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true, serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    static final ImmutableMultiset<Object> EMPTY = RegularImmutableMultiset.create(ImmutableList.of());
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.0;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 9;
    private final transient Multisets.ImmutableEntry<E>[] entries;
    private final transient Multisets.ImmutableEntry<E> @Nullable [] hashTable;
    private final transient int size;
    private final transient int hashCode;
    @LazyInit
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> collection) {
        int n2 = collection.size();
        Object[] objectArray = new Multisets.ImmutableEntry[n2];
        if (n2 == 0) {
            return new RegularImmutableMultiset((Multisets.ImmutableEntry<E>[])objectArray, null, 0, 0, ImmutableSet.of());
        }
        int n3 = Hashing.closedTableSize(n2, 1.0);
        int n4 = n3 - 1;
        Multisets.ImmutableEntry[] immutableEntryArray = new Multisets.ImmutableEntry[n3];
        int n5 = 0;
        int n6 = 0;
        long l2 = 0L;
        for (Multiset.Entry<E> entry : collection) {
            Multisets.ImmutableEntry immutableEntry;
            E e2 = Preconditions.checkNotNull(entry.getElement());
            int n7 = entry.getCount();
            int n8 = e2.hashCode();
            int n9 = Hashing.smear(n8) & n4;
            Multisets.ImmutableEntry immutableEntry2 = immutableEntryArray[n9];
            if (immutableEntry2 == null) {
                boolean bl2 = entry instanceof Multisets.ImmutableEntry && !(entry instanceof NonTerminalEntry);
                immutableEntry = bl2 ? (Multisets.ImmutableEntry)entry : new Multisets.ImmutableEntry<E>(e2, n7);
            } else {
                immutableEntry = new NonTerminalEntry<E>(e2, n7, immutableEntry2);
            }
            n6 += n8 ^ n7;
            objectArray[n5++] = immutableEntry;
            immutableEntryArray[n9] = immutableEntry;
            l2 += (long)n7;
        }
        return RegularImmutableMultiset.hashFloodingDetected(immutableEntryArray) ? JdkBackedImmutableMultiset.create(ImmutableList.asImmutableList(objectArray)) : new RegularImmutableMultiset<E>((Multisets.ImmutableEntry<E>[])objectArray, immutableEntryArray, Ints.saturatedCast(l2), n6, null);
    }

    private static boolean hashFloodingDetected(Multisets.ImmutableEntry<?>[] immutableEntryArray) {
        for (int i2 = 0; i2 < immutableEntryArray.length; ++i2) {
            int n2 = 0;
            for (Multisets.ImmutableEntry<?> immutableEntry = immutableEntryArray[i2]; immutableEntry != null; immutableEntry = immutableEntry.nextInBucket()) {
                if (++n2 <= 9) continue;
                return true;
            }
        }
        return false;
    }

    private RegularImmutableMultiset(Multisets.ImmutableEntry<E>[] immutableEntryArray, Multisets.ImmutableEntry<E>[] immutableEntryArray2, int n2, int n3, ImmutableSet<E> immutableSet) {
        this.entries = immutableEntryArray;
        this.hashTable = immutableEntryArray2;
        this.size = n2;
        this.hashCode = n3;
        this.elementSet = immutableSet;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int count(@Nullable Object object) {
        Multisets.ImmutableEntry<E>[] immutableEntryArray = this.hashTable;
        if (object == null || immutableEntryArray == null) {
            return 0;
        }
        int n2 = Hashing.smearedHash(object);
        int n3 = immutableEntryArray.length - 1;
        for (Multisets.ImmutableEntry<E> immutableEntry = immutableEntryArray[n2 & n3]; immutableEntry != null; immutableEntry = immutableEntry.nextInBucket()) {
            if (!Objects.equal(object, immutableEntry.getElement())) continue;
            return immutableEntry.getCount();
        }
        return 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> immutableSet = this.elementSet;
        return immutableSet == null ? (this.elementSet = new ImmutableMultiset.ElementSet(Arrays.asList(this.entries), this)) : immutableSet;
    }

    @Override
    Multiset.Entry<E> getEntry(int n2) {
        return this.entries[n2];
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private static final class NonTerminalEntry<E>
    extends Multisets.ImmutableEntry<E> {
        private final Multisets.ImmutableEntry<E> nextInBucket;

        NonTerminalEntry(E e2, int n2, Multisets.ImmutableEntry<E> immutableEntry) {
            super(e2, n2);
            this.nextInBucket = immutableEntry;
        }

        @Override
        public Multisets.ImmutableEntry<E> nextInBucket() {
            return this.nextInBucket;
        }
    }
}

