/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.JdkBackedImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    static final ImmutableMap<Object, Object> EMPTY = new RegularImmutableMap(ImmutableMap.EMPTY_ENTRY_ARRAY, null, 0);
    @VisibleForTesting
    static final double MAX_LOAD_FACTOR = 1.2;
    @VisibleForTesting
    static final double HASH_FLOODING_FPP = 0.001;
    @VisibleForTesting
    static final int MAX_HASH_BUCKET_LENGTH = 8;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient ImmutableMapEntry<K, V>[] table;
    private final transient int mask;
    private static final long serialVersionUID = 0L;

    static <K, V> ImmutableMap<K, V> fromEntries(Map.Entry<K, V> ... entryArray) {
        return RegularImmutableMap.fromEntryArray(entryArray.length, entryArray);
    }

    static <K, V> ImmutableMap<K, V> fromEntryArray(int n2, Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n2, entryArray.length);
        if (n2 == 0) {
            return (RegularImmutableMap)EMPTY;
        }
        Map.Entry<K, V>[] entryArray2 = n2 == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n2);
        int n3 = Hashing.closedTableSize(n2, 1.2);
        ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n3);
        int n4 = n3 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            Map.Entry<K, V> entry = entryArray[i2];
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k2, v2);
            int n5 = Hashing.smear(k2.hashCode()) & n4;
            ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n5];
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntry == null ? RegularImmutableMap.makeImmutable(entry, k2, v2) : new ImmutableMapEntry.NonTerminalImmutableMapEntry<K, V>(k2, v2, immutableMapEntry);
            immutableMapEntryArray[n5] = immutableMapEntry2;
            entryArray2[i2] = immutableMapEntry2;
            int n6 = RegularImmutableMap.checkNoConflictInKeyBucket(k2, immutableMapEntry2, immutableMapEntry);
            if (n6 <= 8) continue;
            return JdkBackedImmutableMap.create(n2, entryArray);
        }
        return new RegularImmutableMap<K, V>(entryArray2, immutableMapEntryArray, n4);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry, K k2, V v2) {
        boolean bl2 = entry instanceof ImmutableMapEntry && ((ImmutableMapEntry)entry).isReusable();
        return bl2 ? (ImmutableMapEntry)entry : new ImmutableMapEntry<K, V>(k2, v2);
    }

    static <K, V> ImmutableMapEntry<K, V> makeImmutable(Map.Entry<K, V> entry) {
        return RegularImmutableMap.makeImmutable(entry, entry.getKey(), entry.getValue());
    }

    private RegularImmutableMap(Map.Entry<K, V>[] entryArray, ImmutableMapEntry<K, V>[] immutableMapEntryArray, int n2) {
        this.entries = entryArray;
        this.table = immutableMapEntryArray;
        this.mask = n2;
    }

    @CanIgnoreReturnValue
    static int checkNoConflictInKeyBucket(Object object, Map.Entry<?, ?> entry, @Nullable ImmutableMapEntry<?, ?> immutableMapEntry) {
        int n2 = 0;
        while (immutableMapEntry != null) {
            RegularImmutableMap.checkNoConflict(!object.equals(immutableMapEntry.getKey()), "key", entry, immutableMapEntry);
            ++n2;
            immutableMapEntry = immutableMapEntry.getNextInKeyBucket();
        }
        return n2;
    }

    @Override
    public V get(@Nullable Object object) {
        return RegularImmutableMap.get(object, this.table, this.mask);
    }

    static <V> @Nullable V get(@Nullable Object object, ImmutableMapEntry<?, V> @Nullable [] immutableMapEntryArray, int n2) {
        if (object == null || immutableMapEntryArray == null) {
            return null;
        }
        int n3 = Hashing.smear(object.hashCode()) & n2;
        for (ImmutableMapEntry<?, V> immutableMapEntry = immutableMapEntryArray[n3]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInKeyBucket()) {
            Object k2 = immutableMapEntry.getKey();
            if (!object.equals(k2)) continue;
            return immutableMapEntry.getValue();
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (Map.Entry<K, V> entry : this.entries) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new KeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @GwtCompatible(emulated=true)
    private static final class Values<K, V>
    extends ImmutableList<V> {
        final RegularImmutableMap<K, V> map;

        Values(RegularImmutableMap<K, V> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        public V get(int n2) {
            return this.map.entries[n2].getValue();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new SerializedForm<V>(this.map);
        }

        @GwtIncompatible
        private static class SerializedForm<V>
        implements Serializable {
            final ImmutableMap<?, V> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<?, V> immutableMap) {
                this.map = immutableMap;
            }

            Object readResolve() {
                return this.map.values();
            }
        }
    }

    @GwtCompatible(emulated=true)
    private static final class KeySet<K, V>
    extends IndexedImmutableSet<K> {
        private final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        K get(int n2) {
            return this.map.entries[n2].getKey();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new SerializedForm<K>(this.map);
        }

        @GwtIncompatible
        private static class SerializedForm<K>
        implements Serializable {
            final ImmutableMap<K, ?> map;
            private static final long serialVersionUID = 0L;

            SerializedForm(ImmutableMap<K, ?> immutableMap) {
                this.map = immutableMap;
            }

            Object readResolve() {
                return this.map.keySet();
            }
        }
    }
}

