/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.JdkBackedImmutableBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.j2objc.annotations.RetainedWith;
import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final RegularImmutableBiMap<Object, Object> EMPTY = new RegularImmutableBiMap(null, null, ImmutableMap.EMPTY_ENTRY_ARRAY, 0, 0);
    static final double MAX_LOAD_FACTOR = 1.2;
    private final transient ImmutableMapEntry<K, V>[] keyTable;
    private final transient ImmutableMapEntry<K, V>[] valueTable;
    @VisibleForTesting
    final transient Map.Entry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    @LazyInit
    @RetainedWith
    private transient ImmutableBiMap<V, K> inverse;

    static <K, V> ImmutableBiMap<K, V> fromEntries(Map.Entry<K, V> ... entryArray) {
        return RegularImmutableBiMap.fromEntryArray(entryArray.length, entryArray);
    }

    static <K, V> ImmutableBiMap<K, V> fromEntryArray(int n2, Map.Entry<K, V>[] entryArray) {
        Preconditions.checkPositionIndex(n2, entryArray.length);
        int n3 = Hashing.closedTableSize(n2, 1.2);
        int n4 = n3 - 1;
        ImmutableMapEntry<K, V>[] immutableMapEntryArray = ImmutableMapEntry.createEntryArray(n3);
        ImmutableMapEntry<K, V>[] immutableMapEntryArray2 = ImmutableMapEntry.createEntryArray(n3);
        Map.Entry<K, V>[] entryArray2 = n2 == entryArray.length ? entryArray : ImmutableMapEntry.createEntryArray(n2);
        int n5 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Map.Entry<K, V> entry = entryArray[i2];
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            CollectPreconditions.checkEntryNotNull(k2, v2);
            int n6 = k2.hashCode();
            int n7 = v2.hashCode();
            int n8 = Hashing.smear(n6) & n4;
            int n9 = Hashing.smear(n7) & n4;
            ImmutableMapEntry immutableMapEntry = immutableMapEntryArray[n8];
            int n10 = RegularImmutableMap.checkNoConflictInKeyBucket(k2, entry, immutableMapEntry);
            ImmutableMapEntry immutableMapEntry2 = immutableMapEntryArray2[n9];
            int n11 = RegularImmutableBiMap.checkNoConflictInValueBucket(v2, entry, immutableMapEntry2);
            if (n10 > 8 || n11 > 8) {
                return JdkBackedImmutableBiMap.create(n2, entryArray);
            }
            ImmutableMapEntry immutableMapEntry3 = immutableMapEntry2 == null && immutableMapEntry == null ? RegularImmutableMap.makeImmutable(entry, k2, v2) : new ImmutableMapEntry.NonTerminalImmutableBiMapEntry<K, V>(k2, v2, immutableMapEntry, immutableMapEntry2);
            immutableMapEntryArray[n8] = immutableMapEntry3;
            immutableMapEntryArray2[n9] = immutableMapEntry3;
            entryArray2[i2] = immutableMapEntry3;
            n5 += n6 ^ n7;
        }
        return new RegularImmutableBiMap(immutableMapEntryArray, immutableMapEntryArray2, entryArray2, n4, n5);
    }

    private RegularImmutableBiMap(ImmutableMapEntry<K, V>[] immutableMapEntryArray, ImmutableMapEntry<K, V>[] immutableMapEntryArray2, Map.Entry<K, V>[] entryArray, int n2, int n3) {
        this.keyTable = immutableMapEntryArray;
        this.valueTable = immutableMapEntryArray2;
        this.entries = entryArray;
        this.mask = n2;
        this.hashCode = n3;
    }

    @CanIgnoreReturnValue
    private static int checkNoConflictInValueBucket(Object object, Map.Entry<?, ?> entry, @Nullable ImmutableMapEntry<?, ?> immutableMapEntry) {
        int n2 = 0;
        while (immutableMapEntry != null) {
            RegularImmutableBiMap.checkNoConflict(!object.equals(immutableMapEntry.getValue()), "value", entry, immutableMapEntry);
            ++n2;
            immutableMapEntry = immutableMapEntry.getNextInValueBucket();
        }
        return n2;
    }

    @Override
    public @Nullable V get(@Nullable Object object) {
        return this.keyTable == null ? null : (V)RegularImmutableMap.get(object, this.keyTable, this.mask);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        for (Map.Entry<K, V> entry : this.entries) {
            biConsumer.accept(entry.getKey(), entry.getValue());
        }
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.isEmpty()) {
            return ImmutableBiMap.of();
        }
        Inverse inverse = this.inverse;
        return inverse == null ? (this.inverse = new Inverse()) : inverse;
    }

    private static class InverseSerializedForm<K, V>
    implements Serializable {
        private final ImmutableBiMap<K, V> forward;
        private static final long serialVersionUID = 1L;

        InverseSerializedForm(ImmutableBiMap<K, V> immutableBiMap) {
            this.forward = immutableBiMap;
        }

        Object readResolve() {
            return this.forward.inverse();
        }
    }

    private final class Inverse
    extends ImmutableBiMap<V, K> {
        private Inverse() {
        }

        @Override
        public int size() {
            return this.inverse().size();
        }

        @Override
        public ImmutableBiMap<K, V> inverse() {
            return RegularImmutableBiMap.this;
        }

        @Override
        public void forEach(BiConsumer<? super V, ? super K> biConsumer) {
            Preconditions.checkNotNull(biConsumer);
            RegularImmutableBiMap.this.forEach((? super K object, ? super V object2) -> biConsumer.accept((Object)object2, (Object)object));
        }

        @Override
        public K get(@Nullable Object object) {
            if (object == null || RegularImmutableBiMap.this.valueTable == null) {
                return null;
            }
            int n2 = Hashing.smear(object.hashCode()) & RegularImmutableBiMap.this.mask;
            for (ImmutableMapEntry immutableMapEntry = RegularImmutableBiMap.this.valueTable[n2]; immutableMapEntry != null; immutableMapEntry = immutableMapEntry.getNextInValueBucket()) {
                if (!object.equals(immutableMapEntry.getValue())) continue;
                return immutableMapEntry.getKey();
            }
            return null;
        }

        @Override
        ImmutableSet<V> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<V, K>> createEntrySet() {
            return new InverseEntrySet();
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        Object writeReplace() {
            return new InverseSerializedForm(RegularImmutableBiMap.this);
        }

        final class InverseEntrySet
        extends ImmutableMapEntrySet<V, K> {
            InverseEntrySet() {
            }

            @Override
            ImmutableMap<V, K> map() {
                return Inverse.this;
            }

            @Override
            boolean isHashCodeFast() {
                return true;
            }

            @Override
            public int hashCode() {
                return RegularImmutableBiMap.this.hashCode;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<V, K>> iterator() {
                return this.asList().iterator();
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<V, K>> consumer) {
                this.asList().forEach(consumer);
            }

            @Override
            ImmutableList<Map.Entry<V, K>> createAsList() {
                return new ImmutableAsList<Map.Entry<V, K>>(){

                    @Override
                    public Map.Entry<V, K> get(int n2) {
                        Map.Entry entry = RegularImmutableBiMap.this.entries[n2];
                        return Maps.immutableEntry(entry.getValue(), entry.getKey());
                    }

                    @Override
                    ImmutableCollection<Map.Entry<V, K>> delegateCollection() {
                        return InverseEntrySet.this;
                    }
                };
            }
        }
    }
}

