/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.RangeGwtSerializationDependencies;
import java.io.Serializable;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Range<C extends Comparable>
extends RangeGwtSerializationDependencies
implements Predicate<C>,
Serializable {
    private static final Range<Comparable> ALL = new Range(Cut.belowAll(), Cut.aboveAll());
    final Cut<C> lowerBound;
    final Cut<C> upperBound;
    private static final long serialVersionUID = 0L;

    static <C extends Comparable<?>> Function<Range<C>, Cut<C>> lowerBoundFn() {
        return LowerBoundFn.INSTANCE;
    }

    static <C extends Comparable<?>> Function<Range<C>, Cut<C>> upperBoundFn() {
        return UpperBoundFn.INSTANCE;
    }

    static <C extends Comparable<?>> Ordering<Range<C>> rangeLexOrdering() {
        return RangeLexOrdering.INSTANCE;
    }

    static <C extends Comparable<?>> Range<C> create(Cut<C> cut, Cut<C> cut2) {
        return new Range<C>(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> open(C c2, C c3) {
        return Range.create(Cut.aboveValue(c2), Cut.belowValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> closed(C c2, C c3) {
        return Range.create(Cut.belowValue(c2), Cut.aboveValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> closedOpen(C c2, C c3) {
        return Range.create(Cut.belowValue(c2), Cut.belowValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> openClosed(C c2, C c3) {
        return Range.create(Cut.aboveValue(c2), Cut.aboveValue(c3));
    }

    public static <C extends Comparable<?>> Range<C> range(C c2, BoundType boundType, C c3, BoundType boundType2) {
        Preconditions.checkNotNull(boundType);
        Preconditions.checkNotNull(boundType2);
        Cut<C> cut = boundType == BoundType.OPEN ? Cut.aboveValue(c2) : Cut.belowValue(c2);
        Cut<C> cut2 = boundType2 == BoundType.OPEN ? Cut.belowValue(c3) : Cut.aboveValue(c3);
        return Range.create(cut, cut2);
    }

    public static <C extends Comparable<?>> Range<C> lessThan(C c2) {
        return Range.create(Cut.belowAll(), Cut.belowValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> atMost(C c2) {
        return Range.create(Cut.belowAll(), Cut.aboveValue(c2));
    }

    public static <C extends Comparable<?>> Range<C> upTo(C c2, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return Range.lessThan(c2);
            }
            case CLOSED: {
                return Range.atMost(c2);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> greaterThan(C c2) {
        return Range.create(Cut.aboveValue(c2), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> atLeast(C c2) {
        return Range.create(Cut.belowValue(c2), Cut.aboveAll());
    }

    public static <C extends Comparable<?>> Range<C> downTo(C c2, BoundType boundType) {
        switch (boundType) {
            case OPEN: {
                return Range.greaterThan(c2);
            }
            case CLOSED: {
                return Range.atLeast(c2);
            }
        }
        throw new AssertionError();
    }

    public static <C extends Comparable<?>> Range<C> all() {
        return ALL;
    }

    public static <C extends Comparable<?>> Range<C> singleton(C c2) {
        return Range.closed(c2, c2);
    }

    public static <C extends Comparable<?>> Range<C> encloseAll(Iterable<C> iterable) {
        Object object;
        Object object2;
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof SortedSet) {
            object2 = Range.cast(iterable);
            object = object2.comparator();
            if (Ordering.natural().equals(object) || object == null) {
                return Range.closed((Comparable)object2.first(), (Comparable)object2.last());
            }
        }
        object2 = iterable.iterator();
        Object object3 = object = (Comparable)Preconditions.checkNotNull(object2.next());
        while (object2.hasNext()) {
            Comparable comparable = (Comparable)Preconditions.checkNotNull(object2.next());
            object = Ordering.natural().min(object, comparable);
            object3 = Ordering.natural().max(object3, comparable);
        }
        return Range.closed(object, object3);
    }

    private Range(Cut<C> cut, Cut<C> cut2) {
        this.lowerBound = Preconditions.checkNotNull(cut);
        this.upperBound = Preconditions.checkNotNull(cut2);
        if (cut.compareTo(cut2) > 0 || cut == Cut.aboveAll() || cut2 == Cut.belowAll()) {
            throw new IllegalArgumentException("Invalid range: " + Range.toString(cut, cut2));
        }
    }

    public boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll();
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll();
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public boolean contains(C c2) {
        Preconditions.checkNotNull(c2);
        return this.lowerBound.isLessThan(c2) && !this.upperBound.isLessThan(c2);
    }

    @Override
    @Deprecated
    public boolean apply(C c2) {
        return this.contains(c2);
    }

    public boolean containsAll(Iterable<? extends C> iterable) {
        if (Iterables.isEmpty(iterable)) {
            return true;
        }
        if (iterable instanceof SortedSet) {
            SortedSet<? extends C> sortedSet = Range.cast(iterable);
            Object object = sortedSet.comparator();
            if (Ordering.natural().equals(object) || object == null) {
                return this.contains((Comparable)sortedSet.first()) && this.contains((Comparable)sortedSet.last());
            }
        }
        for (Object object : iterable) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(Range<C> range) {
        return this.lowerBound.compareTo(range.lowerBound) <= 0 && this.upperBound.compareTo(range.upperBound) >= 0;
    }

    public boolean isConnected(Range<C> range) {
        return this.lowerBound.compareTo(range.upperBound) <= 0 && range.lowerBound.compareTo(this.upperBound) <= 0;
    }

    public Range<C> intersection(Range<C> range) {
        int n2 = this.lowerBound.compareTo(range.lowerBound);
        int n3 = this.upperBound.compareTo(range.upperBound);
        if (n2 >= 0 && n3 <= 0) {
            return this;
        }
        if (n2 <= 0 && n3 >= 0) {
            return range;
        }
        Cut<C> cut = n2 >= 0 ? this.lowerBound : range.lowerBound;
        Cut<C> cut2 = n3 <= 0 ? this.upperBound : range.upperBound;
        return Range.create(cut, cut2);
    }

    public Range<C> gap(Range<C> range) {
        boolean bl2 = this.lowerBound.compareTo(range.lowerBound) < 0;
        Range<C> range2 = bl2 ? this : range;
        Range<C> range3 = bl2 ? range : this;
        return Range.create(range2.upperBound, range3.lowerBound);
    }

    public Range<C> span(Range<C> range) {
        int n2 = this.lowerBound.compareTo(range.lowerBound);
        int n3 = this.upperBound.compareTo(range.upperBound);
        if (n2 <= 0 && n3 >= 0) {
            return this;
        }
        if (n2 >= 0 && n3 <= 0) {
            return range;
        }
        Cut<C> cut = n2 <= 0 ? this.lowerBound : range.lowerBound;
        Cut<C> cut2 = n3 >= 0 ? this.upperBound : range.upperBound;
        return Range.create(cut, cut2);
    }

    public Range<C> canonical(DiscreteDomain<C> discreteDomain) {
        Preconditions.checkNotNull(discreteDomain);
        Cut<C> cut = this.lowerBound.canonical(discreteDomain);
        Cut<C> cut2 = this.upperBound.canonical(discreteDomain);
        return cut == this.lowerBound && cut2 == this.upperBound ? this : Range.create(cut, cut2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.lowerBound.equals(range.lowerBound) && this.upperBound.equals(range.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    private static String toString(Cut<?> cut, Cut<?> cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append("..");
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    private static <T> SortedSet<T> cast(Iterable<T> iterable) {
        return (SortedSet)iterable;
    }

    Object readResolve() {
        if (this.equals(ALL)) {
            return Range.all();
        }
        return this;
    }

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }

    private static class RangeLexOrdering
    extends Ordering<Range<?>>
    implements Serializable {
        static final Ordering<Range<?>> INSTANCE = new RangeLexOrdering();
        private static final long serialVersionUID = 0L;

        private RangeLexOrdering() {
        }

        @Override
        public int compare(Range<?> range, Range<?> range2) {
            return ComparisonChain.start().compare(range.lowerBound, range2.lowerBound).compare(range.upperBound, range2.upperBound).result();
        }
    }

    static class UpperBoundFn
    implements Function<Range, Cut> {
        static final UpperBoundFn INSTANCE = new UpperBoundFn();

        UpperBoundFn() {
        }

        @Override
        public Cut apply(Range range) {
            return range.upperBound;
        }
    }

    static class LowerBoundFn
    implements Function<Range, Cut> {
        static final LowerBoundFn INSTANCE = new LowerBoundFn();

        LowerBoundFn() {
        }

        @Override
        public Cut apply(Range range) {
            return range.lowerBound;
        }
    }
}

