/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Strings;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;

@GwtCompatible(emulated=true)
final class Platform {
    private static final String GWT_RPC_PROPERTY_NAME = "guava.gwt.emergency_reenable_rpc";

    static <K, V> Map<K, V> newHashMapWithExpectedSize(int n2) {
        return Maps.newHashMapWithExpectedSize(n2);
    }

    static <K, V> Map<K, V> newLinkedHashMapWithExpectedSize(int n2) {
        return Maps.newLinkedHashMapWithExpectedSize(n2);
    }

    static <E> Set<E> newHashSetWithExpectedSize(int n2) {
        return Sets.newHashSetWithExpectedSize(n2);
    }

    static <E> Set<E> newLinkedHashSetWithExpectedSize(int n2) {
        return Sets.newLinkedHashSetWithExpectedSize(n2);
    }

    static <K, V> Map<K, V> preservesInsertionOrderOnPutsMap() {
        return Maps.newLinkedHashMap();
    }

    static <E> Set<E> preservesInsertionOrderOnAddsSet() {
        return Sets.newLinkedHashSet();
    }

    static <T> T[] newArray(T[] TArray, int n2) {
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        return objectArray;
    }

    static <T> T[] copy(Object[] objectArray, int n2, int n3, T[] TArray) {
        return Arrays.copyOfRange(objectArray, n2, n3, TArray.getClass());
    }

    static MapMaker tryWeakKeys(MapMaker mapMaker) {
        return mapMaker.weakKeys();
    }

    static int reduceIterationsIfGwt(int n2) {
        return n2;
    }

    static int reduceExponentIfGwt(int n2) {
        return n2;
    }

    static void checkGwtRpcEnabled() {
        if (!Boolean.parseBoolean(System.getProperty(GWT_RPC_PROPERTY_NAME, "true"))) {
            throw new UnsupportedOperationException(Strings.lenientFormat("We are removing GWT-RPC support for Guava types. You can temporarily reenable support by setting the system property %s to true. For more about system properties, see %s. For more about Guava's GWT-RPC support, see %s.", GWT_RPC_PROPERTY_NAME, "https://stackoverflow.com/q/5189914/28465", "https://groups.google.com/d/msg/guava-announce/zHZTFg7YF3o/rQNnwdHeEwAJ"));
        }
    }

    private Platform() {
    }
}

