/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Platform;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible
    public static <T> T[] newArray(Class<T> clazz, int n2) {
        return (Object[])Array.newInstance(clazz, n2);
    }

    public static <T> T[] newArray(T[] TArray, int n2) {
        return Platform.newArray(TArray, n2);
    }

    @GwtIncompatible
    public static <T> T[] concat(T[] TArray, T[] TArray2, Class<T> clazz) {
        T[] TArray3 = ObjectArrays.newArray(clazz, TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, TArray3, 0, TArray.length);
        System.arraycopy(TArray2, 0, TArray3, TArray.length, TArray2.length);
        return TArray3;
    }

    public static <T> T[] concat(@Nullable T t2, T[] TArray) {
        T[] TArray2 = ObjectArrays.newArray(TArray, TArray.length + 1);
        TArray2[0] = t2;
        System.arraycopy(TArray, 0, TArray2, 1, TArray.length);
        return TArray2;
    }

    public static <T> T[] concat(T[] TArray, @Nullable T t2) {
        T[] TArray2 = Arrays.copyOf(TArray, TArray.length + 1);
        TArray2[TArray.length] = t2;
        return TArray2;
    }

    static <T> T[] toArrayImpl(Collection<?> collection, T[] TArray) {
        int n2 = collection.size();
        if (TArray.length < n2) {
            TArray = ObjectArrays.newArray(TArray, n2);
        }
        ObjectArrays.fillArray(collection, TArray);
        if (TArray.length > n2) {
            TArray[n2] = null;
        }
        return TArray;
    }

    static <T> T[] toArrayImpl(Object[] objectArray, int n2, int n3, T[] TArray) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, objectArray.length);
        if (TArray.length < n3) {
            TArray = ObjectArrays.newArray(TArray, n3);
        } else if (TArray.length > n3) {
            TArray[n3] = null;
        }
        System.arraycopy(objectArray, n2, TArray, 0, n3);
        return TArray;
    }

    static Object[] toArrayImpl(Collection<?> collection) {
        return ObjectArrays.fillArray(collection, new Object[collection.size()]);
    }

    static Object[] copyAsObjectArray(Object[] objectArray, int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n2 + n3, objectArray.length);
        if (n3 == 0) {
            return new Object[0];
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, n2, objectArray2, 0, n3);
        return objectArray2;
    }

    @CanIgnoreReturnValue
    private static Object[] fillArray(Iterable<?> iterable, Object[] objectArray) {
        int n2 = 0;
        for (Object obj : iterable) {
            objectArray[n2++] = obj;
        }
        return objectArray;
    }

    static void swap(Object[] objectArray, int n2, int n3) {
        Object object = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object;
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object ... objectArray) {
        return ObjectArrays.checkElementsNotNull(objectArray, objectArray.length);
    }

    @CanIgnoreReturnValue
    static Object[] checkElementsNotNull(Object[] objectArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            ObjectArrays.checkElementNotNull(objectArray[i2], i2);
        }
        return objectArray;
    }

    @CanIgnoreReturnValue
    static Object checkElementNotNull(Object object, int n2) {
        if (object == null) {
            throw new NullPointerException("at index " + n2);
        }
        return object;
    }
}

