/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.Weak;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtCompatible
public final class MinMaxPriorityQueue<E>
extends AbstractQueue<E> {
    private final Heap minHeap;
    private final Heap maxHeap;
    @VisibleForTesting
    final int maximumSize;
    private Object[] queue;
    private int size;
    private int modCount;
    private static final int EVEN_POWERS_OF_TWO = 0x55555555;
    private static final int ODD_POWERS_OF_TWO = -1431655766;
    private static final int DEFAULT_CAPACITY = 11;

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create() {
        return new Builder(Ordering.natural()).create();
    }

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create(Iterable<? extends E> iterable) {
        return new Builder(Ordering.natural()).create(iterable);
    }

    public static <B> Builder<B> orderedBy(Comparator<B> comparator) {
        return new Builder(comparator);
    }

    public static Builder<Comparable> expectedSize(int n2) {
        return new Builder(Ordering.natural()).expectedSize(n2);
    }

    public static Builder<Comparable> maximumSize(int n2) {
        return new Builder(Ordering.natural()).maximumSize(n2);
    }

    private MinMaxPriorityQueue(Builder<? super E> builder, int n2) {
        Ordering ordering = ((Builder)builder).ordering();
        this.minHeap = new Heap(ordering);
        this.minHeap.otherHeap = this.maxHeap = new Heap(ordering.reverse());
        this.maxHeap.otherHeap = this.minHeap;
        this.maximumSize = ((Builder)builder).maximumSize;
        this.queue = new Object[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean add(E e2) {
        this.offer(e2);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl2 = false;
        for (E e2 : collection) {
            this.offer(e2);
            bl2 = true;
        }
        return bl2;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean offer(E e2) {
        Preconditions.checkNotNull(e2);
        ++this.modCount;
        int n2 = this.size++;
        this.growIfNeeded();
        this.heapForIndex(n2).bubbleUp(n2, e2);
        return this.size <= this.maximumSize || this.pollLast() != e2;
    }

    @Override
    @CanIgnoreReturnValue
    public E poll() {
        return this.isEmpty() ? null : (E)this.removeAndGet(0);
    }

    E elementData(int n2) {
        return (E)this.queue[n2];
    }

    @Override
    public E peek() {
        return this.isEmpty() ? null : (E)this.elementData(0);
    }

    private int getMaxElementIndex() {
        switch (this.size) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        return this.maxHeap.compareElements(1, 2) <= 0 ? 1 : 2;
    }

    @CanIgnoreReturnValue
    public E pollFirst() {
        return this.poll();
    }

    @CanIgnoreReturnValue
    public E removeFirst() {
        return this.remove();
    }

    public E peekFirst() {
        return this.peek();
    }

    @CanIgnoreReturnValue
    public E pollLast() {
        return this.isEmpty() ? null : (E)this.removeAndGet(this.getMaxElementIndex());
    }

    @CanIgnoreReturnValue
    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.removeAndGet(this.getMaxElementIndex());
    }

    public E peekLast() {
        return this.isEmpty() ? null : (E)this.elementData(this.getMaxElementIndex());
    }

    @VisibleForTesting
    @CanIgnoreReturnValue
    MoveDesc<E> removeAt(int n2) {
        Preconditions.checkPositionIndex(n2, this.size);
        ++this.modCount;
        --this.size;
        if (this.size == n2) {
            this.queue[this.size] = null;
            return null;
        }
        E e2 = this.elementData(this.size);
        int n3 = this.heapForIndex(this.size).swapWithConceptuallyLastElement(e2);
        if (n3 == n2) {
            this.queue[this.size] = null;
            return null;
        }
        E e3 = this.elementData(this.size);
        this.queue[this.size] = null;
        MoveDesc<E> moveDesc = this.fillHole(n2, e3);
        if (n3 < n2) {
            if (moveDesc == null) {
                return new MoveDesc<E>(e2, e3);
            }
            return new MoveDesc<E>(e2, moveDesc.replaced);
        }
        return moveDesc;
    }

    private MoveDesc<E> fillHole(int n2, E e2) {
        int n3;
        Heap heap = this.heapForIndex(n2);
        int n4 = heap.bubbleUpAlternatingLevels(n3 = heap.fillHoleAt(n2), e2);
        if (n4 == n3) {
            return heap.tryCrossOverAndBubbleUp(n2, n3, e2);
        }
        return n4 < n2 ? new MoveDesc<E>(e2, this.elementData(n2)) : null;
    }

    private E removeAndGet(int n2) {
        E e2 = this.elementData(n2);
        this.removeAt(n2);
        return e2;
    }

    private Heap heapForIndex(int n2) {
        return MinMaxPriorityQueue.isEvenLevel(n2) ? this.minHeap : this.maxHeap;
    }

    @VisibleForTesting
    static boolean isEvenLevel(int n2) {
        int n3 = ~(~(n2 + 1));
        Preconditions.checkState(n3 > 0, "negative index");
        return (n3 & 0x55555555) > (n3 & 0xAAAAAAAA);
    }

    @VisibleForTesting
    boolean isIntact() {
        for (int i2 = 1; i2 < this.size; ++i2) {
            if (this.heapForIndex(i2).verifyIndex(i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    @Override
    public void clear() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.queue[i2] = null;
        }
        this.size = 0;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        System.arraycopy(this.queue, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Comparator<? super E> comparator() {
        return this.minHeap.ordering;
    }

    @VisibleForTesting
    int capacity() {
        return this.queue.length;
    }

    @VisibleForTesting
    static int initialQueueSize(int n2, int n3, Iterable<?> iterable) {
        int n4;
        int n5 = n4 = n2 == -1 ? 11 : n2;
        if (iterable instanceof Collection) {
            int n6 = ((Collection)iterable).size();
            n4 = Math.max(n4, n6);
        }
        return MinMaxPriorityQueue.capAtMaximumSize(n4, n3);
    }

    private void growIfNeeded() {
        if (this.size > this.queue.length) {
            int n2 = this.calculateNewCapacity();
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.queue, 0, objectArray, 0, this.queue.length);
            this.queue = objectArray;
        }
    }

    private int calculateNewCapacity() {
        int n2 = this.queue.length;
        int n3 = n2 < 64 ? (n2 + 1) * 2 : IntMath.checkedMultiply(n2 / 2, 3);
        return MinMaxPriorityQueue.capAtMaximumSize(n3, this.maximumSize);
    }

    private static int capAtMaximumSize(int n2, int n3) {
        return Math.min(n2 - 1, n3) + 1;
    }

    private class QueueIterator
    implements Iterator<E> {
        private int cursor = -1;
        private int nextCursor = -1;
        private int expectedModCount = MinMaxPriorityQueue.access$700(MinMaxPriorityQueue.this);
        private @MonotonicNonNull Queue<E> forgetMeNot;
        private @MonotonicNonNull List<E> skipMe;
        private @Nullable E lastFromForgetMeNot;
        private boolean canRemove;

        private QueueIterator() {
        }

        @Override
        public boolean hasNext() {
            this.checkModCount();
            this.nextNotInSkipMe(this.cursor + 1);
            return this.nextCursor < MinMaxPriorityQueue.this.size() || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            this.checkModCount();
            this.nextNotInSkipMe(this.cursor + 1);
            if (this.nextCursor < MinMaxPriorityQueue.this.size()) {
                this.cursor = this.nextCursor;
                this.canRemove = true;
                return MinMaxPriorityQueue.this.elementData(this.cursor);
            }
            if (this.forgetMeNot != null) {
                this.cursor = MinMaxPriorityQueue.this.size();
                this.lastFromForgetMeNot = this.forgetMeNot.poll();
                if (this.lastFromForgetMeNot != null) {
                    this.canRemove = true;
                    return this.lastFromForgetMeNot;
                }
            }
            throw new NoSuchElementException("iterator moved past last element in queue.");
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.canRemove);
            this.checkModCount();
            this.canRemove = false;
            ++this.expectedModCount;
            if (this.cursor < MinMaxPriorityQueue.this.size()) {
                MoveDesc moveDesc = MinMaxPriorityQueue.this.removeAt(this.cursor);
                if (moveDesc != null) {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                        this.skipMe = new ArrayList(3);
                    }
                    if (!this.foundAndRemovedExactReference(this.skipMe, moveDesc.toTrickle)) {
                        this.forgetMeNot.add(moveDesc.toTrickle);
                    }
                    if (!this.foundAndRemovedExactReference(this.forgetMeNot, moveDesc.replaced)) {
                        this.skipMe.add(moveDesc.replaced);
                    }
                }
                --this.cursor;
                --this.nextCursor;
            } else {
                Preconditions.checkState(this.removeExact(this.lastFromForgetMeNot));
                this.lastFromForgetMeNot = null;
            }
        }

        private boolean foundAndRemovedExactReference(Iterable<E> iterable, E e2) {
            Iterator iterator = iterable.iterator();
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (e3 != e2) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        private boolean removeExact(Object object) {
            for (int i2 = 0; i2 < MinMaxPriorityQueue.this.size; ++i2) {
                if (MinMaxPriorityQueue.this.queue[i2] != object) continue;
                MinMaxPriorityQueue.this.removeAt(i2);
                return true;
            }
            return false;
        }

        private void checkModCount() {
            if (MinMaxPriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        private void nextNotInSkipMe(int n2) {
            if (this.nextCursor < n2) {
                if (this.skipMe != null) {
                    while (n2 < MinMaxPriorityQueue.this.size() && this.foundAndRemovedExactReference(this.skipMe, MinMaxPriorityQueue.this.elementData(n2))) {
                        ++n2;
                    }
                }
                this.nextCursor = n2;
            }
        }
    }

    private class Heap {
        final Ordering<E> ordering;
        @Weak
        @MonotonicNonNull Heap otherHeap;

        Heap(Ordering<E> ordering) {
            this.ordering = ordering;
        }

        int compareElements(int n2, int n3) {
            return this.ordering.compare(MinMaxPriorityQueue.this.elementData(n2), MinMaxPriorityQueue.this.elementData(n3));
        }

        MoveDesc<E> tryCrossOverAndBubbleUp(int n2, int n3, E e2) {
            int n4 = this.crossOver(n3, e2);
            if (n4 == n3) {
                return null;
            }
            Object e3 = n4 < n2 ? MinMaxPriorityQueue.this.elementData(n2) : MinMaxPriorityQueue.this.elementData(this.getParentIndex(n2));
            if (this.otherHeap.bubbleUpAlternatingLevels(n4, e2) < n2) {
                return new MoveDesc(e2, e3);
            }
            return null;
        }

        void bubbleUp(int n2, E e2) {
            Heap heap;
            int n3 = this.crossOverUp(n2, e2);
            if (n3 == n2) {
                heap = this;
            } else {
                n2 = n3;
                heap = this.otherHeap;
            }
            heap.bubbleUpAlternatingLevels(n2, e2);
        }

        @CanIgnoreReturnValue
        int bubbleUpAlternatingLevels(int n2, E e2) {
            int n3;
            Object e3;
            while (n2 > 2 && this.ordering.compare(e3 = MinMaxPriorityQueue.this.elementData(n3 = this.getGrandparentIndex(n2)), e2) > 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e3;
                n2 = n3;
            }
            ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e2;
            return n2;
        }

        int findMin(int n2, int n3) {
            if (n2 >= MinMaxPriorityQueue.this.size) {
                return -1;
            }
            Preconditions.checkState(n2 > 0);
            int n4 = Math.min(n2, MinMaxPriorityQueue.this.size - n3) + n3;
            int n5 = n2;
            for (int i2 = n2 + 1; i2 < n4; ++i2) {
                if (this.compareElements(i2, n5) >= 0) continue;
                n5 = i2;
            }
            return n5;
        }

        int findMinChild(int n2) {
            return this.findMin(this.getLeftChildIndex(n2), 2);
        }

        int findMinGrandChild(int n2) {
            int n3 = this.getLeftChildIndex(n2);
            if (n3 < 0) {
                return -1;
            }
            return this.findMin(this.getLeftChildIndex(n3), 4);
        }

        int crossOverUp(int n2, E e2) {
            Object e3;
            int n3;
            int n4;
            if (n2 == 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[0] = e2;
                return 0;
            }
            int n5 = this.getParentIndex(n2);
            Object e4 = MinMaxPriorityQueue.this.elementData(n5);
            if (n5 != 0 && (n4 = this.getRightChildIndex(n3 = this.getParentIndex(n5))) != n5 && this.getLeftChildIndex(n4) >= MinMaxPriorityQueue.this.size && this.ordering.compare(e3 = MinMaxPriorityQueue.this.elementData(n4), e4) < 0) {
                n5 = n4;
                e4 = e3;
            }
            if (this.ordering.compare(e4, e2) < 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e4;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n5] = e2;
                return n5;
            }
            ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = e2;
            return n2;
        }

        int swapWithConceptuallyLastElement(E e2) {
            Object e3;
            int n2;
            int n3;
            int n4 = this.getParentIndex(MinMaxPriorityQueue.this.size);
            if (n4 != 0 && (n3 = this.getRightChildIndex(n2 = this.getParentIndex(n4))) != n4 && this.getLeftChildIndex(n3) >= MinMaxPriorityQueue.this.size && this.ordering.compare(e3 = MinMaxPriorityQueue.this.elementData(n3), e2) < 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n3] = e2;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[((MinMaxPriorityQueue)MinMaxPriorityQueue.this).size] = e3;
                return n3;
            }
            return MinMaxPriorityQueue.this.size;
        }

        int crossOver(int n2, E e2) {
            int n3 = this.findMinChild(n2);
            if (n3 > 0 && this.ordering.compare(MinMaxPriorityQueue.this.elementData(n3), e2) < 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = MinMaxPriorityQueue.this.elementData(n3);
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n3] = e2;
                return n3;
            }
            return this.crossOverUp(n2, e2);
        }

        int fillHoleAt(int n2) {
            int n3;
            while ((n3 = this.findMinGrandChild(n2)) > 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[n2] = MinMaxPriorityQueue.this.elementData(n3);
                n2 = n3;
            }
            return n2;
        }

        private boolean verifyIndex(int n2) {
            if (this.getLeftChildIndex(n2) < MinMaxPriorityQueue.this.size && this.compareElements(n2, this.getLeftChildIndex(n2)) > 0) {
                return false;
            }
            if (this.getRightChildIndex(n2) < MinMaxPriorityQueue.this.size && this.compareElements(n2, this.getRightChildIndex(n2)) > 0) {
                return false;
            }
            if (n2 > 0 && this.compareElements(n2, this.getParentIndex(n2)) > 0) {
                return false;
            }
            return n2 <= 2 || this.compareElements(this.getGrandparentIndex(n2), n2) <= 0;
        }

        private int getLeftChildIndex(int n2) {
            return n2 * 2 + 1;
        }

        private int getRightChildIndex(int n2) {
            return n2 * 2 + 2;
        }

        private int getParentIndex(int n2) {
            return (n2 - 1) / 2;
        }

        private int getGrandparentIndex(int n2) {
            return this.getParentIndex(this.getParentIndex(n2));
        }
    }

    static class MoveDesc<E> {
        final E toTrickle;
        final E replaced;

        MoveDesc(E e2, E e3) {
            this.toTrickle = e2;
            this.replaced = e3;
        }
    }

    @Beta
    public static final class Builder<B> {
        private static final int UNSET_EXPECTED_SIZE = -1;
        private final Comparator<B> comparator;
        private int expectedSize = -1;
        private int maximumSize = Integer.MAX_VALUE;

        private Builder(Comparator<B> comparator) {
            this.comparator = Preconditions.checkNotNull(comparator);
        }

        @CanIgnoreReturnValue
        public Builder<B> expectedSize(int n2) {
            Preconditions.checkArgument(n2 >= 0);
            this.expectedSize = n2;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<B> maximumSize(int n2) {
            Preconditions.checkArgument(n2 > 0);
            this.maximumSize = n2;
            return this;
        }

        public <T extends B> MinMaxPriorityQueue<T> create() {
            return this.create(Collections.emptySet());
        }

        public <T extends B> MinMaxPriorityQueue<T> create(Iterable<? extends T> iterable) {
            MinMaxPriorityQueue<T> minMaxPriorityQueue = new MinMaxPriorityQueue<T>(this, MinMaxPriorityQueue.initialQueueSize(this.expectedSize, this.maximumSize, iterable));
            for (T t2 : iterable) {
                minMaxPriorityQueue.offer(t2);
            }
            return minMaxPriorityQueue;
        }

        private <T extends B> Ordering<T> ordering() {
            return Ordering.from(this.comparator);
        }
    }
}

