/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    private transient ImmutableSet<E> elementSet;

    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> collection) {
        Object[] objectArray = collection.toArray(new Multiset.Entry[0]);
        HashMap hashMap = Maps.newHashMapWithExpectedSize(objectArray.length);
        long l2 = 0L;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Multiset.Entry entry = objectArray[i2];
            int n2 = entry.getCount();
            l2 += (long)n2;
            Object e2 = Preconditions.checkNotNull(entry.getElement());
            hashMap.put(e2, n2);
            if (entry instanceof Multisets.ImmutableEntry) continue;
            objectArray[i2] = Multisets.immutableEntry(e2, n2);
        }
        return new JdkBackedImmutableMultiset(hashMap, ImmutableList.asImmutableList(objectArray), l2);
    }

    private JdkBackedImmutableMultiset(Map<E, Integer> map, ImmutableList<Multiset.Entry<E>> immutableList, long l2) {
        this.delegateMap = map;
        this.entries = immutableList;
        this.size = l2;
    }

    @Override
    public int count(@Nullable Object object) {
        return this.delegateMap.getOrDefault(object, 0);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        ImmutableSet<E> immutableSet = this.elementSet;
        return immutableSet == null ? (this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this)) : immutableSet;
    }

    @Override
    Multiset.Entry<E> getEntry(int n2) {
        return (Multiset.Entry)this.entries.get(n2);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }
}

