/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.Queue;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Iterators {
    private Iterators() {
    }

    static <T> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EmptyModifiableIterator.INSTANCE;
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(final Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            UnmodifiableIterator unmodifiableIterator = (UnmodifiableIterator)iterator;
            return unmodifiableIterator;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    @Deprecated
    public static <T> UnmodifiableIterator<T> unmodifiableIterator(UnmodifiableIterator<T> unmodifiableIterator) {
        return Preconditions.checkNotNull(unmodifiableIterator);
    }

    public static int size(Iterator<?> iterator) {
        long l2 = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++l2;
        }
        return Ints.saturatedCast(l2);
    }

    public static boolean contains(Iterator<?> iterator, @Nullable Object object) {
        if (object == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    public static boolean removeAll(Iterator<?> iterator, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl2 = false;
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @CanIgnoreReturnValue
    public static <T> boolean removeIf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean bl2 = false;
        while (iterator.hasNext()) {
            if (!predicate.apply(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    @CanIgnoreReturnValue
    public static boolean retainAll(Iterator<?> iterator, Collection<?> collection) {
        Preconditions.checkNotNull(collection);
        boolean bl2 = false;
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> iterator2) {
        while (iterator.hasNext()) {
            Object obj;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object obj2 = iterator.next();
            if (Objects.equal(obj2, obj = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder stringBuilder = new StringBuilder().append('[');
        boolean bl2 = true;
        while (iterator.hasNext()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            bl2 = false;
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.append(']').toString();
    }

    public static <T> T getOnlyElement(Iterator<T> iterator) {
        T t2 = iterator.next();
        if (!iterator.hasNext()) {
            return t2;
        }
        StringBuilder stringBuilder = new StringBuilder().append("expected one element but was: <").append(t2);
        for (int i2 = 0; i2 < 4 && iterator.hasNext(); ++i2) {
            stringBuilder.append(", ").append(iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...");
        }
        stringBuilder.append('>');
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    public static <T> @Nullable T getOnlyElement(Iterator<? extends T> iterator, @Nullable T t2) {
        return iterator.hasNext() ? Iterators.getOnlyElement(iterator) : t2;
    }

    @GwtIncompatible
    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> clazz) {
        ArrayList<? extends T> arrayList = Lists.newArrayList(iterator);
        return Iterables.toArray(arrayList, clazz);
    }

    @CanIgnoreReturnValue
    public static <T> boolean addAll(Collection<T> collection, Iterator<? extends T> iterator) {
        Preconditions.checkNotNull(collection);
        Preconditions.checkNotNull(iterator);
        boolean bl2 = false;
        while (iterator.hasNext()) {
            bl2 |= collection.add(iterator.next());
        }
        return bl2;
    }

    public static int frequency(Iterator<?> iterator, @Nullable Object object) {
        int n2 = 0;
        while (Iterators.contains(iterator, object)) {
            ++n2;
        }
        return n2;
    }

    public static <T> Iterator<T> cycle(final Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        return new Iterator<T>(){
            Iterator<T> iterator = Iterators.emptyModifiableIterator();

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || iterable.iterator().hasNext();
            }

            @Override
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> cycle(T ... TArray) {
        return Iterators.cycle(Lists.newArrayList(TArray));
    }

    private static <T> Iterator<T> consumingForArray(final T ... TArray) {
        return new UnmodifiableIterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TArray.length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = TArray[this.index];
                TArray[this.index] = null;
                ++this.index;
                return object;
            }
        };
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        return Iterators.concat(Iterators.consumingForArray(iterator, iterator2));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        return Iterators.concat(Iterators.consumingForArray(iterator, iterator2, iterator3));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> iterator, Iterator<? extends T> iterator2, Iterator<? extends T> iterator3, Iterator<? extends T> iterator4) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(iterator2);
        Preconditions.checkNotNull(iterator3);
        Preconditions.checkNotNull(iterator4);
        return Iterators.concat(Iterators.consumingForArray(iterator, iterator2, iterator3, iterator4));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> ... iteratorArray) {
        return Iterators.concatNoDefensiveCopy(Arrays.copyOf(iteratorArray, iteratorArray.length));
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> iterator) {
        return new ConcatenatedIterator(iterator);
    }

    static <T> Iterator<T> concatNoDefensiveCopy(Iterator<? extends T> ... iteratorArray) {
        for (Iterator<? extends T> iterator : Preconditions.checkNotNull(iteratorArray)) {
            Preconditions.checkNotNull(iterator);
        }
        return Iterators.concat(Iterators.consumingForArray(iteratorArray));
    }

    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator, int n2) {
        return Iterators.partitionImpl(iterator, n2, false);
    }

    public static <T> UnmodifiableIterator<List<T>> paddedPartition(Iterator<T> iterator, int n2) {
        return Iterators.partitionImpl(iterator, n2, true);
    }

    private static <T> UnmodifiableIterator<List<T>> partitionImpl(final Iterator<T> iterator, final int n2, final boolean bl2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n2 > 0);
        return new UnmodifiableIterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public List<T> next() {
                int n22;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] objectArray = new Object[n2];
                for (n22 = 0; n22 < n2 && iterator.hasNext(); ++n22) {
                    objectArray[n22] = iterator.next();
                }
                for (int i2 = n22; i2 < n2; ++i2) {
                    objectArray[i2] = null;
                }
                List<Object> list = Collections.unmodifiableList(Arrays.asList(objectArray));
                return bl2 || n22 == n2 ? list : list.subList(0, n22);
            }
        };
    }

    public static <T> UnmodifiableIterator<T> filter(final Iterator<T> iterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        return new AbstractIterator<T>(){

            @Override
            protected T computeNext() {
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (!predicate.apply(e2)) continue;
                    return e2;
                }
                return this.endOfData();
            }
        };
    }

    @GwtIncompatible
    public static <T> UnmodifiableIterator<T> filter(Iterator<?> iterator, Class<T> clazz) {
        return Iterators.filter(iterator, Predicates.instanceOf(clazz));
    }

    public static <T> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        return Iterators.indexOf(iterator, predicate) != -1;
    }

    public static <T> boolean all(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (predicate.apply(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> T find(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (!predicate.apply(t2)) continue;
            return t2;
        }
        throw new NoSuchElementException();
    }

    public static <T> @Nullable T find(Iterator<? extends T> iterator, Predicate<? super T> predicate, @Nullable T t2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t3 = iterator.next();
            if (!predicate.apply(t3)) continue;
            return t3;
        }
        return t2;
    }

    public static <T> Optional<T> tryFind(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (!predicate.apply(t2)) continue;
            return Optional.of(t2);
        }
        return Optional.absent();
    }

    public static <T> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int n2 = 0;
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (predicate.apply(t2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static <F, T> Iterator<T> transform(Iterator<F> iterator, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator){

            @Override
            T transform(F f2) {
                return function.apply(f2);
            }
        };
    }

    public static <T> T get(Iterator<T> iterator, int n2) {
        Iterators.checkNonnegative(n2);
        int n3 = Iterators.advance(iterator, n2);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException("position (" + n2 + ") must be less than the number of elements that remained (" + n3 + ")");
        }
        return iterator.next();
    }

    public static <T> @Nullable T get(Iterator<? extends T> iterator, int n2, @Nullable T t2) {
        Iterators.checkNonnegative(n2);
        Iterators.advance(iterator, n2);
        return Iterators.getNext(iterator, t2);
    }

    static void checkNonnegative(int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("position (" + n2 + ") must not be negative");
        }
    }

    public static <T> @Nullable T getNext(Iterator<? extends T> iterator, @Nullable T t2) {
        return iterator.hasNext() ? iterator.next() : t2;
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T t2;
        do {
            t2 = iterator.next();
        } while (iterator.hasNext());
        return t2;
    }

    public static <T> @Nullable T getLast(Iterator<? extends T> iterator, @Nullable T t2) {
        return iterator.hasNext() ? Iterators.getLast(iterator) : t2;
    }

    @CanIgnoreReturnValue
    public static int advance(Iterator<?> iterator, int n2) {
        int n3;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n2 >= 0, "numberToAdvance must be nonnegative");
        for (n3 = 0; n3 < n2 && iterator.hasNext(); ++n3) {
            iterator.next();
        }
        return n3;
    }

    public static <T> Iterator<T> limit(final Iterator<T> iterator, final int n2) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(n2 >= 0, "limit is negative");
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < n2 && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> consumingIterator(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                Object e2 = iterator.next();
                iterator.remove();
                return e2;
            }

            public String toString() {
                return "Iterators.consumingIterator(...)";
            }
        };
    }

    static <T> @Nullable T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            T t2 = iterator.next();
            iterator.remove();
            return t2;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @SafeVarargs
    public static <T> UnmodifiableIterator<T> forArray(T ... TArray) {
        return Iterators.forArray(TArray, 0, TArray.length, 0);
    }

    static <T> UnmodifiableListIterator<T> forArray(T[] TArray, int n2, int n3, int n4) {
        Preconditions.checkArgument(n3 >= 0);
        int n5 = n2 + n3;
        Preconditions.checkPositionIndexes(n2, n5, TArray.length);
        Preconditions.checkPositionIndex(n4, n3);
        if (n3 == 0) {
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, n2, n3, n4);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(final @Nullable T t2) {
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return t2;
            }
        };
    }

    public static <T> UnmodifiableIterator<T> forEnumeration(final Enumeration<T> enumeration) {
        Preconditions.checkNotNull(enumeration);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(final Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        if (iterator instanceof PeekingImpl) {
            PeekingImpl peekingImpl = (PeekingImpl)iterator;
            return peekingImpl;
        }
        return new PeekingImpl<T>(iterator);
    }

    @Deprecated
    public static <T> PeekingIterator<T> peekingIterator(PeekingIterator<T> peekingIterator) {
        return Preconditions.checkNotNull(peekingIterator);
    }

    @Beta
    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterable, Comparator<? super T> comparator) {
        Preconditions.checkNotNull(iterable, "iterators");
        Preconditions.checkNotNull(comparator, "comparator");
        return new MergingIterator<T>(iterable, comparator);
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator) {
        return (ListIterator)iterator;
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private @Nullable Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = Iterators.emptyIterator();
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        private @Nullable Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> iterator) {
            this.topMetaIterator = Preconditions.checkNotNull(iterator);
        }

        private @Nullable Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
                if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                    this.topMetaIterator = this.metaIterators.removeFirst();
                    continue;
                }
                return null;
            }
            return this.topMetaIterator;
        }

        @Override
        public boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                this.topMetaIterator = this.getTopMetaIterator();
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator concatenatedIterator = (ConcatenatedIterator)this.iterator;
                this.iterator = concatenatedIterator.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (concatenatedIterator.metaIterators != null) {
                    while (!concatenatedIterator.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(concatenatedIterator.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = concatenatedIterator.topMetaIterator;
            }
            return true;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.toRemove != null);
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static class MergingIterator<T>
    extends UnmodifiableIterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterable, final Comparator<? super T> comparator) {
            Comparator comparator2 = new Comparator<PeekingIterator<T>>(){

                @Override
                public int compare(PeekingIterator<T> peekingIterator, PeekingIterator<T> peekingIterator2) {
                    return comparator.compare(peekingIterator.peek(), peekingIterator2.peek());
                }
            };
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, comparator2);
            for (Iterator<T> iterator : iterable) {
                if (!iterator.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(iterator));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            PeekingIterator<T> peekingIterator = this.queue.remove();
            T t2 = peekingIterator.next();
            if (peekingIterator.hasNext()) {
                this.queue.add(peekingIterator);
            }
            return t2;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private @Nullable E peekedElement;

        public PeekingImpl(Iterator<? extends E> iterator) {
            this.iterator = Preconditions.checkNotNull(iterator);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        @Override
        public E next() {
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E e2 = this.peekedElement;
            this.hasPeeked = false;
            this.peekedElement = null;
            return e2;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return this.peekedElement;
        }
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0, 0, 0);
        private final T[] array;
        private final int offset;

        ArrayItr(T[] TArray, int n2, int n3, int n4) {
            super(n3, n4);
            this.array = TArray;
            this.offset = n2;
        }

        @Override
        protected T get(int n2) {
            return this.array[this.offset + n2];
        }
    }

    private static enum EmptyModifiableIterator implements Iterator<Object>
    {
        INSTANCE;


        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(false);
        }
    }
}

