/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedIterable;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1301;
    final transient Comparator<? super E> comparator;
    @LazyInit
    @GwtIncompatible
    transient ImmutableSortedSet<E> descendingSet;

    public static <E> Collector<E, ?, ImmutableSortedSet<E>> toImmutableSortedSet(Comparator<? super E> comparator) {
        return CollectCollectors.toImmutableSortedSet(comparator);
    }

    static <E> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2) {
        return new RegularImmutableSortedSet<E>(ImmutableList.of(e2), Ordering.natural());
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3) {
        return ImmutableSortedSet.construct(Ordering.natural(), 2, e2, e3);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4) {
        return ImmutableSortedSet.construct(Ordering.natural(), 3, e2, e3, e4);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableSortedSet.construct(Ordering.natural(), 4, e2, e3, e4, e5);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSortedSet.construct(Ordering.natural(), 5, e2, e3, e4, e5, e6);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        Comparable[] comparableArray = new Comparable[6 + EArray.length];
        comparableArray[0] = e2;
        comparableArray[1] = e3;
        comparableArray[2] = e4;
        comparableArray[3] = e5;
        comparableArray[4] = e6;
        comparableArray[5] = e7;
        System.arraycopy(EArray, 0, comparableArray, 6, EArray.length);
        return ImmutableSortedSet.construct(Ordering.natural(), comparableArray.length, comparableArray);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] EArray) {
        return ImmutableSortedSet.construct(Ordering.natural(), EArray.length, (Object[])EArray.clone());
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> iterable) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, iterable);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> collection) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterator<? extends E> iterator) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, iterator);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)iterator)).build();
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        Object object;
        Preconditions.checkNotNull(comparator);
        boolean bl2 = SortedIterables.hasSameComparator(comparator, iterable);
        if (bl2 && iterable instanceof ImmutableSortedSet && !((ImmutableCollection)(object = (ImmutableSortedSet)iterable)).isPartialView()) {
            return object;
        }
        object = Iterables.toArray(iterable);
        return ImmutableSortedSet.construct(comparator, ((Object[])object).length, object);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> collection) {
        return ImmutableSortedSet.copyOf(comparator, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        Comparator<E> comparator = SortedIterables.comparator(sortedSet);
        ImmutableList<E> immutableList = ImmutableList.copyOf(sortedSet);
        if (immutableList.isEmpty()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet<E>(immutableList, comparator);
    }

    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n2, E ... EArray) {
        if (n2 == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull((Object[])EArray, n2);
        Arrays.sort(EArray, 0, n2, comparator);
        int n3 = 1;
        for (int i2 = 1; i2 < n2; ++i2) {
            E e2 = EArray[i2];
            E e3 = EArray[n3 - 1];
            if (comparator.compare(e2, e3) == 0) continue;
            EArray[n3++] = e2;
        }
        Arrays.fill(EArray, n3, n2, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(EArray, n3), comparator);
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Collections.reverseOrder());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    int unsafeCompare(Object object, Object object2) {
        return ImmutableSortedSet.unsafeCompare(this.comparator, object, object2);
    }

    static int unsafeCompare(Comparator<?> comparator, Object object, Object object2) {
        Comparator<?> comparator2 = comparator;
        return comparator2.compare(object, object2);
    }

    ImmutableSortedSet(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableSortedSet<E> headSet(E e2) {
        return this.headSet((Object)e2, false);
    }

    @Override
    @GwtIncompatible
    public ImmutableSortedSet<E> headSet(E e2, boolean bl2) {
        return this.headSetImpl(Preconditions.checkNotNull(e2), bl2);
    }

    @Override
    public ImmutableSortedSet<E> subSet(E e2, E e3) {
        return this.subSet((Object)e2, true, (Object)e3, false);
    }

    @Override
    @GwtIncompatible
    public ImmutableSortedSet<E> subSet(E e2, boolean bl2, E e3, boolean bl3) {
        Preconditions.checkNotNull(e2);
        Preconditions.checkNotNull(e3);
        Preconditions.checkArgument(this.comparator.compare(e2, e3) <= 0);
        return this.subSetImpl(e2, bl2, e3, bl3);
    }

    @Override
    public ImmutableSortedSet<E> tailSet(E e2) {
        return this.tailSet((Object)e2, true);
    }

    @Override
    @GwtIncompatible
    public ImmutableSortedSet<E> tailSet(E e2, boolean bl2) {
        return this.tailSetImpl(Preconditions.checkNotNull(e2), bl2);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    @Override
    @GwtIncompatible
    public E lower(E e2) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e2, false)).descendingIterator(), null);
    }

    @Override
    @GwtIncompatible
    public E floor(E e2) {
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)e2, true)).descendingIterator(), null);
    }

    @Override
    @GwtIncompatible
    public E ceiling(E e2) {
        return Iterables.getFirst(this.tailSet((Object)e2, true), null);
    }

    @Override
    @GwtIncompatible
    public E higher(E e2) {
        return Iterables.getFirst(this.tailSet((Object)e2, false), null);
    }

    @Override
    public E first() {
        return this.iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @GwtIncompatible
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    @GwtIncompatible
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GwtIncompatible
    public ImmutableSortedSet<E> descendingSet() {
        ImmutableSortedSet<E> immutableSortedSet = this.descendingSet;
        if (immutableSortedSet == null) {
            immutableSortedSet = this.descendingSet = this.createDescendingSet();
            immutableSortedSet.descendingSet = this;
        }
        return immutableSortedSet;
    }

    @GwtIncompatible
    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public Spliterator<E> spliterator() {
        return new Spliterators.AbstractSpliterator<E>(this.size(), 1365){
            final UnmodifiableIterator<E> iterator;
            {
                this.iterator = ImmutableSortedSet.this.iterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super E> consumer) {
                if (this.iterator.hasNext()) {
                    consumer.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Comparator<? super E> getComparator() {
                return ImmutableSortedSet.this.comparator;
            }
        };
    }

    @Override
    @GwtIncompatible
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(@Nullable Object var1);

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    private static class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        public SerializedForm(Comparator<? super E> comparator, Object[] objectArray) {
            this.comparator = comparator;
            this.elements = objectArray;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        public Builder(Comparator<? super E> comparator) {
            super(true);
            this.comparator = Preconditions.checkNotNull(comparator);
            this.elements = new Object[4];
            this.n = 0;
        }

        @Override
        void copy() {
            this.elements = Arrays.copyOf(this.elements, this.elements.length);
        }

        private void sortAndDedup() {
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, 0, this.n, this.comparator);
            int n2 = 1;
            for (int i2 = 1; i2 < this.n; ++i2) {
                int n3 = this.comparator.compare(this.elements[n2 - 1], this.elements[i2]);
                if (n3 < 0) {
                    this.elements[n2++] = this.elements[i2];
                    continue;
                }
                if (n3 > 0) {
                    throw new AssertionError((Object)("Comparator " + this.comparator + " compare method violates its contract"));
                }
            }
            Arrays.fill(this.elements, n2, this.n, null);
            this.n = n2;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int n2 = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (n2 > this.elements.length) {
                    this.elements = Arrays.copyOf(this.elements, n2);
                }
            }
            this.elements[this.n++] = e2;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... EArray) {
            ObjectArrays.checkElementsNotNull((Object[])EArray);
            for (E e2 : EArray) {
                this.add((Object)e2);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll((Iterable)iterable);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll((Iterator)iterator);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        Builder<E> combine(ImmutableSet.Builder<E> builder) {
            this.copyIfNecessary();
            Builder builder2 = (Builder)builder;
            for (int i2 = 0; i2 < builder2.n; ++i2) {
                this.add((Object)builder2.elements[i2]);
            }
            return this;
        }

        @Override
        public ImmutableSortedSet<E> build() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

