/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingImmutableSortedMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMultisetFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedMultiset;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

@GwtIncompatible
public abstract class ImmutableSortedMultiset<E>
extends ImmutableSortedMultisetFauxverideShim<E>
implements SortedMultiset<E> {
    @LazyInit
    transient ImmutableSortedMultiset<E> descendingMultiset;

    public static <E> Collector<E, ?, ImmutableSortedMultiset<E>> toImmutableSortedMultiset(Comparator<? super E> comparator) {
        return ImmutableSortedMultiset.toImmutableSortedMultiset(comparator, Function.identity(), object -> 1);
    }

    public static <T, E> Collector<T, ?, ImmutableSortedMultiset<E>> toImmutableSortedMultiset(Comparator<? super E> comparator, Function<? super T, ? extends E> function, ToIntFunction<? super T> toIntFunction) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(function);
        Preconditions.checkNotNull(toIntFunction);
        return Collector.of(() -> TreeMultiset.create(comparator), (multiset, object) -> multiset.add(Preconditions.checkNotNull(function.apply(object)), toIntFunction.applyAsInt(object)), (multiset, multiset2) -> {
            multiset.addAll(multiset2);
            return multiset;
        }, multiset -> ImmutableSortedMultiset.copyOfSortedEntries(comparator, multiset.entrySet()), new Collector.Characteristics[0]);
    }

    public static <E> ImmutableSortedMultiset<E> of() {
        return RegularImmutableSortedMultiset.NATURAL_EMPTY_MULTISET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2) {
        RegularImmutableSortedSet regularImmutableSortedSet = (RegularImmutableSortedSet)ImmutableSortedSet.of(e2);
        long[] lArray = new long[]{0L, 1L};
        return new RegularImmutableSortedMultiset(regularImmutableSortedSet, lArray, 0, 1);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3, e4));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3, e4, e5));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e2, e3, e4, e5, e6));
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E ... EArray) {
        int n2 = EArray.length + 6;
        ArrayList arrayList = Lists.newArrayListWithCapacity(n2);
        Collections.addAll(arrayList, e2, e3, e4, e5, e6, e7);
        Collections.addAll(arrayList, EArray);
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), arrayList);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> copyOf(E[] EArray) {
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(EArray));
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Iterable<? extends E> iterable) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedMultiset.copyOf(ordering, iterable);
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Iterator<? extends E> iterator) {
        Ordering ordering = Ordering.natural();
        return ImmutableSortedMultiset.copyOf(ordering, iterator);
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> iterator) {
        Preconditions.checkNotNull(comparator);
        return ((Builder)new Builder<E>(comparator).addAll((Iterator)iterator)).build();
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        AbstractCollection abstractCollection;
        if (iterable instanceof ImmutableSortedMultiset && comparator.equals(((ImmutableSortedMultiset)(abstractCollection = (ImmutableSortedMultiset)iterable)).comparator())) {
            if (((ImmutableCollection)abstractCollection).isPartialView()) {
                return ImmutableSortedMultiset.copyOfSortedEntries(comparator, ((ImmutableSet)((ImmutableMultiset)abstractCollection).entrySet()).asList());
            }
            return abstractCollection;
        }
        iterable = Lists.newArrayList(iterable);
        abstractCollection = TreeMultiset.create(Preconditions.checkNotNull(comparator));
        Iterables.addAll(abstractCollection, iterable);
        return ImmutableSortedMultiset.copyOfSortedEntries(comparator, ((TreeMultiset)abstractCollection).entrySet());
    }

    public static <E> ImmutableSortedMultiset<E> copyOfSorted(SortedMultiset<E> sortedMultiset) {
        return ImmutableSortedMultiset.copyOfSortedEntries(sortedMultiset.comparator(), Lists.newArrayList(sortedMultiset.entrySet()));
    }

    private static <E> ImmutableSortedMultiset<E> copyOfSortedEntries(Comparator<? super E> comparator, Collection<Multiset.Entry<E>> collection) {
        if (collection.isEmpty()) {
            return ImmutableSortedMultiset.emptyMultiset(comparator);
        }
        ImmutableList.Builder builder = new ImmutableList.Builder(collection.size());
        long[] lArray = new long[collection.size() + 1];
        int n2 = 0;
        for (Multiset.Entry<E> entry : collection) {
            builder.add((Object)entry.getElement());
            lArray[n2 + 1] = lArray[n2] + (long)entry.getCount();
            ++n2;
        }
        return new RegularImmutableSortedMultiset<E>(new RegularImmutableSortedSet<E>(builder.build(), comparator), lArray, 0, collection.size());
    }

    static <E> ImmutableSortedMultiset<E> emptyMultiset(Comparator<? super E> comparator) {
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedMultiset.NATURAL_EMPTY_MULTISET;
        }
        return new RegularImmutableSortedMultiset<E>(comparator);
    }

    ImmutableSortedMultiset() {
    }

    @Override
    public final Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.elementSet()).comparator();
    }

    @Override
    public abstract ImmutableSortedSet<E> elementSet();

    @Override
    public ImmutableSortedMultiset<E> descendingMultiset() {
        ImmutableSortedMultiset<E> immutableSortedMultiset = this.descendingMultiset;
        if (immutableSortedMultiset == null) {
            this.descendingMultiset = this.isEmpty() ? ImmutableSortedMultiset.emptyMultiset(Ordering.from(this.comparator()).reverse()) : new DescendingImmutableSortedMultiset(this);
            return this.descendingMultiset;
        }
        return immutableSortedMultiset;
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final Multiset.Entry<E> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final Multiset.Entry<E> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract ImmutableSortedMultiset<E> headMultiset(E var1, BoundType var2);

    @Override
    public ImmutableSortedMultiset<E> subMultiset(E e2, BoundType boundType, E e3, BoundType boundType2) {
        Preconditions.checkArgument(this.comparator().compare(e2, e3) <= 0, "Expected lowerBound <= upperBound but %s > %s", e2, e3);
        return ((ImmutableSortedMultiset)this.tailMultiset((Object)e2, boundType)).headMultiset((Object)e3, boundType2);
    }

    @Override
    public abstract ImmutableSortedMultiset<E> tailMultiset(E var1, BoundType var2);

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        return new Builder<E>(comparator);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    private static final class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final E[] elements;
        final int[] counts;

        SerializedForm(SortedMultiset<E> sortedMultiset) {
            this.comparator = sortedMultiset.comparator();
            int n2 = sortedMultiset.entrySet().size();
            this.elements = new Object[n2];
            this.counts = new int[n2];
            int n3 = 0;
            for (Multiset.Entry<E> entry : sortedMultiset.entrySet()) {
                this.elements[n3] = entry.getElement();
                this.counts[n3] = entry.getCount();
                ++n3;
            }
        }

        Object readResolve() {
            int n2 = this.elements.length;
            Builder<E> builder = new Builder<E>(this.comparator);
            for (int i2 = 0; i2 < n2; ++i2) {
                builder.addCopies((Object)this.elements[i2], this.counts[i2]);
            }
            return builder.build();
        }
    }

    public static class Builder<E>
    extends ImmutableMultiset.Builder<E> {
        public Builder(Comparator<? super E> comparator) {
            super(TreeMultiset.create(Preconditions.checkNotNull(comparator)));
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E e2) {
            super.add((Object)e2);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... EArray) {
            super.add((Object[])EArray);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addCopies(E e2, int n2) {
            super.addCopies(e2, n2);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> setCount(E e2, int n2) {
            super.setCount(e2, n2);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            super.addAll((Iterable)iterable);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll((Iterator)iterator);
            return this;
        }

        @Override
        public ImmutableSortedMultiset<E> build() {
            return ImmutableSortedMultiset.copyOfSorted((SortedMultiset)this.contents);
        }
    }
}

