/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return CollectCollectors.toImmutableList();
    }

    public static <E> ImmutableList<E> of() {
        return RegularImmutableList.EMPTY;
    }

    public static <E> ImmutableList<E> of(E e2) {
        return new SingletonImmutableList<E>(e2);
    }

    public static <E> ImmutableList<E> of(E e2, E e3) {
        return ImmutableList.construct(e2, e3);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4) {
        return ImmutableList.construct(e2, e3, e4);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5) {
        return ImmutableList.construct(e2, e3, e4, e5);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6) {
        return ImmutableList.construct(e2, e3, e4, e5, e6);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9, e10, e11);
    }

    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12) {
        return ImmutableList.construct(e2, e3, e4, e5, e6, e7, e8, e9, e10, e11, e12);
    }

    @SafeVarargs
    public static <E> ImmutableList<E> of(E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12, E e13, E ... EArray) {
        Preconditions.checkArgument(EArray.length <= 0x7FFFFFF3, "the total number of elements must fit in an int");
        Object[] objectArray = new Object[12 + EArray.length];
        objectArray[0] = e2;
        objectArray[1] = e3;
        objectArray[2] = e4;
        objectArray[3] = e5;
        objectArray[4] = e6;
        objectArray[5] = e7;
        objectArray[6] = e8;
        objectArray[7] = e9;
        objectArray[8] = e10;
        objectArray[9] = e11;
        objectArray[10] = e12;
        objectArray[11] = e13;
        System.arraycopy(EArray, 0, objectArray, 12, EArray.length);
        return ImmutableList.construct(objectArray);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(iterable);
        return iterable instanceof Collection ? ImmutableList.copyOf((Collection)iterable) : ImmutableList.copyOf(iterable.iterator());
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> collection) {
        if (collection instanceof ImmutableCollection) {
            ImmutableList immutableList = ((ImmutableCollection)collection).asList();
            return immutableList.isPartialView() ? ImmutableList.asImmutableList(immutableList.toArray()) : immutableList;
        }
        return ImmutableList.construct(collection.toArray());
    }

    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> iterator) {
        if (!iterator.hasNext()) {
            return ImmutableList.of();
        }
        E e2 = iterator.next();
        if (!iterator.hasNext()) {
            return ImmutableList.of(e2);
        }
        return ((Builder)((Builder)new Builder().add((Object)e2)).addAll(iterator)).build();
    }

    public static <E> ImmutableList<E> copyOf(E[] EArray) {
        switch (EArray.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(EArray[0]);
            }
        }
        return ImmutableList.construct((Object[])EArray.clone());
    }

    public static <E extends Comparable<? super E>> ImmutableList<E> sortedCopyOf(Iterable<? extends E> iterable) {
        Object[] objectArray = Iterables.toArray(iterable, new Comparable[0]);
        ObjectArrays.checkElementsNotNull(objectArray);
        Arrays.sort(objectArray);
        return ImmutableList.asImmutableList(objectArray);
    }

    public static <E> ImmutableList<E> sortedCopyOf(Comparator<? super E> comparator, Iterable<? extends E> iterable) {
        Preconditions.checkNotNull(comparator);
        Object[] objectArray = Iterables.toArray(iterable);
        ObjectArrays.checkElementsNotNull(objectArray);
        Arrays.sort(objectArray, comparator);
        return ImmutableList.asImmutableList(objectArray);
    }

    private static <E> ImmutableList<E> construct(Object ... objectArray) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(objectArray));
    }

    static <E> ImmutableList<E> asImmutableList(Object[] objectArray) {
        return ImmutableList.asImmutableList(objectArray, objectArray.length);
    }

    static <E> ImmutableList<E> asImmutableList(Object[] objectArray, int n2) {
        switch (n2) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(objectArray[0]);
            }
        }
        if (n2 < objectArray.length) {
            objectArray = Arrays.copyOf(objectArray, n2);
        }
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int n2) {
        return new AbstractIndexedListIterator<E>(this.size(), n2){

            @Override
            protected E get(int n2) {
                return ImmutableList.this.get(n2);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            consumer.accept(this.get(i2));
        }
    }

    @Override
    public int indexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.indexOfImpl(this, object);
    }

    @Override
    public int lastIndexOf(@Nullable Object object) {
        return object == null ? -1 : Lists.lastIndexOfImpl(this, object);
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public ImmutableList<E> subList(int n2, int n3) {
        Preconditions.checkPositionIndexes(n2, n3, this.size());
        int n4 = n3 - n2;
        if (n4 == this.size()) {
            return this;
        }
        if (n4 == 0) {
            return ImmutableList.of();
        }
        if (n4 == 1) {
            return ImmutableList.of(this.get(n2));
        }
        return this.subListUnchecked(n2, n3);
    }

    ImmutableList<E> subListUnchecked(int n2, int n3) {
        return new SubList(n2, n3 - n2);
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final boolean addAll(int n2, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final E set(int n2, E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void add(int n2, E e2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final E remove(int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(UnaryOperator<E> unaryOperator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void sort(Comparator<? super E> comparator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1296, this::get);
    }

    @Override
    int copyIntoArray(Object[] objectArray, int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            objectArray[n2 + i2] = this.get(i2);
        }
        return n2 + n3;
    }

    public ImmutableList<E> reverse() {
        return this.size() <= 1 ? this : new ReverseImmutableList(this);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return Lists.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = 31 * n2 + this.get(i2).hashCode();
            n2 = ~(~n2);
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    @Beta
    public static <E> Builder<E> builderWithExpectedSize(int n2) {
        CollectPreconditions.checkNonnegative(n2, "expectedSize");
        return new Builder(n2);
    }

    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        @VisibleForTesting
        Object[] contents;
        private int size;
        private boolean forceCopy;

        public Builder() {
            this(4);
        }

        Builder(int n2) {
            this.contents = new Object[n2];
            this.size = 0;
        }

        private void getReadyToExpandTo(int n2) {
            if (this.contents.length < n2) {
                this.contents = Arrays.copyOf(this.contents, Builder.expandedCapacity(this.contents.length, n2));
                this.forceCopy = false;
            } else if (this.forceCopy) {
                this.contents = Arrays.copyOf(this.contents, this.contents.length);
                this.forceCopy = false;
            }
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E e2) {
            Preconditions.checkNotNull(e2);
            this.getReadyToExpandTo(this.size + 1);
            this.contents[this.size++] = e2;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> add(E ... EArray) {
            ObjectArrays.checkElementsNotNull((Object[])EArray);
            this.add((Object[])EArray, EArray.length);
            return this;
        }

        private void add(Object[] objectArray, int n2) {
            this.getReadyToExpandTo(this.size + n2);
            System.arraycopy(objectArray, 0, this.contents, this.size, n2);
            this.size += n2;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterable<? extends E> iterable) {
            Preconditions.checkNotNull(iterable);
            if (iterable instanceof Collection) {
                Collection collection = (Collection)iterable;
                this.getReadyToExpandTo(this.size + collection.size());
                if (collection instanceof ImmutableCollection) {
                    ImmutableCollection immutableCollection = (ImmutableCollection)collection;
                    this.size = immutableCollection.copyIntoArray(this.contents, this.size);
                    return this;
                }
            }
            super.addAll(iterable);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Builder<E> addAll(Iterator<? extends E> iterator) {
            super.addAll(iterator);
            return this;
        }

        @CanIgnoreReturnValue
        Builder<E> combine(Builder<E> builder) {
            Preconditions.checkNotNull(builder);
            this.add(builder.contents, builder.size);
            return this;
        }

        @Override
        public ImmutableList<E> build() {
            this.forceCopy = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }
    }

    static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;

        ReverseImmutableList(ImmutableList<E> immutableList) {
            this.forwardList = immutableList;
        }

        private int reverseIndex(int n2) {
            return this.size() - 1 - n2;
        }

        private int reversePosition(int n2) {
            return this.size() - n2;
        }

        @Override
        public ImmutableList<E> reverse() {
            return this.forwardList;
        }

        @Override
        public boolean contains(@Nullable Object object) {
            return this.forwardList.contains(object);
        }

        @Override
        public int indexOf(@Nullable Object object) {
            int n2 = this.forwardList.lastIndexOf(object);
            return n2 >= 0 ? this.reverseIndex(n2) : -1;
        }

        @Override
        public int lastIndexOf(@Nullable Object object) {
            int n2 = this.forwardList.indexOf(object);
            return n2 >= 0 ? this.reverseIndex(n2) : -1;
        }

        @Override
        public ImmutableList<E> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.size());
            return ((ImmutableList)this.forwardList.subList(this.reversePosition(n3), this.reversePosition(n2))).reverse();
        }

        @Override
        public E get(int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return this.forwardList.get(this.reverseIndex(n2));
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        boolean isPartialView() {
            return this.forwardList.isPartialView();
        }
    }

    class SubList
    extends ImmutableList<E> {
        final transient int offset;
        final transient int length;

        SubList(int n2, int n3) {
            this.offset = n2;
            this.length = n3;
        }

        @Override
        public int size() {
            return this.length;
        }

        @Override
        public E get(int n2) {
            Preconditions.checkElementIndex(n2, this.length);
            return ImmutableList.this.get(n2 + this.offset);
        }

        @Override
        public ImmutableList<E> subList(int n2, int n3) {
            Preconditions.checkPositionIndexes(n2, n3, this.length);
            return ImmutableList.this.subList(n2 + this.offset, n3 + this.offset);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }
}

