/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.Maps;
import com.google.common.collect.Serialization;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.RetainedWith;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final double LOAD_FACTOR = 1.0;
    private transient BiEntry<K, V>[] hashTableKToV;
    private transient BiEntry<K, V>[] hashTableVToK;
    private transient @Nullable BiEntry<K, V> firstInKeyInsertionOrder;
    private transient @Nullable BiEntry<K, V> lastInKeyInsertionOrder;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    @RetainedWith
    private transient @MonotonicNonNull BiMap<V, K> inverse;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int n2) {
        return new HashBiMap<K, V>(n2);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        HashBiMap<K, V> hashBiMap = HashBiMap.create(map.size());
        hashBiMap.putAll(map);
        return hashBiMap;
    }

    private HashBiMap(int n2) {
        this.init(n2);
    }

    private void init(int n2) {
        CollectPreconditions.checkNonnegative(n2, "expectedSize");
        int n3 = Hashing.closedTableSize(n2, 1.0);
        this.hashTableKToV = this.createTable(n3);
        this.hashTableVToK = this.createTable(n3);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        this.size = 0;
        this.mask = n3 - 1;
        this.modCount = 0;
    }

    private void delete(BiEntry<K, V> biEntry) {
        int n2 = biEntry.keyHash & this.mask;
        BiEntry<K, V> biEntry2 = null;
        BiEntry<K, V> biEntry3 = this.hashTableKToV[n2];
        while (true) {
            if (biEntry3 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableKToV[n2] = biEntry.nextInKToVBucket;
                    break;
                }
                biEntry2.nextInKToVBucket = biEntry.nextInKToVBucket;
                break;
            }
            biEntry2 = biEntry3;
            biEntry3 = biEntry3.nextInKToVBucket;
        }
        int n3 = biEntry.valueHash & this.mask;
        biEntry2 = null;
        BiEntry<K, V> biEntry4 = this.hashTableVToK[n3];
        while (true) {
            if (biEntry4 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableVToK[n3] = biEntry.nextInVToKBucket;
                    break;
                }
                biEntry2.nextInVToKBucket = biEntry.nextInVToKBucket;
                break;
            }
            biEntry2 = biEntry4;
            biEntry4 = biEntry4.nextInVToKBucket;
        }
        if (biEntry.prevInKeyInsertionOrder == null) {
            this.firstInKeyInsertionOrder = biEntry.nextInKeyInsertionOrder;
        } else {
            biEntry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = biEntry.nextInKeyInsertionOrder;
        }
        if (biEntry.nextInKeyInsertionOrder == null) {
            this.lastInKeyInsertionOrder = biEntry.prevInKeyInsertionOrder;
        } else {
            biEntry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = biEntry.prevInKeyInsertionOrder;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<K, V> biEntry, @Nullable BiEntry<K, V> biEntry2) {
        int n2 = biEntry.keyHash & this.mask;
        biEntry.nextInKToVBucket = this.hashTableKToV[n2];
        this.hashTableKToV[n2] = biEntry;
        int n3 = biEntry.valueHash & this.mask;
        biEntry.nextInVToKBucket = this.hashTableVToK[n3];
        this.hashTableVToK[n3] = biEntry;
        if (biEntry2 == null) {
            biEntry.prevInKeyInsertionOrder = this.lastInKeyInsertionOrder;
            biEntry.nextInKeyInsertionOrder = null;
            if (this.lastInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = biEntry;
            } else {
                this.lastInKeyInsertionOrder.nextInKeyInsertionOrder = biEntry;
            }
            this.lastInKeyInsertionOrder = biEntry;
        } else {
            biEntry.prevInKeyInsertionOrder = biEntry2.prevInKeyInsertionOrder;
            if (biEntry.prevInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = biEntry;
            } else {
                biEntry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = biEntry;
            }
            biEntry.nextInKeyInsertionOrder = biEntry2.nextInKeyInsertionOrder;
            if (biEntry.nextInKeyInsertionOrder == null) {
                this.lastInKeyInsertionOrder = biEntry;
            } else {
                biEntry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = biEntry;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    private BiEntry<K, V> seekByKey(@Nullable Object object, int n2) {
        BiEntry<K, V> biEntry = this.hashTableKToV[n2 & this.mask];
        while (biEntry != null) {
            if (n2 == biEntry.keyHash && Objects.equal(object, biEntry.key)) {
                return biEntry;
            }
            biEntry = biEntry.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<K, V> seekByValue(@Nullable Object object, int n2) {
        BiEntry<K, V> biEntry = this.hashTableVToK[n2 & this.mask];
        while (biEntry != null) {
            if (n2 == biEntry.valueHash && Objects.equal(object, biEntry.value)) {
                return biEntry;
            }
            biEntry = biEntry.nextInVToKBucket;
        }
        return null;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.seekByKey(object, Hashing.smearedHash(object)) != null;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.seekByValue(object, Hashing.smearedHash(object)) != null;
    }

    @Override
    public @Nullable V get(@Nullable Object object) {
        return Maps.valueOrNull(this.seekByKey(object, Hashing.smearedHash(object)));
    }

    @Override
    @CanIgnoreReturnValue
    public V put(@Nullable K k2, @Nullable V v2) {
        return this.put(k2, v2, false);
    }

    private V put(@Nullable K k2, @Nullable V v2, boolean bl2) {
        int n2 = Hashing.smearedHash(k2);
        int n3 = Hashing.smearedHash(v2);
        BiEntry<K, V> biEntry = this.seekByKey(k2, n2);
        if (biEntry != null && n3 == biEntry.valueHash && Objects.equal(v2, biEntry.value)) {
            return v2;
        }
        BiEntry<K, V> biEntry2 = this.seekByValue(v2, n3);
        if (biEntry2 != null) {
            if (bl2) {
                this.delete(biEntry2);
            } else {
                throw new IllegalArgumentException("value already present: " + v2);
            }
        }
        BiEntry<K, V> biEntry3 = new BiEntry<K, V>(k2, n2, v2, n3);
        if (biEntry != null) {
            this.delete(biEntry);
            this.insert(biEntry3, biEntry);
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
            return (V)biEntry.value;
        }
        this.insert(biEntry3, null);
        this.rehashIfNecessary();
        return null;
    }

    @Override
    @CanIgnoreReturnValue
    public @Nullable V forcePut(@Nullable K k2, @Nullable V v2) {
        return this.put(k2, v2, true);
    }

    private @Nullable K putInverse(@Nullable V v2, @Nullable K k2, boolean bl2) {
        int n2 = Hashing.smearedHash(v2);
        int n3 = Hashing.smearedHash(k2);
        BiEntry<K, V> biEntry = this.seekByValue(v2, n2);
        BiEntry<K, V> biEntry2 = this.seekByKey(k2, n3);
        if (biEntry != null && n3 == biEntry.keyHash && Objects.equal(k2, biEntry.key)) {
            return k2;
        }
        if (biEntry2 != null && !bl2) {
            throw new IllegalArgumentException("key already present: " + k2);
        }
        if (biEntry != null) {
            this.delete(biEntry);
        }
        if (biEntry2 != null) {
            this.delete(biEntry2);
        }
        BiEntry<K, V> biEntry3 = new BiEntry<K, V>(k2, n3, v2, n2);
        this.insert(biEntry3, biEntry2);
        if (biEntry2 != null) {
            biEntry2.prevInKeyInsertionOrder = null;
            biEntry2.nextInKeyInsertionOrder = null;
        }
        if (biEntry != null) {
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
        }
        this.rehashIfNecessary();
        return Maps.keyOrNull(biEntry);
    }

    private void rehashIfNecessary() {
        BiEntry<K, V>[] biEntryArray = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, biEntryArray.length, 1.0)) {
            int n2 = biEntryArray.length * 2;
            this.hashTableKToV = this.createTable(n2);
            this.hashTableVToK = this.createTable(n2);
            this.mask = n2 - 1;
            this.size = 0;
            BiEntry<K, V> biEntry = this.firstInKeyInsertionOrder;
            while (biEntry != null) {
                this.insert(biEntry, biEntry);
                biEntry = biEntry.nextInKeyInsertionOrder;
            }
            ++this.modCount;
        }
    }

    private BiEntry<K, V>[] createTable(int n2) {
        return new BiEntry[n2];
    }

    @Override
    @CanIgnoreReturnValue
    public @Nullable V remove(@Nullable Object object) {
        BiEntry<K, V> biEntry = this.seekByKey(object, Hashing.smearedHash(object));
        if (biEntry == null) {
            return null;
        }
        this.delete(biEntry);
        biEntry.prevInKeyInsertionOrder = null;
        biEntry.nextInKeyInsertionOrder = null;
        return (V)biEntry.value;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Set<V> values() {
        return this.inverse().keySet();
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> output(BiEntry<K, V> biEntry) {
                return new MapEntry(biEntry);
            }

            class MapEntry
            extends AbstractMapEntry<K, V> {
                BiEntry<K, V> delegate;

                MapEntry(BiEntry<K, V> biEntry) {
                    this.delegate = biEntry;
                }

                @Override
                public K getKey() {
                    return this.delegate.key;
                }

                @Override
                public V getValue() {
                    return this.delegate.value;
                }

                @Override
                public V setValue(V v2) {
                    Object object = this.delegate.value;
                    int n2 = Hashing.smearedHash(v2);
                    if (n2 == this.delegate.valueHash && Objects.equal(v2, object)) {
                        return v2;
                    }
                    Preconditions.checkArgument(HashBiMap.this.seekByValue(v2, n2) == null, "value already present: %s", v2);
                    HashBiMap.this.delete(this.delegate);
                    BiEntry biEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, v2, n2);
                    HashBiMap.this.insert(biEntry, this.delegate);
                    this.delegate.prevInKeyInsertionOrder = null;
                    this.delegate.nextInKeyInsertionOrder = null;
                    expectedModCount = HashBiMap.this.modCount;
                    if (toRemove == this.delegate) {
                        toRemove = biEntry;
                    }
                    this.delegate = biEntry;
                    return object;
                }
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        BiEntry<K, V> biEntry = this.firstInKeyInsertionOrder;
        while (biEntry != null) {
            biConsumer.accept(biEntry.key, biEntry.value);
            biEntry = biEntry.nextInKeyInsertionOrder;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Preconditions.checkNotNull(biFunction);
        BiEntry<K, V> biEntry = this.firstInKeyInsertionOrder;
        this.clear();
        BiEntry<K, V> biEntry2 = biEntry;
        while (biEntry2 != null) {
            this.put(biEntry2.key, biFunction.apply(biEntry2.key, biEntry2.value));
            biEntry2 = biEntry2.nextInKeyInsertionOrder;
        }
    }

    @Override
    public BiMap<V, K> inverse() {
        Inverse inverse = this.inverse;
        return inverse == null ? (this.inverse = new Inverse()) : inverse;
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMap(this, objectOutputStream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n2 = Serialization.readCount(objectInputStream);
        this.init(16);
        Serialization.populateMap(this, objectInputStream, n2);
    }

    private static final class InverseSerializedForm<K, V>
    implements Serializable {
        private final HashBiMap<K, V> bimap;

        InverseSerializedForm(HashBiMap<K, V> hashBiMap) {
            this.bimap = hashBiMap;
        }

        Object readResolve() {
            return this.bimap.inverse();
        }
    }

    private final class Inverse
    extends Maps.IteratorBasedAbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private Inverse() {
        }

        BiMap<K, V> forward() {
            return HashBiMap.this;
        }

        @Override
        public int size() {
            return HashBiMap.this.size;
        }

        @Override
        public void clear() {
            this.forward().clear();
        }

        @Override
        public boolean containsKey(@Nullable Object object) {
            return this.forward().containsValue(object);
        }

        @Override
        public K get(@Nullable Object object) {
            return Maps.keyOrNull(HashBiMap.this.seekByValue(object, Hashing.smearedHash(object)));
        }

        @Override
        @CanIgnoreReturnValue
        public @Nullable K put(@Nullable V v2, @Nullable K k2) {
            return HashBiMap.this.putInverse(v2, k2, false);
        }

        @Override
        public @Nullable K forcePut(@Nullable V v2, @Nullable K k2) {
            return HashBiMap.this.putInverse(v2, k2, true);
        }

        @Override
        public @Nullable K remove(@Nullable Object object) {
            BiEntry biEntry = HashBiMap.this.seekByValue(object, Hashing.smearedHash(object));
            if (biEntry == null) {
                return null;
            }
            HashBiMap.this.delete(biEntry);
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
            return biEntry.key;
        }

        @Override
        public BiMap<K, V> inverse() {
            return this.forward();
        }

        @Override
        public Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public Set<K> values() {
            return this.forward().keySet();
        }

        @Override
        Iterator<Map.Entry<V, K>> entryIterator() {
            return new Itr<Map.Entry<V, K>>(){

                @Override
                Map.Entry<V, K> output(BiEntry<K, V> biEntry) {
                    return new InverseEntry(biEntry);
                }

                class InverseEntry
                extends AbstractMapEntry<V, K> {
                    BiEntry<K, V> delegate;

                    InverseEntry(BiEntry<K, V> biEntry) {
                        this.delegate = biEntry;
                    }

                    @Override
                    public V getKey() {
                        return this.delegate.value;
                    }

                    @Override
                    public K getValue() {
                        return this.delegate.key;
                    }

                    @Override
                    public K setValue(K k2) {
                        Object object = this.delegate.key;
                        int n2 = Hashing.smearedHash(k2);
                        if (n2 == this.delegate.keyHash && Objects.equal(k2, object)) {
                            return k2;
                        }
                        Preconditions.checkArgument(HashBiMap.this.seekByKey(k2, n2) == null, "value already present: %s", k2);
                        HashBiMap.this.delete(this.delegate);
                        BiEntry biEntry = new BiEntry(k2, n2, this.delegate.value, this.delegate.valueHash);
                        this.delegate = biEntry;
                        HashBiMap.this.insert(biEntry, null);
                        expectedModCount = HashBiMap.this.modCount;
                        return object;
                    }
                }
            };
        }

        @Override
        public void forEach(BiConsumer<? super V, ? super K> biConsumer) {
            Preconditions.checkNotNull(biConsumer);
            HashBiMap.this.forEach((? super K object, ? super V object2) -> biConsumer.accept((Object)object2, (Object)object));
        }

        @Override
        public void replaceAll(BiFunction<? super V, ? super K, ? extends K> biFunction) {
            Preconditions.checkNotNull(biFunction);
            BiEntry biEntry = HashBiMap.this.firstInKeyInsertionOrder;
            this.clear();
            BiEntry biEntry2 = biEntry;
            while (biEntry2 != null) {
                this.put((V)biEntry2.value, (K)biFunction.apply(biEntry2.value, biEntry2.key));
                biEntry2 = biEntry2.nextInKeyInsertionOrder;
            }
        }

        Object writeReplace() {
            return new InverseSerializedForm(HashBiMap.this);
        }

        private final class InverseKeySet
        extends Maps.KeySet<V, K> {
            InverseKeySet() {
                super(Inverse.this);
            }

            @Override
            public boolean remove(@Nullable Object object) {
                BiEntry biEntry = HashBiMap.this.seekByValue(object, Hashing.smearedHash(object));
                if (biEntry == null) {
                    return false;
                }
                HashBiMap.this.delete(biEntry);
                return true;
            }

            @Override
            public Iterator<V> iterator() {
                return new Itr<V>(){

                    @Override
                    V output(BiEntry<K, V> biEntry) {
                        return biEntry.value;
                    }
                };
            }
        }
    }

    private final class KeySet
    extends Maps.KeySet<K, V> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public Iterator<K> iterator() {
            return new Itr<K>(){

                @Override
                K output(BiEntry<K, V> biEntry) {
                    return biEntry.key;
                }
            };
        }

        @Override
        public boolean remove(@Nullable Object object) {
            BiEntry biEntry = HashBiMap.this.seekByKey(object, Hashing.smearedHash(object));
            if (biEntry == null) {
                return false;
            }
            HashBiMap.this.delete(biEntry);
            biEntry.prevInKeyInsertionOrder = null;
            biEntry.nextInKeyInsertionOrder = null;
            return true;
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        BiEntry<K, V> next;
        BiEntry<K, V> toRemove;
        int expectedModCount;
        int remaining;

        Itr() {
            this.next = HashBiMap.this.firstInKeyInsertionOrder;
            this.toRemove = null;
            this.expectedModCount = HashBiMap.this.modCount;
            this.remaining = HashBiMap.this.size();
        }

        @Override
        public boolean hasNext() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null && this.remaining > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry biEntry = this.next;
            this.next = biEntry.nextInKeyInsertionOrder;
            this.toRemove = biEntry;
            --this.remaining;
            return this.output(biEntry);
        }

        @Override
        public void remove() {
            if (HashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            CollectPreconditions.checkRemove(this.toRemove != null);
            HashBiMap.this.delete(this.toRemove);
            this.expectedModCount = HashBiMap.this.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K, V> var1);
    }

    private static final class BiEntry<K, V>
    extends ImmutableEntry<K, V> {
        final int keyHash;
        final int valueHash;
        @Nullable BiEntry<K, V> nextInKToVBucket;
        @Nullable BiEntry<K, V> nextInVToKBucket;
        @Nullable BiEntry<K, V> nextInKeyInsertionOrder;
        @Nullable BiEntry<K, V> prevInKeyInsertionOrder;

        BiEntry(K k2, int n2, V v2, int n3) {
            super(k2, v2);
            this.keyHash = n2;
            this.valueHash = n3;
        }
    }
}

