/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final boolean hasLowerBound;
    private final @Nullable T lowerEndpoint;
    private final BoundType lowerBoundType;
    private final boolean hasUpperBound;
    private final @Nullable T upperEndpoint;
    private final BoundType upperBoundType;
    private transient @MonotonicNonNull GeneralRange<T> reverse;

    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        @Nullable T t2 = range.hasLowerBound() ? (T)range.lowerEndpoint() : null;
        BoundType boundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        @Nullable T t3 = range.hasUpperBound() ? (T)range.upperEndpoint() : null;
        BoundType boundType2 = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange<Object>(Ordering.natural(), range.hasLowerBound(), t2, boundType, range.hasUpperBound(), t3, boundType2);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        return new GeneralRange<Object>(comparator, false, null, BoundType.OPEN, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, @Nullable T t2, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, true, t2, boundType, false, null, BoundType.OPEN);
    }

    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, @Nullable T t2, BoundType boundType) {
        return new GeneralRange<Object>((Comparator<Object>)comparator, false, null, BoundType.OPEN, true, t2, boundType);
    }

    static <T> GeneralRange<T> range(Comparator<? super T> comparator, @Nullable T t2, BoundType boundType, @Nullable T t3, BoundType boundType2) {
        return new GeneralRange<T>(comparator, true, t2, boundType, true, t3, boundType2);
    }

    private GeneralRange(Comparator<? super T> comparator, boolean bl2, @Nullable T t2, BoundType boundType, boolean bl3, @Nullable T t3, BoundType boundType2) {
        this.comparator = Preconditions.checkNotNull(comparator);
        this.hasLowerBound = bl2;
        this.hasUpperBound = bl3;
        this.lowerEndpoint = t2;
        this.lowerBoundType = Preconditions.checkNotNull(boundType);
        this.upperEndpoint = t3;
        this.upperBoundType = Preconditions.checkNotNull(boundType2);
        if (bl2) {
            comparator.compare(t2, t2);
        }
        if (bl3) {
            comparator.compare(t3, t3);
        }
        if (bl2 && bl3) {
            int n2 = comparator.compare(t2, t3);
            Preconditions.checkArgument(n2 <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", t2, t3);
            if (n2 == 0) {
                Preconditions.checkArgument(boundType != BoundType.OPEN | boundType2 != BoundType.OPEN);
            }
        }
    }

    Comparator<? super T> comparator() {
        return this.comparator;
    }

    boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    boolean isEmpty() {
        return this.hasUpperBound() && this.tooLow(this.getUpperEndpoint()) || this.hasLowerBound() && this.tooHigh(this.getLowerEndpoint());
    }

    boolean tooLow(@Nullable T t2) {
        if (!this.hasLowerBound()) {
            return false;
        }
        T t3 = this.getLowerEndpoint();
        int n2 = this.comparator.compare(t2, t3);
        return n2 < 0 | n2 == 0 & this.getLowerBoundType() == BoundType.OPEN;
    }

    boolean tooHigh(@Nullable T t2) {
        if (!this.hasUpperBound()) {
            return false;
        }
        T t3 = this.getUpperEndpoint();
        int n2 = this.comparator.compare(t2, t3);
        return n2 > 0 | n2 == 0 & this.getUpperBoundType() == BoundType.OPEN;
    }

    boolean contains(@Nullable T t2) {
        return !this.tooLow(t2) && !this.tooHigh(t2);
    }

    GeneralRange<T> intersect(GeneralRange<T> generalRange) {
        int n2;
        boolean bl2;
        Preconditions.checkNotNull(generalRange);
        Preconditions.checkArgument(this.comparator.equals(generalRange.comparator));
        boolean bl3 = this.hasLowerBound;
        @Nullable T t2 = this.getLowerEndpoint();
        BoundType boundType = this.getLowerBoundType();
        if (!this.hasLowerBound()) {
            bl3 = generalRange.hasLowerBound;
            t2 = generalRange.getLowerEndpoint();
            boundType = generalRange.getLowerBoundType();
        } else if (generalRange.hasLowerBound() && ((bl2 = this.comparator.compare(this.getLowerEndpoint(), generalRange.getLowerEndpoint())) < false || !bl2 && generalRange.getLowerBoundType() == BoundType.OPEN)) {
            t2 = generalRange.getLowerEndpoint();
            boundType = generalRange.getLowerBoundType();
        }
        bl2 = this.hasUpperBound;
        @Nullable T t3 = this.getUpperEndpoint();
        BoundType boundType2 = this.getUpperBoundType();
        if (!this.hasUpperBound()) {
            bl2 = generalRange.hasUpperBound;
            t3 = generalRange.getUpperEndpoint();
            boundType2 = generalRange.getUpperBoundType();
        } else if (generalRange.hasUpperBound() && ((n2 = this.comparator.compare(this.getUpperEndpoint(), generalRange.getUpperEndpoint())) > 0 || n2 == 0 && generalRange.getUpperBoundType() == BoundType.OPEN)) {
            t3 = generalRange.getUpperEndpoint();
            boundType2 = generalRange.getUpperBoundType();
        }
        if (bl3 && bl2 && ((n2 = this.comparator.compare(t2, t3)) > 0 || n2 == 0 && boundType == BoundType.OPEN && boundType2 == BoundType.OPEN)) {
            t2 = t3;
            boundType = BoundType.OPEN;
            boundType2 = BoundType.CLOSED;
        }
        return new GeneralRange<T>(this.comparator, bl3, t2, boundType, bl2, t3, boundType2);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof GeneralRange) {
            GeneralRange generalRange = (GeneralRange)object;
            return this.comparator.equals(generalRange.comparator) && this.hasLowerBound == generalRange.hasLowerBound && this.hasUpperBound == generalRange.hasUpperBound && this.getLowerBoundType().equals((Object)generalRange.getLowerBoundType()) && this.getUpperBoundType().equals((Object)generalRange.getUpperBoundType()) && Objects.equal(this.getLowerEndpoint(), generalRange.getLowerEndpoint()) && Objects.equal(this.getUpperEndpoint(), generalRange.getUpperEndpoint());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.getLowerEndpoint(), this.getLowerBoundType(), this.getUpperEndpoint(), this.getUpperBoundType()});
    }

    GeneralRange<T> reverse() {
        GeneralRange<Object> generalRange = this.reverse;
        if (generalRange == null) {
            generalRange = new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.getUpperEndpoint(), this.getUpperBoundType(), this.hasLowerBound, this.getLowerEndpoint(), this.getLowerBoundType());
            generalRange.reverse = this;
            this.reverse = generalRange;
            return this.reverse;
        }
        return generalRange;
    }

    public String toString() {
        return this.comparator + ":" + (this.lowerBoundType == BoundType.CLOSED ? (char)'[' : '(') + (this.hasLowerBound ? this.lowerEndpoint : "-\u221e") + ',' + (this.hasUpperBound ? this.upperEndpoint : "\u221e") + (this.upperBoundType == BoundType.CLOSED ? (char)']' : ')');
    }

    T getLowerEndpoint() {
        return this.lowerEndpoint;
    }

    BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    T getUpperEndpoint() {
        return this.upperEndpoint;
    }

    BoundType getUpperBoundType() {
        return this.upperBoundType;
    }
}

