/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ForwardingSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class ForwardingSortedSet<E>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    @Override
    protected abstract SortedSet<E> delegate();

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    public E first() {
        return this.delegate().first();
    }

    @Override
    public SortedSet<E> headSet(E e2) {
        return this.delegate().headSet(e2);
    }

    @Override
    public E last() {
        return this.delegate().last();
    }

    @Override
    public SortedSet<E> subSet(E e2, E e3) {
        return this.delegate().subSet(e2, e3);
    }

    @Override
    public SortedSet<E> tailSet(E e2) {
        return this.delegate().tailSet(e2);
    }

    private int unsafeCompare(@Nullable Object object, @Nullable Object object2) {
        Comparator<E> comparator = this.comparator();
        return comparator == null ? ((Comparable)object).compareTo(object2) : comparator.compare(object, object2);
    }

    @Override
    @Beta
    protected boolean standardContains(@Nullable Object object) {
        try {
            ForwardingSortedSet forwardingSortedSet = this;
            Object object2 = forwardingSortedSet.tailSet(object).first();
            return this.unsafeCompare(object2, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    @Override
    @Beta
    protected boolean standardRemove(@Nullable Object object) {
        try {
            Object e2;
            ForwardingSortedSet forwardingSortedSet = this;
            Iterator iterator = forwardingSortedSet.tailSet(object).iterator();
            if (iterator.hasNext() && this.unsafeCompare(e2 = iterator.next(), object) == 0) {
                iterator.remove();
                return true;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
        return false;
    }

    @Beta
    protected SortedSet<E> standardSubSet(E e2, E e3) {
        return this.tailSet(e2).headSet(e3);
    }
}

