/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class ForwardingSortedMap<K, V>
extends ForwardingMap<K, V>
implements SortedMap<K, V> {
    protected ForwardingSortedMap() {
    }

    @Override
    protected abstract SortedMap<K, V> delegate();

    @Override
    public Comparator<? super K> comparator() {
        return this.delegate().comparator();
    }

    @Override
    public K firstKey() {
        return this.delegate().firstKey();
    }

    @Override
    public SortedMap<K, V> headMap(K k2) {
        return this.delegate().headMap(k2);
    }

    @Override
    public K lastKey() {
        return this.delegate().lastKey();
    }

    @Override
    public SortedMap<K, V> subMap(K k2, K k3) {
        return this.delegate().subMap(k2, k3);
    }

    @Override
    public SortedMap<K, V> tailMap(K k2) {
        return this.delegate().tailMap(k2);
    }

    private int unsafeCompare(Object object, Object object2) {
        Comparator<K> comparator = this.comparator();
        if (comparator == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return comparator.compare(object, object2);
    }

    @Override
    @Beta
    protected boolean standardContainsKey(@Nullable Object object) {
        try {
            ForwardingSortedMap forwardingSortedMap = this;
            Object object2 = forwardingSortedMap.tailMap(object).firstKey();
            return this.unsafeCompare(object2, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    @Beta
    protected SortedMap<K, V> standardSubMap(K k2, K k3) {
        Preconditions.checkArgument(this.unsafeCompare(k2, k3) <= 0, "fromKey must be <= toKey");
        return this.tailMap(k2).headMap(k3);
    }

    @Beta
    protected class StandardKeySet
    extends Maps.SortedKeySet<K, V> {
        public StandardKeySet() {
            super(ForwardingSortedMap.this);
        }
    }
}

