/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.ObjIntConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class EnumMultiset<E extends Enum<E>>
extends AbstractMultiset<E>
implements Serializable {
    private transient Class<E> type;
    private transient E[] enumConstants;
    private transient int[] counts;
    private transient int distinctElements;
    private transient long size;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E extends Enum<E>> EnumMultiset<E> create(Class<E> clazz) {
        return new EnumMultiset<E>(clazz);
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> iterable) {
        Iterator<E> iterator = iterable.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "EnumMultiset constructor passed empty Iterable");
        EnumMultiset enumMultiset = new EnumMultiset(((Enum)iterator.next()).getDeclaringClass());
        Iterables.addAll(enumMultiset, iterable);
        return enumMultiset;
    }

    public static <E extends Enum<E>> EnumMultiset<E> create(Iterable<E> iterable, Class<E> clazz) {
        EnumMultiset<E> enumMultiset = EnumMultiset.create(clazz);
        Iterables.addAll(enumMultiset, iterable);
        return enumMultiset;
    }

    private EnumMultiset(Class<E> clazz) {
        this.type = clazz;
        Preconditions.checkArgument(clazz.isEnum());
        this.enumConstants = (Enum[])clazz.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
    }

    private boolean isActuallyE(@Nullable Object object) {
        if (object instanceof Enum) {
            Enum enum_ = (Enum)object;
            int n2 = enum_.ordinal();
            return n2 < this.enumConstants.length && this.enumConstants[n2] == enum_;
        }
        return false;
    }

    void checkIsE(@Nullable Object object) {
        Preconditions.checkNotNull(object);
        if (!this.isActuallyE(object)) {
            throw new ClassCastException("Expected an " + this.type + " but got " + object);
        }
    }

    @Override
    int distinctElements() {
        return this.distinctElements;
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public int count(@Nullable Object object) {
        if (object == null || !this.isActuallyE(object)) {
            return 0;
        }
        Enum enum_ = (Enum)object;
        return this.counts[enum_.ordinal()];
    }

    @Override
    @CanIgnoreReturnValue
    public int add(E e2, int n2) {
        this.checkIsE(e2);
        CollectPreconditions.checkNonnegative(n2, "occurrences");
        if (n2 == 0) {
            return this.count(e2);
        }
        int n3 = ((Enum)e2).ordinal();
        int n4 = this.counts[n3];
        long l2 = (long)n4 + (long)n2;
        Preconditions.checkArgument(l2 <= Integer.MAX_VALUE, "too many occurrences: %s", l2);
        this.counts[n3] = (int)l2;
        if (n4 == 0) {
            ++this.distinctElements;
        }
        this.size += (long)n2;
        return n4;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@Nullable Object object, int n2) {
        if (object == null || !this.isActuallyE(object)) {
            return 0;
        }
        Enum enum_ = (Enum)object;
        CollectPreconditions.checkNonnegative(n2, "occurrences");
        if (n2 == 0) {
            return this.count(object);
        }
        int n3 = enum_.ordinal();
        int n4 = this.counts[n3];
        if (n4 == 0) {
            return 0;
        }
        if (n4 <= n2) {
            this.counts[n3] = 0;
            --this.distinctElements;
            this.size -= (long)n4;
        } else {
            this.counts[n3] = n4 - n2;
            this.size -= (long)n2;
        }
        return n4;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(E e2, int n2) {
        this.checkIsE(e2);
        CollectPreconditions.checkNonnegative(n2, "count");
        int n3 = ((Enum)e2).ordinal();
        int n4 = this.counts[n3];
        this.counts[n3] = n2;
        this.size += (long)(n2 - n4);
        if (n4 == 0 && n2 > 0) {
            ++this.distinctElements;
        } else if (n4 > 0 && n2 == 0) {
            --this.distinctElements;
        }
        return n4;
    }

    @Override
    public void clear() {
        Arrays.fill(this.counts, 0);
        this.size = 0L;
        this.distinctElements = 0;
    }

    @Override
    Iterator<E> elementIterator() {
        return new Itr<E>(){

            @Override
            E output(int n2) {
                return EnumMultiset.this.enumConstants[n2];
            }
        };
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        return new Itr<Multiset.Entry<E>>(){

            @Override
            Multiset.Entry<E> output(final int n2) {
                return new Multisets.AbstractEntry<E>(){

                    @Override
                    public E getElement() {
                        return EnumMultiset.this.enumConstants[n2];
                    }

                    @Override
                    public int getCount() {
                        return EnumMultiset.this.counts[n2];
                    }
                };
            }
        };
    }

    @Override
    public void forEachEntry(ObjIntConsumer<? super E> objIntConsumer) {
        Preconditions.checkNotNull(objIntConsumer);
        for (int i2 = 0; i2 < this.enumConstants.length; ++i2) {
            if (this.counts[i2] <= 0) continue;
            objIntConsumer.accept(this.enumConstants[i2], this.counts[i2]);
        }
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @GwtIncompatible
    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.type);
        Serialization.writeMultiset(this, objectOutputStream);
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream objectInputStream) {
        Class clazz;
        objectInputStream.defaultReadObject();
        this.type = clazz = (Class)objectInputStream.readObject();
        this.enumConstants = (Enum[])this.type.getEnumConstants();
        this.counts = new int[this.enumConstants.length];
        Serialization.populateMultiset(this, objectInputStream);
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int index = 0;
        int toRemove = -1;

        Itr() {
        }

        abstract T output(int var1);

        @Override
        public boolean hasNext() {
            while (this.index < EnumMultiset.this.enumConstants.length) {
                if (EnumMultiset.this.counts[this.index] > 0) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T t2 = this.output(this.index);
            this.toRemove = this.index++;
            return t2;
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.toRemove >= 0);
            if (EnumMultiset.this.counts[this.toRemove] > 0) {
                EnumMultiset.this.distinctElements--;
                EnumMultiset.this.size = EnumMultiset.this.size - (long)EnumMultiset.this.counts[this.toRemove];
                ((EnumMultiset)EnumMultiset.this).counts[this.toRemove] = 0;
            }
            this.toRemove = -1;
        }
    }
}

