/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.NoSuchElementException;

@GwtCompatible
public abstract class DiscreteDomain<C extends Comparable> {
    final boolean supportsFastOffset;

    public static DiscreteDomain<Integer> integers() {
        return IntegerDomain.INSTANCE;
    }

    public static DiscreteDomain<Long> longs() {
        return LongDomain.INSTANCE;
    }

    public static DiscreteDomain<BigInteger> bigIntegers() {
        return BigIntegerDomain.INSTANCE;
    }

    protected DiscreteDomain() {
        this(false);
    }

    private DiscreteDomain(boolean bl2) {
        this.supportsFastOffset = bl2;
    }

    C offset(C c2, long l2) {
        CollectPreconditions.checkNonnegative(l2, "distance");
        for (long i2 = 0L; i2 < l2; ++i2) {
            c2 = this.next(c2);
        }
        return c2;
    }

    public abstract C next(C var1);

    public abstract C previous(C var1);

    public abstract long distance(C var1, C var2);

    @CanIgnoreReturnValue
    public C minValue() {
        throw new NoSuchElementException();
    }

    @CanIgnoreReturnValue
    public C maxValue() {
        throw new NoSuchElementException();
    }

    private static final class BigIntegerDomain
    extends DiscreteDomain<BigInteger>
    implements Serializable {
        private static final BigIntegerDomain INSTANCE = new BigIntegerDomain();
        private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        private static final long serialVersionUID = 0L;

        BigIntegerDomain() {
            super(true);
        }

        @Override
        public BigInteger next(BigInteger bigInteger) {
            return bigInteger.add(BigInteger.ONE);
        }

        @Override
        public BigInteger previous(BigInteger bigInteger) {
            return bigInteger.subtract(BigInteger.ONE);
        }

        @Override
        BigInteger offset(BigInteger bigInteger, long l2) {
            CollectPreconditions.checkNonnegative(l2, "distance");
            return bigInteger.add(BigInteger.valueOf(l2));
        }

        @Override
        public long distance(BigInteger bigInteger, BigInteger bigInteger2) {
            return bigInteger2.subtract(bigInteger).max(MIN_LONG).min(MAX_LONG).longValue();
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "DiscreteDomain.bigIntegers()";
        }
    }

    private static final class LongDomain
    extends DiscreteDomain<Long>
    implements Serializable {
        private static final LongDomain INSTANCE = new LongDomain();
        private static final long serialVersionUID = 0L;

        LongDomain() {
            super(true);
        }

        @Override
        public Long next(Long l2) {
            long l3 = l2;
            return l3 == Long.MAX_VALUE ? null : Long.valueOf(l3 + 1L);
        }

        @Override
        public Long previous(Long l2) {
            long l3 = l2;
            return l3 == Long.MIN_VALUE ? null : Long.valueOf(l3 - 1L);
        }

        @Override
        Long offset(Long l2, long l3) {
            CollectPreconditions.checkNonnegative(l3, "distance");
            long l4 = l2 + l3;
            if (l4 < 0L) {
                Preconditions.checkArgument(l2 < 0L, "overflow");
            }
            return l4;
        }

        @Override
        public long distance(Long l2, Long l3) {
            long l4 = l3 - l2;
            if (l3 > l2 && l4 < 0L) {
                return Long.MAX_VALUE;
            }
            if (l3 < l2 && l4 > 0L) {
                return Long.MIN_VALUE;
            }
            return l4;
        }

        @Override
        public Long minValue() {
            return Long.MIN_VALUE;
        }

        @Override
        public Long maxValue() {
            return Long.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "DiscreteDomain.longs()";
        }
    }

    private static final class IntegerDomain
    extends DiscreteDomain<Integer>
    implements Serializable {
        private static final IntegerDomain INSTANCE = new IntegerDomain();
        private static final long serialVersionUID = 0L;

        IntegerDomain() {
            super(true);
        }

        @Override
        public Integer next(Integer n2) {
            int n3 = n2;
            return n3 == Integer.MAX_VALUE ? null : Integer.valueOf(n3 + 1);
        }

        @Override
        public Integer previous(Integer n2) {
            int n3 = n2;
            return n3 == Integer.MIN_VALUE ? null : Integer.valueOf(n3 - 1);
        }

        @Override
        Integer offset(Integer n2, long l2) {
            CollectPreconditions.checkNonnegative(l2, "distance");
            return Ints.checkedCast(n2.longValue() + l2);
        }

        @Override
        public long distance(Integer n2, Integer n3) {
            return (long)n3.intValue() - (long)n2.intValue();
        }

        @Override
        public Integer minValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Integer maxValue() {
            return Integer.MAX_VALUE;
        }

        private Object readResolve() {
            return INSTANCE;
        }

        public String toString() {
            return "DiscreteDomain.integers()";
        }
    }
}

