/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable(containerOf={"R", "C", "V"})
@GwtCompatible
final class DenseImmutableTable<R, C, V>
extends RegularImmutableTable<R, C, V> {
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final ImmutableMap<R, ImmutableMap<C, V>> rowMap;
    private final ImmutableMap<C, ImmutableMap<R, V>> columnMap;
    private final int[] rowCounts;
    private final int[] columnCounts;
    private final V[][] values;
    private final int[] cellRowIndices;
    private final int[] cellColumnIndices;

    DenseImmutableTable(ImmutableList<Table.Cell<R, C, V>> immutableList, ImmutableSet<R> immutableSet, ImmutableSet<C> immutableSet2) {
        Object[][] objectArray = new Object[immutableSet.size()][immutableSet2.size()];
        this.values = objectArray;
        this.rowKeyToIndex = Maps.indexMap(immutableSet);
        this.columnKeyToIndex = Maps.indexMap(immutableSet2);
        this.rowCounts = new int[this.rowKeyToIndex.size()];
        this.columnCounts = new int[this.columnKeyToIndex.size()];
        int[] nArray = new int[immutableList.size()];
        int[] nArray2 = new int[immutableList.size()];
        for (int i2 = 0; i2 < immutableList.size(); ++i2) {
            Table.Cell cell = (Table.Cell)immutableList.get(i2);
            Object r2 = cell.getRowKey();
            Object c2 = cell.getColumnKey();
            int n2 = this.rowKeyToIndex.get(r2);
            int n3 = this.columnKeyToIndex.get(c2);
            V v2 = this.values[n2][n3];
            this.checkNoDuplicate(r2, c2, v2, cell.getValue());
            this.values[n2][n3] = cell.getValue();
            int n4 = n2;
            this.rowCounts[n4] = this.rowCounts[n4] + 1;
            int n5 = n3;
            this.columnCounts[n5] = this.columnCounts[n5] + 1;
            nArray[i2] = n2;
            nArray2[i2] = n3;
        }
        this.cellRowIndices = nArray;
        this.cellColumnIndices = nArray2;
        this.rowMap = new RowMap();
        this.columnMap = new ColumnMap();
    }

    @Override
    public ImmutableMap<C, Map<R, V>> columnMap() {
        ImmutableMap<C, ImmutableMap<R, V>> immutableMap = this.columnMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public ImmutableMap<R, Map<C, V>> rowMap() {
        ImmutableMap<R, ImmutableMap<C, V>> immutableMap = this.rowMap;
        return ImmutableMap.copyOf(immutableMap);
    }

    @Override
    public V get(@Nullable Object object, @Nullable Object object2) {
        Integer n2 = this.rowKeyToIndex.get(object);
        Integer n3 = this.columnKeyToIndex.get(object2);
        return n2 == null || n3 == null ? null : (V)this.values[n2][n3];
    }

    @Override
    public int size() {
        return this.cellRowIndices.length;
    }

    @Override
    Table.Cell<R, C, V> getCell(int n2) {
        int n3 = this.cellRowIndices[n2];
        int n4 = this.cellColumnIndices[n2];
        Object e2 = ((ImmutableSet)this.rowKeySet()).asList().get(n3);
        Object e3 = ((ImmutableSet)this.columnKeySet()).asList().get(n4);
        V v2 = this.values[n3][n4];
        return DenseImmutableTable.cellOf(e2, e3, v2);
    }

    @Override
    V getValue(int n2) {
        return this.values[this.cellRowIndices[n2]][this.cellColumnIndices[n2]];
    }

    @Override
    ImmutableTable.SerializedForm createSerializedForm() {
        return ImmutableTable.SerializedForm.create(this, this.cellRowIndices, this.cellColumnIndices);
    }

    private final class ColumnMap
    extends ImmutableArrayMap<C, ImmutableMap<R, V>> {
        private ColumnMap() {
            super(DenseImmutableTable.this.columnCounts.length);
        }

        @Override
        ImmutableMap<C, Integer> keyToIndex() {
            return DenseImmutableTable.this.columnKeyToIndex;
        }

        @Override
        ImmutableMap<R, V> getValue(int n2) {
            return new Column(n2);
        }

        @Override
        boolean isPartialView() {
            return false;
        }
    }

    private final class RowMap
    extends ImmutableArrayMap<R, ImmutableMap<C, V>> {
        private RowMap() {
            super(DenseImmutableTable.this.rowCounts.length);
        }

        @Override
        ImmutableMap<R, Integer> keyToIndex() {
            return DenseImmutableTable.this.rowKeyToIndex;
        }

        @Override
        ImmutableMap<C, V> getValue(int n2) {
            return new Row(n2);
        }

        @Override
        boolean isPartialView() {
            return false;
        }
    }

    private final class Column
    extends ImmutableArrayMap<R, V> {
        private final int columnIndex;

        Column(int n2) {
            super(DenseImmutableTable.this.columnCounts[n2]);
            this.columnIndex = n2;
        }

        @Override
        ImmutableMap<R, Integer> keyToIndex() {
            return DenseImmutableTable.this.rowKeyToIndex;
        }

        @Override
        V getValue(int n2) {
            return DenseImmutableTable.this.values[n2][this.columnIndex];
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private final class Row
    extends ImmutableArrayMap<C, V> {
        private final int rowIndex;

        Row(int n2) {
            super(DenseImmutableTable.this.rowCounts[n2]);
            this.rowIndex = n2;
        }

        @Override
        ImmutableMap<C, Integer> keyToIndex() {
            return DenseImmutableTable.this.columnKeyToIndex;
        }

        @Override
        V getValue(int n2) {
            return DenseImmutableTable.this.values[this.rowIndex][n2];
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private static abstract class ImmutableArrayMap<K, V>
    extends ImmutableMap.IteratorBasedImmutableMap<K, V> {
        private final int size;

        ImmutableArrayMap(int n2) {
            this.size = n2;
        }

        abstract ImmutableMap<K, Integer> keyToIndex();

        private boolean isFull() {
            return this.size == this.keyToIndex().size();
        }

        K getKey(int n2) {
            return (K)((ImmutableSet)this.keyToIndex().keySet()).asList().get(n2);
        }

        abstract @Nullable V getValue(int var1);

        @Override
        ImmutableSet<K> createKeySet() {
            return this.isFull() ? this.keyToIndex().keySet() : super.createKeySet();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public V get(@Nullable Object object) {
            Integer n2 = this.keyToIndex().get(object);
            return n2 == null ? null : (V)this.getValue(n2);
        }

        @Override
        UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
            return new AbstractIterator<Map.Entry<K, V>>(){
                private int index = -1;
                private final int maxIndex = this.keyToIndex().size();

                @Override
                protected Map.Entry<K, V> computeNext() {
                    ++this.index;
                    while (this.index < this.maxIndex) {
                        Object v2 = this.getValue(this.index);
                        if (v2 != null) {
                            return Maps.immutableEntry(this.getKey(this.index), v2);
                        }
                        ++this.index;
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }
    }
}

