/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingImmutableSortedSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RegularContiguousSet;
import java.util.NoSuchElementException;

@GwtCompatible(emulated=true)
public abstract class ContiguousSet<C extends Comparable>
extends ImmutableSortedSet<C> {
    final DiscreteDomain<C> domain;

    public static <C extends Comparable> ContiguousSet<C> create(Range<C> range, DiscreteDomain<C> discreteDomain) {
        Preconditions.checkNotNull(range);
        Preconditions.checkNotNull(discreteDomain);
        Range<C> range2 = range;
        try {
            if (!range.hasLowerBound()) {
                range2 = range2.intersection(Range.atLeast(discreteDomain.minValue()));
            }
            if (!range.hasUpperBound()) {
                range2 = range2.intersection(Range.atMost(discreteDomain.maxValue()));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException);
        }
        boolean bl2 = range2.isEmpty() || Range.compareOrThrow(range.lowerBound.leastValueAbove(discreteDomain), range.upperBound.greatestValueBelow(discreteDomain)) > 0;
        return bl2 ? new EmptyContiguousSet<C>(discreteDomain) : new RegularContiguousSet<C>(range2, discreteDomain);
    }

    @Beta
    public static ContiguousSet<Integer> closed(int n2, int n3) {
        return ContiguousSet.create(Range.closed(n2, n3), DiscreteDomain.integers());
    }

    @Beta
    public static ContiguousSet<Long> closed(long l2, long l3) {
        return ContiguousSet.create(Range.closed(l2, l3), DiscreteDomain.longs());
    }

    @Beta
    public static ContiguousSet<Integer> closedOpen(int n2, int n3) {
        return ContiguousSet.create(Range.closedOpen(n2, n3), DiscreteDomain.integers());
    }

    @Beta
    public static ContiguousSet<Long> closedOpen(long l2, long l3) {
        return ContiguousSet.create(Range.closedOpen(l2, l3), DiscreteDomain.longs());
    }

    ContiguousSet(DiscreteDomain<C> discreteDomain) {
        super(Ordering.natural());
        this.domain = discreteDomain;
    }

    @Override
    public ContiguousSet<C> headSet(C c2) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), false);
    }

    @Override
    @GwtIncompatible
    public ContiguousSet<C> headSet(C c2, boolean bl2) {
        return this.headSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), bl2);
    }

    @Override
    public ContiguousSet<C> subSet(C c2, C c3) {
        Preconditions.checkNotNull(c2);
        Preconditions.checkNotNull(c3);
        Preconditions.checkArgument(this.comparator().compare(c2, c3) <= 0);
        return this.subSetImpl(c2, true, c3, false);
    }

    @Override
    @GwtIncompatible
    public ContiguousSet<C> subSet(C c2, boolean bl2, C c3, boolean bl3) {
        Preconditions.checkNotNull(c2);
        Preconditions.checkNotNull(c3);
        Preconditions.checkArgument(this.comparator().compare(c2, c3) <= 0);
        return this.subSetImpl(c2, bl2, c3, bl3);
    }

    @Override
    public ContiguousSet<C> tailSet(C c2) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), true);
    }

    @Override
    @GwtIncompatible
    public ContiguousSet<C> tailSet(C c2, boolean bl2) {
        return this.tailSetImpl((C)((Comparable)Preconditions.checkNotNull(c2)), bl2);
    }

    @Override
    abstract ContiguousSet<C> headSetImpl(C var1, boolean var2);

    @Override
    abstract ContiguousSet<C> subSetImpl(C var1, boolean var2, C var3, boolean var4);

    @Override
    abstract ContiguousSet<C> tailSetImpl(C var1, boolean var2);

    public abstract ContiguousSet<C> intersection(ContiguousSet<C> var1);

    public abstract Range<C> range();

    public abstract Range<C> range(BoundType var1, BoundType var2);

    @Override
    @GwtIncompatible
    ImmutableSortedSet<C> createDescendingSet() {
        return new DescendingImmutableSortedSet(this);
    }

    @Override
    public String toString() {
        return this.range().toString();
    }

    @Deprecated
    public static <E> ImmutableSortedSet.Builder<E> builder() {
        throw new UnsupportedOperationException();
    }
}

