/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
public final class ConcurrentHashMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private final transient ConcurrentMap<E, AtomicInteger> countMap;
    private static final long serialVersionUID = 1L;

    public static <E> ConcurrentHashMultiset<E> create() {
        return new ConcurrentHashMultiset(new ConcurrentHashMap());
    }

    public static <E> ConcurrentHashMultiset<E> create(Iterable<? extends E> iterable) {
        ConcurrentHashMultiset<E> concurrentHashMultiset = ConcurrentHashMultiset.create();
        Iterables.addAll(concurrentHashMultiset, iterable);
        return concurrentHashMultiset;
    }

    @Beta
    public static <E> ConcurrentHashMultiset<E> create(ConcurrentMap<E, AtomicInteger> concurrentMap) {
        return new ConcurrentHashMultiset<E>(concurrentMap);
    }

    @VisibleForTesting
    ConcurrentHashMultiset(ConcurrentMap<E, AtomicInteger> concurrentMap) {
        Preconditions.checkArgument(concurrentMap.isEmpty(), "the backing map (%s) must be empty", concurrentMap);
        this.countMap = concurrentMap;
    }

    @Override
    public int count(@Nullable Object object) {
        AtomicInteger atomicInteger = Maps.safeGet(this.countMap, object);
        return atomicInteger == null ? 0 : atomicInteger.get();
    }

    @Override
    public int size() {
        long l2 = 0L;
        for (AtomicInteger atomicInteger : this.countMap.values()) {
            l2 += (long)atomicInteger.get();
        }
        return Ints.saturatedCast(l2);
    }

    @Override
    public Object[] toArray() {
        return this.snapshot().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.snapshot().toArray(TArray);
    }

    private List<E> snapshot() {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize(this.size());
        for (Multiset.Entry entry : this.entrySet()) {
            Object e2 = entry.getElement();
            for (int i2 = entry.getCount(); i2 > 0; --i2) {
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    @Override
    @CanIgnoreReturnValue
    public int add(E e2, int n2) {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2;
        Preconditions.checkNotNull(e2);
        if (n2 == 0) {
            return this.count(e2);
        }
        CollectPreconditions.checkPositive(n2, "occurences");
        do {
            int n3;
            if ((atomicInteger = Maps.safeGet(this.countMap, e2)) == null && (atomicInteger = this.countMap.putIfAbsent(e2, new AtomicInteger(n2))) == null) {
                return 0;
            }
            while ((n3 = atomicInteger.get()) != 0) {
                try {
                    int n4 = IntMath.checkedAdd(n3, n2);
                    if (!atomicInteger.compareAndSet(n3, n4)) continue;
                    return n3;
                }
                catch (ArithmeticException arithmeticException) {
                    throw new IllegalArgumentException("Overflow adding " + n2 + " occurrences to a count of " + n3);
                }
            }
        } while (this.countMap.putIfAbsent(e2, atomicInteger2 = new AtomicInteger(n2)) != null && !this.countMap.replace(e2, atomicInteger, atomicInteger2));
        return 0;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@Nullable Object object, int n2) {
        int n3;
        if (n2 == 0) {
            return this.count(object);
        }
        CollectPreconditions.checkPositive(n2, "occurences");
        AtomicInteger atomicInteger = Maps.safeGet(this.countMap, object);
        if (atomicInteger == null) {
            return 0;
        }
        while ((n3 = atomicInteger.get()) != 0) {
            int n4 = Math.max(0, n3 - n2);
            if (!atomicInteger.compareAndSet(n3, n4)) continue;
            if (n4 == 0) {
                this.countMap.remove(object, atomicInteger);
            }
            return n3;
        }
        return 0;
    }

    @CanIgnoreReturnValue
    public boolean removeExactly(@Nullable Object object, int n2) {
        int n3;
        int n4;
        if (n2 == 0) {
            return true;
        }
        CollectPreconditions.checkPositive(n2, "occurences");
        AtomicInteger atomicInteger = Maps.safeGet(this.countMap, object);
        if (atomicInteger == null) {
            return false;
        }
        do {
            if ((n4 = atomicInteger.get()) >= n2) continue;
            return false;
        } while (!atomicInteger.compareAndSet(n4, n3 = n4 - n2));
        if (n3 == 0) {
            this.countMap.remove(object, atomicInteger);
        }
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(E e2, int n2) {
        int n3;
        AtomicInteger atomicInteger;
        Preconditions.checkNotNull(e2);
        CollectPreconditions.checkNonnegative(n2, "count");
        block0: while (true) {
            if ((atomicInteger = Maps.safeGet(this.countMap, e2)) == null) {
                if (n2 == 0) {
                    return 0;
                }
                atomicInteger = this.countMap.putIfAbsent(e2, new AtomicInteger(n2));
                if (atomicInteger == null) {
                    return 0;
                }
            }
            do {
                if ((n3 = atomicInteger.get()) != 0) continue;
                if (n2 == 0) {
                    return 0;
                }
                AtomicInteger atomicInteger2 = new AtomicInteger(n2);
                if (this.countMap.putIfAbsent(e2, atomicInteger2) != null && !this.countMap.replace(e2, atomicInteger, atomicInteger2)) continue block0;
                return 0;
            } while (!atomicInteger.compareAndSet(n3, n2));
            break;
        }
        if (n2 == 0) {
            this.countMap.remove(e2, atomicInteger);
        }
        return n3;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean setCount(E e2, int n2, int n3) {
        Preconditions.checkNotNull(e2);
        CollectPreconditions.checkNonnegative(n2, "oldCount");
        CollectPreconditions.checkNonnegative(n3, "newCount");
        AtomicInteger atomicInteger = Maps.safeGet(this.countMap, e2);
        if (atomicInteger == null) {
            if (n2 != 0) {
                return false;
            }
            if (n3 == 0) {
                return true;
            }
            return this.countMap.putIfAbsent(e2, new AtomicInteger(n3)) == null;
        }
        int n4 = atomicInteger.get();
        if (n4 == n2) {
            if (n4 == 0) {
                if (n3 == 0) {
                    this.countMap.remove(e2, atomicInteger);
                    return true;
                }
                AtomicInteger atomicInteger2 = new AtomicInteger(n3);
                return this.countMap.putIfAbsent(e2, atomicInteger2) == null || this.countMap.replace(e2, atomicInteger, atomicInteger2);
            }
            if (atomicInteger.compareAndSet(n4, n3)) {
                if (n3 == 0) {
                    this.countMap.remove(e2, atomicInteger);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    Set<E> createElementSet() {
        final Set set = this.countMap.keySet();
        return new ForwardingSet<E>(){

            @Override
            protected Set<E> delegate() {
                return set;
            }

            @Override
            public boolean contains(@Nullable Object object) {
                return object != null && Collections2.safeContains(set, object);
            }

            @Override
            public boolean containsAll(Collection<?> collection) {
                return this.standardContainsAll(collection);
            }

            @Override
            public boolean remove(Object object) {
                return object != null && Collections2.safeRemove(set, object);
            }

            @Override
            public boolean removeAll(Collection<?> collection) {
                return this.standardRemoveAll(collection);
            }
        };
    }

    @Override
    Iterator<E> elementIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    @Deprecated
    public Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    @Override
    int distinctElements() {
        return this.countMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.countMap.isEmpty();
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        final AbstractIterator abstractIterator = new AbstractIterator<Multiset.Entry<E>>(){
            private final Iterator<Map.Entry<E, AtomicInteger>> mapEntries;
            {
                this.mapEntries = ConcurrentHashMultiset.this.countMap.entrySet().iterator();
            }

            @Override
            protected Multiset.Entry<E> computeNext() {
                Map.Entry entry;
                int n2;
                do {
                    if (this.mapEntries.hasNext()) continue;
                    return (Multiset.Entry)this.endOfData();
                } while ((n2 = (entry = this.mapEntries.next()).getValue().get()) == 0);
                return Multisets.immutableEntry(entry.getKey(), n2);
            }
        };
        return new ForwardingIterator<Multiset.Entry<E>>(){
            private  @Nullable Multiset.Entry<E> last;

            @Override
            protected Iterator<Multiset.Entry<E>> delegate() {
                return abstractIterator;
            }

            @Override
            public Multiset.Entry<E> next() {
                this.last = (Multiset.Entry)super.next();
                return this.last;
            }

            @Override
            public void remove() {
                CollectPreconditions.checkRemove(this.last != null);
                ConcurrentHashMultiset.this.setCount(this.last.getElement(), 0);
                this.last = null;
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return Multisets.iteratorImpl(this);
    }

    @Override
    public void clear() {
        this.countMap.clear();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.countMap);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        ConcurrentMap concurrentMap = (ConcurrentMap)objectInputStream.readObject();
        FieldSettersHolder.COUNT_MAP_FIELD_SETTER.set(this, concurrentMap);
    }

    private class EntrySet
    extends AbstractMultiset.EntrySet {
        private EntrySet() {
        }

        @Override
        ConcurrentHashMultiset<E> multiset() {
            return ConcurrentHashMultiset.this;
        }

        @Override
        public Object[] toArray() {
            return this.snapshot().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.snapshot().toArray(TArray);
        }

        private List<Multiset.Entry<E>> snapshot() {
            ArrayList arrayList = Lists.newArrayListWithExpectedSize(this.size());
            Iterators.addAll(arrayList, this.iterator());
            return arrayList;
        }
    }

    private static class FieldSettersHolder {
        static final Serialization.FieldSetter<ConcurrentHashMultiset> COUNT_MAP_FIELD_SETTER = Serialization.getFieldSetter(ConcurrentHashMultiset.class, "countMap");

        private FieldSettersHolder() {
        }
    }
}

