/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

@GwtCompatible(serializable=true)
final class CompoundOrdering<T>
extends Ordering<T>
implements Serializable {
    final Comparator<? super T>[] comparators;
    private static final long serialVersionUID = 0L;

    CompoundOrdering(Comparator<? super T> comparator, Comparator<? super T> comparator2) {
        this.comparators = new Comparator[]{comparator, comparator2};
    }

    CompoundOrdering(Iterable<? extends Comparator<? super T>> iterable) {
        this.comparators = Iterables.toArray(iterable, new Comparator[0]);
    }

    @Override
    public int compare(T t2, T t3) {
        for (int i2 = 0; i2 < this.comparators.length; ++i2) {
            int n2 = this.comparators[i2].compare(t2, t3);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CompoundOrdering) {
            CompoundOrdering compoundOrdering = (CompoundOrdering)object;
            return Arrays.equals(this.comparators, compoundOrdering.comparators);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.comparators);
    }

    public String toString() {
        return "Ordering.compound(" + Arrays.toString(this.comparators) + ")";
    }
}

