/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Comparator;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public abstract class ComparisonChain {
    private static final ComparisonChain ACTIVE = new ComparisonChain(){

        public ComparisonChain compare(Comparable comparable, Comparable comparable2) {
            return this.classify(comparable.compareTo(comparable2));
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T t2, @Nullable T t3, Comparator<T> comparator) {
            return this.classify(comparator.compare(t2, t3));
        }

        @Override
        public ComparisonChain compare(int n2, int n3) {
            return this.classify(Ints.compare(n2, n3));
        }

        @Override
        public ComparisonChain compare(long l2, long l3) {
            return this.classify(Longs.compare(l2, l3));
        }

        @Override
        public ComparisonChain compare(float f2, float f3) {
            return this.classify(Float.compare(f2, f3));
        }

        @Override
        public ComparisonChain compare(double d2, double d3) {
            return this.classify(Double.compare(d2, d3));
        }

        @Override
        public ComparisonChain compareTrueFirst(boolean bl2, boolean bl3) {
            return this.classify(Booleans.compare(bl3, bl2));
        }

        @Override
        public ComparisonChain compareFalseFirst(boolean bl2, boolean bl3) {
            return this.classify(Booleans.compare(bl2, bl3));
        }

        ComparisonChain classify(int n2) {
            return n2 < 0 ? LESS : (n2 > 0 ? GREATER : ACTIVE);
        }

        @Override
        public int result() {
            return 0;
        }
    };
    private static final ComparisonChain LESS = new InactiveComparisonChain(-1);
    private static final ComparisonChain GREATER = new InactiveComparisonChain(1);

    private ComparisonChain() {
    }

    public static ComparisonChain start() {
        return ACTIVE;
    }

    public abstract ComparisonChain compare(Comparable<?> var1, Comparable<?> var2);

    public abstract <T> ComparisonChain compare(@Nullable T var1, @Nullable T var2, Comparator<T> var3);

    public abstract ComparisonChain compare(int var1, int var2);

    public abstract ComparisonChain compare(long var1, long var3);

    public abstract ComparisonChain compare(float var1, float var2);

    public abstract ComparisonChain compare(double var1, double var3);

    @Deprecated
    public final ComparisonChain compare(Boolean bl2, Boolean bl3) {
        return this.compareFalseFirst(bl2, bl3);
    }

    public abstract ComparisonChain compareTrueFirst(boolean var1, boolean var2);

    public abstract ComparisonChain compareFalseFirst(boolean var1, boolean var2);

    public abstract int result();

    private static final class InactiveComparisonChain
    extends ComparisonChain {
        final int result;

        InactiveComparisonChain(int n2) {
            this.result = n2;
        }

        public ComparisonChain compare(@Nullable Comparable comparable, @Nullable Comparable comparable2) {
            return this;
        }

        @Override
        public <T> ComparisonChain compare(@Nullable T t2, @Nullable T t3, @Nullable Comparator<T> comparator) {
            return this;
        }

        @Override
        public ComparisonChain compare(int n2, int n3) {
            return this;
        }

        @Override
        public ComparisonChain compare(long l2, long l3) {
            return this;
        }

        @Override
        public ComparisonChain compare(float f2, float f3) {
            return this;
        }

        @Override
        public ComparisonChain compare(double d2, double d3) {
            return this;
        }

        @Override
        public ComparisonChain compareTrueFirst(boolean bl2, boolean bl3) {
            return this;
        }

        @Override
        public ComparisonChain compareFalseFirst(boolean bl2, boolean bl3) {
            return this;
        }

        @Override
        public int result() {
            return this.result;
        }
    }
}

