/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.CompactHashSet;
import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Spliterator;
import java.util.Spliterators;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@GwtIncompatible
class CompactLinkedHashSet<E>
extends CompactHashSet<E> {
    private static final int ENDPOINT = -2;
    private transient int @MonotonicNonNull [] predecessor;
    private transient int @MonotonicNonNull [] successor;
    private transient int firstEntry;
    private transient int lastEntry;

    public static <E> CompactLinkedHashSet<E> create() {
        return new CompactLinkedHashSet<E>();
    }

    public static <E> CompactLinkedHashSet<E> create(Collection<? extends E> collection) {
        CompactLinkedHashSet<E> compactLinkedHashSet = CompactLinkedHashSet.createWithExpectedSize(collection.size());
        compactLinkedHashSet.addAll(collection);
        return compactLinkedHashSet;
    }

    public static <E> CompactLinkedHashSet<E> create(E ... EArray) {
        CompactLinkedHashSet<E> compactLinkedHashSet = CompactLinkedHashSet.createWithExpectedSize(EArray.length);
        Collections.addAll(compactLinkedHashSet, EArray);
        return compactLinkedHashSet;
    }

    public static <E> CompactLinkedHashSet<E> createWithExpectedSize(int n2) {
        return new CompactLinkedHashSet<E>(n2);
    }

    CompactLinkedHashSet() {
    }

    CompactLinkedHashSet(int n2) {
        super(n2);
    }

    @Override
    void init(int n2) {
        super.init(n2);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    void allocArrays() {
        super.allocArrays();
        int n2 = this.elements.length;
        this.predecessor = new int[n2];
        this.successor = new int[n2];
        Arrays.fill(this.predecessor, -1);
        Arrays.fill(this.successor, -1);
    }

    private int getPredecessor(int n2) {
        return this.predecessor[n2];
    }

    @Override
    int getSuccessor(int n2) {
        return this.successor[n2];
    }

    private void setSuccessor(int n2, int n3) {
        this.successor[n2] = n3;
    }

    private void setPredecessor(int n2, int n3) {
        this.predecessor[n2] = n3;
    }

    private void setSucceeds(int n2, int n3) {
        if (n2 == -2) {
            this.firstEntry = n3;
        } else {
            this.setSuccessor(n2, n3);
        }
        if (n3 == -2) {
            this.lastEntry = n2;
        } else {
            this.setPredecessor(n3, n2);
        }
    }

    @Override
    void insertEntry(int n2, E e2, int n3) {
        super.insertEntry(n2, e2, n3);
        this.setSucceeds(this.lastEntry, n2);
        this.setSucceeds(n2, -2);
    }

    @Override
    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        super.moveLastEntry(n2);
        this.setSucceeds(this.getPredecessor(n2), this.getSuccessor(n2));
        if (n2 < n3) {
            this.setSucceeds(this.getPredecessor(n3), n2);
            this.setSucceeds(n2, this.getSuccessor(n3));
        }
        this.predecessor[n3] = -1;
        this.successor[n3] = -1;
    }

    @Override
    void resizeEntries(int n2) {
        super.resizeEntries(n2);
        int n3 = this.predecessor.length;
        this.predecessor = Arrays.copyOf(this.predecessor, n2);
        this.successor = Arrays.copyOf(this.successor, n2);
        if (n3 < n2) {
            Arrays.fill(this.predecessor, n3, n2, -1);
            Arrays.fill(this.successor, n3, n2, -1);
        }
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int adjustAfterRemove(int n2, int n3) {
        return n2 >= this.size() ? n3 : n2;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return ObjectArrays.toArrayImpl(this, TArray);
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        Arrays.fill(this.predecessor, 0, this.size(), -1);
        Arrays.fill(this.successor, 0, this.size(), -1);
        super.clear();
    }
}

