/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.CompactHashMap;
import com.google.common.collect.ObjectArrays;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@GwtIncompatible
class CompactLinkedHashMap<K, V>
extends CompactHashMap<K, V> {
    private static final int ENDPOINT = -2;
    @VisibleForTesting
    transient long @MonotonicNonNull [] links;
    private transient int firstEntry;
    private transient int lastEntry;
    private final boolean accessOrder;

    public static <K, V> CompactLinkedHashMap<K, V> create() {
        return new CompactLinkedHashMap<K, V>();
    }

    public static <K, V> CompactLinkedHashMap<K, V> createWithExpectedSize(int n2) {
        return new CompactLinkedHashMap<K, V>(n2);
    }

    CompactLinkedHashMap() {
        this(3);
    }

    CompactLinkedHashMap(int n2) {
        this(n2, false);
    }

    CompactLinkedHashMap(int n2, boolean bl2) {
        super(n2);
        this.accessOrder = bl2;
    }

    @Override
    void init(int n2) {
        super.init(n2);
        this.firstEntry = -2;
        this.lastEntry = -2;
    }

    @Override
    void allocArrays() {
        super.allocArrays();
        int n2 = this.keys.length;
        this.links = new long[n2];
        Arrays.fill(this.links, -1L);
    }

    private int getPredecessor(int n2) {
        return (int)(this.links[n2] >>> 32);
    }

    @Override
    int getSuccessor(int n2) {
        return (int)this.links[n2];
    }

    private void setSuccessor(int n2, int n3) {
        long l2 = 0xFFFFFFFFL;
        this.links[n2] = this.links[n2] & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | (long)n3 & l2;
    }

    private void setPredecessor(int n2, int n3) {
        long l2 = -4294967296L;
        this.links[n2] = this.links[n2] & (l2 ^ 0xFFFFFFFFFFFFFFFFL) | (long)n3 << 32;
    }

    private void setSucceeds(int n2, int n3) {
        if (n2 == -2) {
            this.firstEntry = n3;
        } else {
            this.setSuccessor(n2, n3);
        }
        if (n3 == -2) {
            this.lastEntry = n2;
        } else {
            this.setPredecessor(n3, n2);
        }
    }

    @Override
    void insertEntry(int n2, K k2, V v2, int n3) {
        super.insertEntry(n2, k2, v2, n3);
        this.setSucceeds(this.lastEntry, n2);
        this.setSucceeds(n2, -2);
    }

    @Override
    void accessEntry(int n2) {
        if (this.accessOrder) {
            this.setSucceeds(this.getPredecessor(n2), this.getSuccessor(n2));
            this.setSucceeds(this.lastEntry, n2);
            this.setSucceeds(n2, -2);
            ++this.modCount;
        }
    }

    @Override
    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        super.moveLastEntry(n2);
        this.setSucceeds(this.getPredecessor(n2), this.getSuccessor(n2));
        if (n2 < n3) {
            this.setSucceeds(this.getPredecessor(n3), n2);
            this.setSucceeds(n2, this.getSuccessor(n3));
        }
        this.links[n3] = -1L;
    }

    @Override
    void resizeEntries(int n2) {
        super.resizeEntries(n2);
        int n3 = this.links.length;
        this.links = Arrays.copyOf(this.links, n2);
        if (n3 < n2) {
            Arrays.fill(this.links, n3, n2, -1L);
        }
    }

    @Override
    int firstEntryIndex() {
        return this.firstEntry;
    }

    @Override
    int adjustAfterRemove(int n2, int n3) {
        return n2 >= this.size() ? n3 : n2;
    }

    @Override
    Set<Map.Entry<K, V>> createEntrySet() {
        class EntrySetImpl
        extends CompactHashMap.EntrySetView {
            EntrySetImpl() {
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return Spliterators.spliterator(this, 17);
            }
        }
        return new EntrySetImpl();
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends CompactHashMap.KeySetView {
            KeySetImpl() {
            }

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return ObjectArrays.toArrayImpl(this, TArray);
            }

            @Override
            public Spliterator<K> spliterator() {
                return Spliterators.spliterator(this, 17);
            }
        }
        return new KeySetImpl();
    }

    @Override
    Collection<V> createValues() {
        class ValuesImpl
        extends CompactHashMap.ValuesView {
            ValuesImpl() {
            }

            @Override
            public Object[] toArray() {
                return ObjectArrays.toArrayImpl(this);
            }

            @Override
            public <T> T[] toArray(T[] TArray) {
                return ObjectArrays.toArrayImpl(this, TArray);
            }

            @Override
            public Spliterator<V> spliterator() {
                return Spliterators.spliterator(this, 16);
            }
        }
        return new ValuesImpl();
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        this.firstEntry = -2;
        this.lastEntry = -2;
        Arrays.fill(this.links, 0, this.size(), -1L);
        super.clear();
    }
}

