/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ObjectArrays;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
class CompactHashSet<E>
extends AbstractSet<E>
implements Serializable {
    private static final float LOAD_FACTOR = 1.0f;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    private static final long HASH_MASK = -4294967296L;
    @VisibleForTesting
    static final int DEFAULT_SIZE = 3;
    static final int UNSET = -1;
    private transient int @MonotonicNonNull [] table;
    private transient long @MonotonicNonNull [] entries;
    transient Object @MonotonicNonNull [] elements;
    transient int modCount;
    private transient int size;

    public static <E> CompactHashSet<E> create() {
        return new CompactHashSet<E>();
    }

    public static <E> CompactHashSet<E> create(Collection<? extends E> collection) {
        CompactHashSet<E> compactHashSet = CompactHashSet.createWithExpectedSize(collection.size());
        compactHashSet.addAll(collection);
        return compactHashSet;
    }

    public static <E> CompactHashSet<E> create(E ... EArray) {
        CompactHashSet<E> compactHashSet = CompactHashSet.createWithExpectedSize(EArray.length);
        Collections.addAll(compactHashSet, EArray);
        return compactHashSet;
    }

    public static <E> CompactHashSet<E> createWithExpectedSize(int n2) {
        return new CompactHashSet<E>(n2);
    }

    CompactHashSet() {
        this.init(3);
    }

    CompactHashSet(int n2) {
        this.init(n2);
    }

    void init(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Initial capacity must be non-negative");
        this.modCount = Math.max(1, n2);
    }

    boolean needsAllocArrays() {
        return this.table == null;
    }

    void allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int n2 = this.modCount;
        int n3 = Hashing.closedTableSize(n2, 1.0);
        this.table = CompactHashSet.newTable(n3);
        this.entries = CompactHashSet.newEntries(n2);
        this.elements = new Object[n2];
    }

    private static int[] newTable(int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private static long[] newEntries(int n2) {
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        return lArray;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private static int getHash(long l2) {
        return (int)(l2 >>> 32);
    }

    private static int getNext(long l2) {
        return (int)l2;
    }

    private static long swapNext(long l2, int n2) {
        return 0xFFFFFFFF00000000L & l2 | 0xFFFFFFFFL & (long)n2;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean add(@Nullable E e2) {
        int n2;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        long[] lArray = this.entries;
        Object[] objectArray = this.elements;
        int n3 = Hashing.smearedHash(e2);
        int n4 = n3 & this.hashTableMask();
        int n5 = this.size;
        int n6 = this.table[n4];
        if (n6 == -1) {
            this.table[n4] = n5;
        } else {
            long l2;
            do {
                n2 = n6;
                l2 = lArray[n6];
                if (CompactHashSet.getHash(l2) != n3 || !Objects.equal(e2, objectArray[n6])) continue;
                return false;
            } while ((n6 = CompactHashSet.getNext(l2)) != -1);
            lArray[n2] = CompactHashSet.swapNext(l2, n5);
        }
        if (n5 == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        n2 = n5 + 1;
        this.resizeMeMaybe(n2);
        this.insertEntry(n5, e2, n3);
        this.size = n2;
        int n7 = this.table.length;
        if (Hashing.needsResizing(n5, n7, 1.0)) {
            this.resizeTable(2 * n7);
        }
        ++this.modCount;
        return true;
    }

    void insertEntry(int n2, E e2, int n3) {
        this.entries[n2] = (long)n3 << 32 | 0xFFFFFFFFL;
        this.elements[n2] = e2;
    }

    private void resizeMeMaybe(int n2) {
        int n3 = this.entries.length;
        if (n2 > n3) {
            int n4 = n3 + Math.max(1, n3 >>> 1);
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            if (n4 != n3) {
                this.resizeEntries(n4);
            }
        }
    }

    void resizeEntries(int n2) {
        this.elements = Arrays.copyOf(this.elements, n2);
        long[] lArray = this.entries;
        int n3 = lArray.length;
        lArray = Arrays.copyOf(lArray, n2);
        if (n2 > n3) {
            Arrays.fill(lArray, n3, n2, -1L);
        }
        this.entries = lArray;
    }

    private void resizeTable(int n2) {
        int[] nArray = CompactHashSet.newTable(n2);
        long[] lArray = this.entries;
        int n3 = nArray.length - 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            long l2 = lArray[i2];
            int n4 = CompactHashSet.getHash(l2);
            int n5 = n4 & n3;
            int n6 = nArray[n5];
            nArray[n5] = i2;
            lArray[i2] = (long)n4 << 32 | 0xFFFFFFFFL & (long)n6;
        }
        this.table = nArray;
    }

    @Override
    public boolean contains(@Nullable Object object) {
        if (this.needsAllocArrays()) {
            return false;
        }
        int n2 = Hashing.smearedHash(object);
        int n3 = this.table[n2 & this.hashTableMask()];
        while (n3 != -1) {
            long l2 = this.entries[n3];
            if (CompactHashSet.getHash(l2) == n2 && Objects.equal(object, this.elements[n3])) {
                return true;
            }
            n3 = CompactHashSet.getNext(l2);
        }
        return false;
    }

    @Override
    @CanIgnoreReturnValue
    public boolean remove(@Nullable Object object) {
        if (this.needsAllocArrays()) {
            return false;
        }
        return this.remove(object, Hashing.smearedHash(object));
    }

    @CanIgnoreReturnValue
    private boolean remove(Object object, int n2) {
        int n3 = n2 & this.hashTableMask();
        int n4 = this.table[n3];
        if (n4 == -1) {
            return false;
        }
        int n5 = -1;
        do {
            if (CompactHashSet.getHash(this.entries[n4]) == n2 && Objects.equal(object, this.elements[n4])) {
                if (n5 == -1) {
                    this.table[n3] = CompactHashSet.getNext(this.entries[n4]);
                } else {
                    this.entries[n5] = CompactHashSet.swapNext(this.entries[n5], CompactHashSet.getNext(this.entries[n4]));
                }
                this.moveLastEntry(n4);
                --this.size;
                ++this.modCount;
                return true;
            }
            n5 = n4;
        } while ((n4 = CompactHashSet.getNext(this.entries[n4])) != -1);
        return false;
    }

    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        if (n2 < n3) {
            long l2;
            this.elements[n2] = this.elements[n3];
            this.elements[n3] = null;
            this.entries[n2] = l2 = this.entries[n3];
            this.entries[n3] = -1L;
            int n4 = CompactHashSet.getHash(l2) & this.hashTableMask();
            int n5 = this.table[n4];
            if (n5 == n3) {
                this.table[n4] = n2;
            } else {
                long l3;
                do {
                    int n6 = n5;
                } while ((n5 = CompactHashSet.getNext(l3 = this.entries[n5])) != n3);
                this.entries[n6] = CompactHashSet.swapNext(l3, n2);
            }
        } else {
            this.elements[n2] = null;
            this.entries[n2] = -1L;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int n2) {
        return n2 + 1 < this.size ? n2 + 1 : -1;
    }

    int adjustAfterRemove(int n2, int n3) {
        return n2 - 1;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int expectedModCount;
            int currentIndex;
            int indexToRemove;
            {
                this.expectedModCount = CompactHashSet.this.modCount;
                this.currentIndex = CompactHashSet.this.firstEntryIndex();
                this.indexToRemove = -1;
            }

            @Override
            public boolean hasNext() {
                return this.currentIndex >= 0;
            }

            @Override
            public E next() {
                this.checkForConcurrentModification();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.indexToRemove = this.currentIndex;
                Object object = CompactHashSet.this.elements[this.currentIndex];
                this.currentIndex = CompactHashSet.this.getSuccessor(this.currentIndex);
                return object;
            }

            @Override
            public void remove() {
                this.checkForConcurrentModification();
                CollectPreconditions.checkRemove(this.indexToRemove >= 0);
                ++this.expectedModCount;
                CompactHashSet.this.remove(CompactHashSet.this.elements[this.indexToRemove], CompactHashSet.getHash(CompactHashSet.this.entries[this.indexToRemove]));
                this.currentIndex = CompactHashSet.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
                this.indexToRemove = -1;
            }

            private void checkForConcurrentModification() {
                if (CompactHashSet.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    @Override
    public Spliterator<E> spliterator() {
        if (this.needsAllocArrays()) {
            return Spliterators.spliterator(new Object[0], 17);
        }
        return Spliterators.spliterator(this.elements, 0, this.size, 17);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n2 = this.firstEntryIndex();
        while (n2 >= 0) {
            consumer.accept(this.elements[n2]);
            n2 = this.getSuccessor(n2);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object[] toArray() {
        if (this.needsAllocArrays()) {
            return new Object[0];
        }
        return Arrays.copyOf(this.elements, this.size);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> T[] toArray(T[] TArray) {
        if (this.needsAllocArrays()) {
            if (TArray.length > 0) {
                TArray[0] = null;
            }
            return TArray;
        }
        return ObjectArrays.toArrayImpl(this.elements, 0, this.size, TArray);
    }

    public void trimToSize() {
        int n2;
        if (this.needsAllocArrays()) {
            return;
        }
        int n3 = this.size;
        if (n3 < this.entries.length) {
            this.resizeEntries(n3);
        }
        if ((n2 = Hashing.closedTableSize(n3, 1.0)) < this.table.length) {
            this.resizeTable(n2);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        ++this.modCount;
        Arrays.fill(this.elements, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, 0, this.size, -1L);
        this.size = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        int n2 = this.firstEntryIndex();
        while (n2 >= 0) {
            objectOutputStream.writeObject(this.elements[n2]);
            n2 = this.getSuccessor(n2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        if (n2 < 0) {
            throw new InvalidObjectException("Invalid size: " + n2);
        }
        this.init(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectInputStream.readObject();
            this.add(object);
        }
    }
}

