/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Hashing;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
class CompactHashMap<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final float LOAD_FACTOR = 1.0f;
    private static final long NEXT_MASK = 0xFFFFFFFFL;
    private static final long HASH_MASK = -4294967296L;
    static final int DEFAULT_SIZE = 3;
    static final int UNSET = -1;
    private transient int @MonotonicNonNull [] table;
    @VisibleForTesting
    transient long @MonotonicNonNull [] entries;
    @VisibleForTesting
    transient Object @MonotonicNonNull [] keys;
    @VisibleForTesting
    transient Object @MonotonicNonNull [] values;
    transient int modCount;
    private transient int size;
    private transient @MonotonicNonNull Set<K> keySetView;
    private transient @MonotonicNonNull Set<Map.Entry<K, V>> entrySetView;
    private transient @MonotonicNonNull Collection<V> valuesView;

    public static <K, V> CompactHashMap<K, V> create() {
        return new CompactHashMap<K, V>();
    }

    public static <K, V> CompactHashMap<K, V> createWithExpectedSize(int n2) {
        return new CompactHashMap<K, V>(n2);
    }

    CompactHashMap() {
        this.init(3);
    }

    CompactHashMap(int n2) {
        this.init(n2);
    }

    void init(int n2) {
        Preconditions.checkArgument(n2 >= 0, "Expected size must be non-negative");
        this.modCount = Math.max(1, n2);
    }

    boolean needsAllocArrays() {
        return this.table == null;
    }

    void allocArrays() {
        Preconditions.checkState(this.needsAllocArrays(), "Arrays already allocated");
        int n2 = this.modCount;
        int n3 = Hashing.closedTableSize(n2, 1.0);
        this.table = CompactHashMap.newTable(n3);
        this.entries = CompactHashMap.newEntries(n2);
        this.keys = new Object[n2];
        this.values = new Object[n2];
    }

    private static int[] newTable(int n2) {
        int[] nArray = new int[n2];
        Arrays.fill(nArray, -1);
        return nArray;
    }

    private static long[] newEntries(int n2) {
        long[] lArray = new long[n2];
        Arrays.fill(lArray, -1L);
        return lArray;
    }

    private int hashTableMask() {
        return this.table.length - 1;
    }

    private static int getHash(long l2) {
        return (int)(l2 >>> 32);
    }

    private static int getNext(long l2) {
        return (int)l2;
    }

    private static long swapNext(long l2, int n2) {
        return 0xFFFFFFFF00000000L & l2 | 0xFFFFFFFFL & (long)n2;
    }

    void accessEntry(int n2) {
    }

    @Override
    @CanIgnoreReturnValue
    public @Nullable V put(@Nullable K k2, @Nullable V v2) {
        int n2;
        if (this.needsAllocArrays()) {
            this.allocArrays();
        }
        long[] lArray = this.entries;
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int n3 = Hashing.smearedHash(k2);
        int n4 = n3 & this.hashTableMask();
        int n5 = this.size;
        int n6 = this.table[n4];
        if (n6 == -1) {
            this.table[n4] = n5;
        } else {
            long l2;
            do {
                n2 = n6;
                l2 = lArray[n6];
                if (CompactHashMap.getHash(l2) != n3 || !Objects.equal(k2, objectArray[n6])) continue;
                Object object = objectArray2[n6];
                objectArray2[n6] = v2;
                this.accessEntry(n6);
                return (V)object;
            } while ((n6 = CompactHashMap.getNext(l2)) != -1);
            lArray[n2] = CompactHashMap.swapNext(l2, n5);
        }
        if (n5 == Integer.MAX_VALUE) {
            throw new IllegalStateException("Cannot contain more than Integer.MAX_VALUE elements!");
        }
        n2 = n5 + 1;
        this.resizeMeMaybe(n2);
        this.insertEntry(n5, k2, v2, n3);
        this.size = n2;
        int n7 = this.table.length;
        if (Hashing.needsResizing(n5, n7, 1.0)) {
            this.resizeTable(2 * n7);
        }
        ++this.modCount;
        return null;
    }

    void insertEntry(int n2, @Nullable K k2, @Nullable V v2, int n3) {
        this.entries[n2] = (long)n3 << 32 | 0xFFFFFFFFL;
        this.keys[n2] = k2;
        this.values[n2] = v2;
    }

    private void resizeMeMaybe(int n2) {
        int n3 = this.entries.length;
        if (n2 > n3) {
            int n4 = n3 + Math.max(1, n3 >>> 1);
            if (n4 < 0) {
                n4 = Integer.MAX_VALUE;
            }
            if (n4 != n3) {
                this.resizeEntries(n4);
            }
        }
    }

    void resizeEntries(int n2) {
        this.keys = Arrays.copyOf(this.keys, n2);
        this.values = Arrays.copyOf(this.values, n2);
        long[] lArray = this.entries;
        int n3 = lArray.length;
        lArray = Arrays.copyOf(lArray, n2);
        if (n2 > n3) {
            Arrays.fill(lArray, n3, n2, -1L);
        }
        this.entries = lArray;
    }

    private void resizeTable(int n2) {
        int[] nArray = CompactHashMap.newTable(n2);
        long[] lArray = this.entries;
        int n3 = nArray.length - 1;
        for (int i2 = 0; i2 < this.size; ++i2) {
            long l2 = lArray[i2];
            int n4 = CompactHashMap.getHash(l2);
            int n5 = n4 & n3;
            int n6 = nArray[n5];
            nArray[n5] = i2;
            lArray[i2] = (long)n4 << 32 | 0xFFFFFFFFL & (long)n6;
        }
        this.table = nArray;
    }

    private int indexOf(@Nullable Object object) {
        if (this.needsAllocArrays()) {
            return -1;
        }
        int n2 = Hashing.smearedHash(object);
        int n3 = this.table[n2 & this.hashTableMask()];
        while (n3 != -1) {
            long l2 = this.entries[n3];
            if (CompactHashMap.getHash(l2) == n2 && Objects.equal(object, this.keys[n3])) {
                return n3;
            }
            n3 = CompactHashMap.getNext(l2);
        }
        return -1;
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public V get(@Nullable Object object) {
        int n2 = this.indexOf(object);
        this.accessEntry(n2);
        return (V)(n2 == -1 ? null : this.values[n2]);
    }

    @Override
    @CanIgnoreReturnValue
    public @Nullable V remove(@Nullable Object object) {
        if (this.needsAllocArrays()) {
            return null;
        }
        return this.remove(object, Hashing.smearedHash(object));
    }

    private @Nullable V remove(@Nullable Object object, int n2) {
        int n3 = n2 & this.hashTableMask();
        int n4 = this.table[n3];
        if (n4 == -1) {
            return null;
        }
        int n5 = -1;
        do {
            if (CompactHashMap.getHash(this.entries[n4]) == n2 && Objects.equal(object, this.keys[n4])) {
                Object object2 = this.values[n4];
                if (n5 == -1) {
                    this.table[n3] = CompactHashMap.getNext(this.entries[n4]);
                } else {
                    this.entries[n5] = CompactHashMap.swapNext(this.entries[n5], CompactHashMap.getNext(this.entries[n4]));
                }
                this.moveLastEntry(n4);
                --this.size;
                ++this.modCount;
                return (V)object2;
            }
            n5 = n4;
        } while ((n4 = CompactHashMap.getNext(this.entries[n4])) != -1);
        return null;
    }

    @CanIgnoreReturnValue
    private V removeEntry(int n2) {
        return this.remove(this.keys[n2], CompactHashMap.getHash(this.entries[n2]));
    }

    void moveLastEntry(int n2) {
        int n3 = this.size() - 1;
        if (n2 < n3) {
            long l2;
            this.keys[n2] = this.keys[n3];
            this.values[n2] = this.values[n3];
            this.keys[n3] = null;
            this.values[n3] = null;
            this.entries[n2] = l2 = this.entries[n3];
            this.entries[n3] = -1L;
            int n4 = CompactHashMap.getHash(l2) & this.hashTableMask();
            int n5 = this.table[n4];
            if (n5 == n3) {
                this.table[n4] = n2;
            } else {
                long l3;
                do {
                    int n6 = n5;
                } while ((n5 = CompactHashMap.getNext(l3 = this.entries[n5])) != n3);
                this.entries[n6] = CompactHashMap.swapNext(l3, n2);
            }
        } else {
            this.keys[n2] = null;
            this.values[n2] = null;
            this.entries[n2] = -1L;
        }
    }

    int firstEntryIndex() {
        return this.isEmpty() ? -1 : 0;
    }

    int getSuccessor(int n2) {
        return n2 + 1 < this.size ? n2 + 1 : -1;
    }

    int adjustAfterRemove(int n2, int n3) {
        return n2 - 1;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Preconditions.checkNotNull(biFunction);
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.values[i2] = biFunction.apply(this.keys[i2], this.values[i2]);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keySetView == null ? (this.keySetView = this.createKeySet()) : this.keySetView;
    }

    Set<K> createKeySet() {
        return new KeySetView();
    }

    Iterator<K> keySetIterator() {
        return new Itr<K>(){

            @Override
            K getOutput(int n2) {
                return CompactHashMap.this.keys[n2];
            }
        };
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        Preconditions.checkNotNull(biConsumer);
        int n2 = this.firstEntryIndex();
        while (n2 >= 0) {
            biConsumer.accept(this.keys[n2], this.values[n2]);
            n2 = this.getSuccessor(n2);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySetView == null ? (this.entrySetView = this.createEntrySet()) : this.entrySetView;
    }

    Set<Map.Entry<K, V>> createEntrySet() {
        return new EntrySetView();
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        return new Itr<Map.Entry<K, V>>(){

            @Override
            Map.Entry<K, V> getOutput(int n2) {
                return new MapEntry(n2);
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!Objects.equal(object, this.values[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> values() {
        return this.valuesView == null ? (this.valuesView = this.createValues()) : this.valuesView;
    }

    Collection<V> createValues() {
        return new ValuesView();
    }

    Iterator<V> valuesIterator() {
        return new Itr<V>(){

            @Override
            V getOutput(int n2) {
                return CompactHashMap.this.values[n2];
            }
        };
    }

    public void trimToSize() {
        int n2;
        if (this.needsAllocArrays()) {
            return;
        }
        int n3 = this.size;
        if (n3 < this.entries.length) {
            this.resizeEntries(n3);
        }
        if ((n2 = Hashing.closedTableSize(n3, 1.0)) < this.table.length) {
            this.resizeTable(n2);
        }
    }

    @Override
    public void clear() {
        if (this.needsAllocArrays()) {
            return;
        }
        ++this.modCount;
        Arrays.fill(this.keys, 0, this.size, null);
        Arrays.fill(this.values, 0, this.size, null);
        Arrays.fill(this.table, -1);
        Arrays.fill(this.entries, 0, this.size, -1L);
        this.size = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        int n2 = this.firstEntryIndex();
        while (n2 >= 0) {
            objectOutputStream.writeObject(this.keys[n2]);
            objectOutputStream.writeObject(this.values[n2]);
            n2 = this.getSuccessor(n2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        if (n2 < 0) {
            throw new InvalidObjectException("Invalid size: " + n2);
        }
        this.init(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    class ValuesView
    extends Maps.Values<K, V> {
        ValuesView() {
            super(CompactHashMap.this);
        }

        @Override
        public Iterator<V> iterator() {
            return CompactHashMap.this.valuesIterator();
        }

        @Override
        public void forEach(Consumer<? super V> consumer) {
            Preconditions.checkNotNull(consumer);
            int n2 = CompactHashMap.this.firstEntryIndex();
            while (n2 >= 0) {
                consumer.accept(CompactHashMap.this.values[n2]);
                n2 = CompactHashMap.this.getSuccessor(n2);
            }
        }

        @Override
        public Spliterator<V> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 16);
            }
            return Spliterators.spliterator(CompactHashMap.this.values, 0, CompactHashMap.this.size, 16);
        }

        @Override
        public Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            return ObjectArrays.copyAsObjectArray(CompactHashMap.this.values, 0, CompactHashMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (TArray.length > 0) {
                    TArray[0] = null;
                }
                return TArray;
            }
            return ObjectArrays.toArrayImpl(CompactHashMap.this.values, 0, CompactHashMap.this.size, TArray);
        }
    }

    final class MapEntry
    extends AbstractMapEntry<K, V> {
        private final @Nullable K key;
        private int lastKnownIndex;

        MapEntry(int n2) {
            this.key = CompactHashMap.this.keys[n2];
            this.lastKnownIndex = n2;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        private void updateLastKnownIndex() {
            if (this.lastKnownIndex == -1 || this.lastKnownIndex >= CompactHashMap.this.size() || !Objects.equal(this.key, CompactHashMap.this.keys[this.lastKnownIndex])) {
                this.lastKnownIndex = CompactHashMap.this.indexOf(this.key);
            }
        }

        @Override
        public V getValue() {
            this.updateLastKnownIndex();
            return this.lastKnownIndex == -1 ? null : CompactHashMap.this.values[this.lastKnownIndex];
        }

        @Override
        public V setValue(V v2) {
            this.updateLastKnownIndex();
            if (this.lastKnownIndex == -1) {
                CompactHashMap.this.put(this.key, v2);
                return null;
            }
            Object object = CompactHashMap.this.values[this.lastKnownIndex];
            CompactHashMap.this.values[this.lastKnownIndex] = v2;
            return object;
        }
    }

    class EntrySetView
    extends Maps.EntrySet<K, V> {
        EntrySetView() {
        }

        @Override
        Map<K, V> map() {
            return CompactHashMap.this;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return CompactHashMap.this.entrySetIterator();
        }

        @Override
        public Spliterator<Map.Entry<K, V>> spliterator() {
            return CollectSpliterators.indexed(CompactHashMap.this.size, 17, n2 -> new MapEntry(n2));
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                int n2 = CompactHashMap.this.indexOf(entry.getKey());
                return n2 != -1 && Objects.equal(CompactHashMap.this.values[n2], entry.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(@Nullable Object object) {
            Map.Entry entry;
            int n2;
            if (object instanceof Map.Entry && (n2 = CompactHashMap.this.indexOf((entry = (Map.Entry)object).getKey())) != -1 && Objects.equal(CompactHashMap.this.values[n2], entry.getValue())) {
                CompactHashMap.this.removeEntry(n2);
                return true;
            }
            return false;
        }
    }

    class KeySetView
    extends Maps.KeySet<K, V> {
        KeySetView() {
            super(CompactHashMap.this);
        }

        @Override
        public Object[] toArray() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return new Object[0];
            }
            return ObjectArrays.copyAsObjectArray(CompactHashMap.this.keys, 0, CompactHashMap.this.size);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            if (CompactHashMap.this.needsAllocArrays()) {
                if (TArray.length > 0) {
                    TArray[0] = null;
                }
                return TArray;
            }
            return ObjectArrays.toArrayImpl(CompactHashMap.this.keys, 0, CompactHashMap.this.size, TArray);
        }

        @Override
        public boolean remove(@Nullable Object object) {
            int n2 = CompactHashMap.this.indexOf(object);
            if (n2 == -1) {
                return false;
            }
            CompactHashMap.this.removeEntry(n2);
            return true;
        }

        @Override
        public Iterator<K> iterator() {
            return CompactHashMap.this.keySetIterator();
        }

        @Override
        public Spliterator<K> spliterator() {
            if (CompactHashMap.this.needsAllocArrays()) {
                return Spliterators.spliterator(new Object[0], 17);
            }
            return Spliterators.spliterator(CompactHashMap.this.keys, 0, CompactHashMap.this.size, 17);
        }

        @Override
        public void forEach(Consumer<? super K> consumer) {
            Preconditions.checkNotNull(consumer);
            int n2 = CompactHashMap.this.firstEntryIndex();
            while (n2 >= 0) {
                consumer.accept(CompactHashMap.this.keys[n2]);
                n2 = CompactHashMap.this.getSuccessor(n2);
            }
        }
    }

    private abstract class Itr<T>
    implements Iterator<T> {
        int expectedModCount;
        int currentIndex;
        int indexToRemove;

        private Itr() {
            this.expectedModCount = CompactHashMap.this.modCount;
            this.currentIndex = CompactHashMap.this.firstEntryIndex();
            this.indexToRemove = -1;
        }

        @Override
        public boolean hasNext() {
            return this.currentIndex >= 0;
        }

        abstract T getOutput(int var1);

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.indexToRemove = this.currentIndex;
            T t2 = this.getOutput(this.currentIndex);
            this.currentIndex = CompactHashMap.this.getSuccessor(this.currentIndex);
            return t2;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            CollectPreconditions.checkRemove(this.indexToRemove >= 0);
            ++this.expectedModCount;
            CompactHashMap.this.removeEntry(this.indexToRemove);
            this.currentIndex = CompactHashMap.this.adjustAfterRemove(this.currentIndex, this.indexToRemove);
            this.indexToRemove = -1;
        }

        private void checkForConcurrentModification() {
            if (CompactHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

