/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.j2objc.annotations.Weak;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
final class CollectSpliterators {
    private CollectSpliterators() {
    }

    static <T> Spliterator<T> indexed(int n2, int n3, IntFunction<T> intFunction) {
        return CollectSpliterators.indexed(n2, n3, intFunction, null);
    }

    static <T> Spliterator<T> indexed(int n2, int n3, IntFunction<T> intFunction, Comparator<? super T> comparator) {
        if (comparator != null) {
            Preconditions.checkArgument((n3 & 4) != 0);
        }
        class WithCharacteristics
        implements Spliterator<T> {
            private final Spliterator.OfInt delegate;
            final /* synthetic */ IntFunction val$function;
            final /* synthetic */ int val$extraCharacteristics;
            final /* synthetic */ Comparator val$comparator;

            WithCharacteristics(Spliterator.OfInt ofInt) {
                this.val$function = intFunction;
                this.val$extraCharacteristics = n2;
                this.val$comparator = comparator;
                this.delegate = ofInt;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                return this.delegate.tryAdvance((int n2) -> consumer.accept((Object)this.val$function.apply(n2)));
            }

            @Override
            public void forEachRemaining(Consumer<? super T> consumer) {
                this.delegate.forEachRemaining((int n2) -> consumer.accept((Object)this.val$function.apply(n2)));
            }

            @Override
            public @Nullable Spliterator<T> trySplit() {
                Spliterator.OfInt ofInt = this.delegate.trySplit();
                return ofInt == null ? null : new WithCharacteristics(ofInt);
            }

            @Override
            public long estimateSize() {
                return this.delegate.estimateSize();
            }

            @Override
            public int characteristics() {
                return 0x4050 | this.val$extraCharacteristics;
            }

            @Override
            public Comparator<? super T> getComparator() {
                if (this.hasCharacteristics(4)) {
                    return this.val$comparator;
                }
                throw new IllegalStateException();
            }
        }
        return new WithCharacteristics(IntStream.range(0, n2).spliterator());
    }

    static <InElementT, OutElementT> Spliterator<OutElementT> map(final Spliterator<InElementT> spliterator, final Function<? super InElementT, ? extends OutElementT> function) {
        Preconditions.checkNotNull(spliterator);
        Preconditions.checkNotNull(function);
        return new Spliterator<OutElementT>(){

            @Override
            public boolean tryAdvance(Consumer<? super OutElementT> consumer) {
                return spliterator.tryAdvance((? super T object) -> consumer.accept((Object)function.apply(object)));
            }

            @Override
            public void forEachRemaining(Consumer<? super OutElementT> consumer) {
                spliterator.forEachRemaining((? super T object) -> consumer.accept((Object)function.apply(object)));
            }

            @Override
            public Spliterator<OutElementT> trySplit() {
                Spliterator spliterator2 = spliterator.trySplit();
                return spliterator2 != null ? CollectSpliterators.map(spliterator2, function) : null;
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics() & 0xFFFFFEFA;
            }
        };
    }

    static <T> Spliterator<T> filter(final Spliterator<T> spliterator, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(spliterator);
        Preconditions.checkNotNull(predicate);
        class Splitr
        implements Spliterator<T>,
        Consumer<T> {
            T holder = null;

            Splitr() {
            }

            @Override
            public void accept(T t2) {
                this.holder = t2;
            }

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                while (spliterator.tryAdvance(this)) {
                    try {
                        if (!predicate.test(this.holder)) continue;
                        consumer.accept(this.holder);
                        boolean bl2 = true;
                        return bl2;
                    }
                    finally {
                        this.holder = null;
                    }
                }
                return false;
            }

            @Override
            public Spliterator<T> trySplit() {
                Spliterator spliterator2 = spliterator.trySplit();
                return spliterator2 == null ? null : CollectSpliterators.filter(spliterator2, predicate);
            }

            @Override
            public long estimateSize() {
                return spliterator.estimateSize() / 2L;
            }

            @Override
            public Comparator<? super T> getComparator() {
                return spliterator.getComparator();
            }

            @Override
            public int characteristics() {
                return spliterator.characteristics() & 0x115;
            }
        }
        return new Splitr();
    }

    static <InElementT, OutElementT> Spliterator<OutElementT> flatMap(Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator<OutElementT>> function, int n2, long l2) {
        Preconditions.checkArgument((n2 & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((n2 & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(spliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfObject<InElementT, OutElementT>(null, spliterator, function, n2, l2);
    }

    static <InElementT> Spliterator.OfInt flatMapToInt(Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator.OfInt> function, int n2, long l2) {
        Preconditions.checkArgument((n2 & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((n2 & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(spliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfInt<InElementT>(null, spliterator, function, n2, l2);
    }

    static <InElementT> Spliterator.OfLong flatMapToLong(Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator.OfLong> function, int n2, long l2) {
        Preconditions.checkArgument((n2 & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((n2 & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(spliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfLong<InElementT>(null, spliterator, function, n2, l2);
    }

    static <InElementT> Spliterator.OfDouble flatMapToDouble(Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator.OfDouble> function, int n2, long l2) {
        Preconditions.checkArgument((n2 & 0x4000) == 0, "flatMap does not support SUBSIZED characteristic");
        Preconditions.checkArgument((n2 & 4) == 0, "flatMap does not support SORTED characteristic");
        Preconditions.checkNotNull(spliterator);
        Preconditions.checkNotNull(function);
        return new FlatMapSpliteratorOfDouble<InElementT>(null, spliterator, function, n2, l2);
    }

    static final class FlatMapSpliteratorOfDouble<InElementT>
    extends FlatMapSpliteratorOfPrimitive<InElementT, Double, DoubleConsumer, Spliterator.OfDouble>
    implements Spliterator.OfDouble {
        FlatMapSpliteratorOfDouble(Spliterator.OfDouble ofDouble, Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator.OfDouble> function, int n2, long l2) {
            super(ofDouble, spliterator, function, FlatMapSpliteratorOfDouble::new, n2, l2);
        }
    }

    static final class FlatMapSpliteratorOfLong<InElementT>
    extends FlatMapSpliteratorOfPrimitive<InElementT, Long, LongConsumer, Spliterator.OfLong>
    implements Spliterator.OfLong {
        FlatMapSpliteratorOfLong(Spliterator.OfLong ofLong, Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator.OfLong> function, int n2, long l2) {
            super(ofLong, spliterator, function, FlatMapSpliteratorOfLong::new, n2, l2);
        }
    }

    static final class FlatMapSpliteratorOfInt<InElementT>
    extends FlatMapSpliteratorOfPrimitive<InElementT, Integer, IntConsumer, Spliterator.OfInt>
    implements Spliterator.OfInt {
        FlatMapSpliteratorOfInt(Spliterator.OfInt ofInt, Spliterator<InElementT> spliterator, Function<? super InElementT, Spliterator.OfInt> function, int n2, long l2) {
            super(ofInt, spliterator, function, FlatMapSpliteratorOfInt::new, n2, l2);
        }
    }

    static abstract class FlatMapSpliteratorOfPrimitive<InElementT, OutElementT, OutConsumerT, OutSpliteratorT extends Spliterator.OfPrimitive<OutElementT, OutConsumerT, OutSpliteratorT>>
    extends FlatMapSpliterator<InElementT, OutElementT, OutSpliteratorT>
    implements Spliterator.OfPrimitive<OutElementT, OutConsumerT, OutSpliteratorT> {
        FlatMapSpliteratorOfPrimitive(OutSpliteratorT OutSpliteratorT, Spliterator<InElementT> spliterator, Function<? super InElementT, OutSpliteratorT> function, FlatMapSpliterator.Factory<InElementT, OutSpliteratorT> factory, int n2, long l2) {
            super(OutSpliteratorT, spliterator, function, factory, n2, l2);
        }

        @Override
        public final boolean tryAdvance(OutConsumerT OutConsumerT) {
            do {
                if (this.prefix != null && ((Spliterator.OfPrimitive)this.prefix).tryAdvance(OutConsumerT)) {
                    if (this.estimatedSize != Long.MAX_VALUE) {
                        --this.estimatedSize;
                    }
                    return true;
                }
                this.prefix = null;
            } while (this.from.tryAdvance((? super T object) -> {
                this.prefix = (Spliterator)this.function.apply(object);
                Spliterator.OfPrimitive cfr_ignored_0 = (Spliterator.OfPrimitive)this.prefix;
            }));
            return false;
        }

        @Override
        public final void forEachRemaining(OutConsumerT OutConsumerT) {
            if (this.prefix != null) {
                ((Spliterator.OfPrimitive)this.prefix).forEachRemaining(OutConsumerT);
                this.prefix = null;
            }
            this.from.forEachRemaining((? super T object2) -> {
                Spliterator.OfPrimitive ofPrimitive = (Spliterator.OfPrimitive)this.function.apply(object2);
                if (ofPrimitive != null) {
                    ofPrimitive.forEachRemaining(OutConsumerT);
                }
            });
            this.estimatedSize = 0L;
        }
    }

    static final class FlatMapSpliteratorOfObject<InElementT, OutElementT>
    extends FlatMapSpliterator<InElementT, OutElementT, Spliterator<OutElementT>> {
        FlatMapSpliteratorOfObject(Spliterator<OutElementT> spliterator, Spliterator<InElementT> spliterator2, Function<? super InElementT, Spliterator<OutElementT>> function, int n2, long l2) {
            super(spliterator, spliterator2, function, FlatMapSpliteratorOfObject::new, n2, l2);
        }
    }

    static abstract class FlatMapSpliterator<InElementT, OutElementT, OutSpliteratorT extends Spliterator<OutElementT>>
    implements Spliterator<OutElementT> {
        @Weak
        @Nullable OutSpliteratorT prefix;
        final Spliterator<InElementT> from;
        final Function<? super InElementT, OutSpliteratorT> function;
        final Factory<InElementT, OutSpliteratorT> factory;
        int characteristics;
        long estimatedSize;

        FlatMapSpliterator(OutSpliteratorT OutSpliteratorT, Spliterator<InElementT> spliterator, Function<? super InElementT, OutSpliteratorT> function, Factory<InElementT, OutSpliteratorT> factory, int n2, long l2) {
            this.prefix = OutSpliteratorT;
            this.from = spliterator;
            this.function = function;
            this.factory = factory;
            this.characteristics = n2;
            this.estimatedSize = l2;
        }

        @Override
        public final boolean tryAdvance(Consumer<? super OutElementT> consumer) {
            do {
                if (this.prefix != null && this.prefix.tryAdvance(consumer)) {
                    if (this.estimatedSize != Long.MAX_VALUE) {
                        --this.estimatedSize;
                    }
                    return true;
                }
                this.prefix = null;
            } while (this.from.tryAdvance((? super T object) -> {
                this.prefix = (Spliterator)this.function.apply(object);
            }));
            return false;
        }

        @Override
        public final void forEachRemaining(Consumer<? super OutElementT> consumer) {
            if (this.prefix != null) {
                this.prefix.forEachRemaining(consumer);
                this.prefix = null;
            }
            this.from.forEachRemaining((? super T object) -> {
                Spliterator spliterator = (Spliterator)this.function.apply(object);
                if (spliterator != null) {
                    spliterator.forEachRemaining(consumer);
                }
            });
            this.estimatedSize = 0L;
        }

        public final OutSpliteratorT trySplit() {
            Spliterator<InElementT> spliterator = this.from.trySplit();
            if (spliterator != null) {
                int n2 = this.characteristics & 0xFFFFFFBF;
                long l2 = this.estimateSize();
                if (l2 < Long.MAX_VALUE) {
                    this.estimatedSize -= (l2 /= 2L);
                    this.characteristics = n2;
                }
                OutSpliteratorT OutSpliteratorT = this.factory.newFlatMapSpliterator(this.prefix, spliterator, this.function, n2, l2);
                this.prefix = null;
                return OutSpliteratorT;
            }
            if (this.prefix != null) {
                OutSpliteratorT OutSpliteratorT = this.prefix;
                this.prefix = null;
                return OutSpliteratorT;
            }
            return null;
        }

        @Override
        public final long estimateSize() {
            if (this.prefix != null) {
                this.estimatedSize = Math.max(this.estimatedSize, this.prefix.estimateSize());
            }
            return Math.max(this.estimatedSize, 0L);
        }

        @Override
        public final int characteristics() {
            return this.characteristics;
        }

        @FunctionalInterface
        static interface Factory<InElementT, OutSpliteratorT extends Spliterator<?>> {
            public OutSpliteratorT newFlatMapSpliterator(OutSpliteratorT var1, Spliterator<InElementT> var2, Function<? super InElementT, OutSpliteratorT> var3, int var4, long var5);
        }
    }
}

