/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@GwtCompatible
final class CollectPreconditions {
    CollectPreconditions() {
    }

    static void checkEntryNotNull(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("null key in entry: null=" + object2);
        }
        if (object2 == null) {
            throw new NullPointerException("null value in entry: " + object + "=null");
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int n2, String string) {
        if (n2 < 0) {
            throw new IllegalArgumentException(string + " cannot be negative but was: " + n2);
        }
        return n2;
    }

    @CanIgnoreReturnValue
    static long checkNonnegative(long l2, String string) {
        if (l2 < 0L) {
            throw new IllegalArgumentException(string + " cannot be negative but was: " + l2);
        }
        return l2;
    }

    static void checkPositive(int n2, String string) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(string + " must be positive but was: " + n2);
        }
    }

    static void checkRemove(boolean bl2) {
        Preconditions.checkState(bl2, "no calls to next() since the last call to remove()");
    }
}

