/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.AbstractList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final transient ImmutableList<List<E>> axes;
    private final transient int[] axesSizeProduct;

    static <E> List<List<E>> create(List<? extends List<? extends E>> list) {
        ImmutableList.Builder builder = new ImmutableList.Builder(list.size());
        for (List<E> list2 : list) {
            ImmutableList<E> immutableList = ImmutableList.copyOf(list2);
            if (immutableList.isEmpty()) {
                return ImmutableList.of();
            }
            builder.add(immutableList);
        }
        return new CartesianList<E>(builder.build());
    }

    CartesianList(ImmutableList<List<E>> immutableList) {
        this.axes = immutableList;
        int[] nArray = new int[immutableList.size() + 1];
        nArray[immutableList.size()] = 1;
        try {
            for (int i2 = immutableList.size() - 1; i2 >= 0; --i2) {
                nArray[i2] = IntMath.checkedMultiply(nArray[i2 + 1], ((List)immutableList.get(i2)).size());
            }
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Cartesian product too large; must have size at most Integer.MAX_VALUE");
        }
        this.axesSizeProduct = nArray;
    }

    private int getAxisIndexForProductIndex(int n2, int n3) {
        return n2 / this.axesSizeProduct[n3 + 1] % ((List)this.axes.get(n3)).size();
    }

    @Override
    public int indexOf(Object object) {
        if (!(object instanceof List)) {
            return -1;
        }
        List list = (List)object;
        if (list.size() != this.axes.size()) {
            return -1;
        }
        ListIterator listIterator = list.listIterator();
        int n2 = 0;
        while (listIterator.hasNext()) {
            int n3 = listIterator.nextIndex();
            int n4 = ((List)this.axes.get(n3)).indexOf(listIterator.next());
            if (n4 == -1) {
                return -1;
            }
            n2 += n4 * this.axesSizeProduct[n3 + 1];
        }
        return n2;
    }

    @Override
    public ImmutableList<E> get(final int n2) {
        Preconditions.checkElementIndex(n2, this.size());
        return new ImmutableList<E>(){

            @Override
            public int size() {
                return CartesianList.this.axes.size();
            }

            @Override
            public E get(int n22) {
                Preconditions.checkElementIndex(n22, this.size());
                int n3 = CartesianList.this.getAxisIndexForProductIndex(n2, n22);
                return ((List)CartesianList.this.axes.get(n22)).get(n3);
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        };
    }

    @Override
    public int size() {
        return this.axesSizeProduct[0];
    }

    @Override
    public boolean contains(@Nullable Object object) {
        return this.indexOf(object) != -1;
    }
}

