/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@Beta
@GwtCompatible(emulated=true)
public final class ArrayTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    private final ImmutableList<R> rowList;
    private final ImmutableList<C> columnList;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final V[][] array;
    private transient @MonotonicNonNull ColumnMap columnMap;
    private transient @MonotonicNonNull RowMap rowMap;
    private static final long serialVersionUID = 0L;

    public static <R, C, V> ArrayTable<R, C, V> create(Iterable<? extends R> iterable, Iterable<? extends C> iterable2) {
        return new ArrayTable<R, C, V>(iterable, iterable2);
    }

    public static <R, C, V> ArrayTable<R, C, V> create(Table<R, C, V> table) {
        return table instanceof ArrayTable ? new ArrayTable<R, C, V>((ArrayTable)table) : new ArrayTable<R, C, V>(table);
    }

    private ArrayTable(Iterable<? extends R> iterable, Iterable<? extends C> iterable2) {
        this.rowList = ImmutableList.copyOf(iterable);
        this.columnList = ImmutableList.copyOf(iterable2);
        Preconditions.checkArgument(this.rowList.isEmpty() == this.columnList.isEmpty());
        this.rowKeyToIndex = Maps.indexMap(this.rowList);
        this.columnKeyToIndex = Maps.indexMap(this.columnList);
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
        this.eraseAll();
    }

    private ArrayTable(Table<R, C, V> table) {
        this(table.rowKeySet(), table.columnKeySet());
        this.putAll(table);
    }

    private ArrayTable(ArrayTable<R, C, V> arrayTable) {
        this.rowList = arrayTable.rowList;
        this.columnList = arrayTable.columnList;
        this.rowKeyToIndex = arrayTable.rowKeyToIndex;
        this.columnKeyToIndex = arrayTable.columnKeyToIndex;
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            System.arraycopy(arrayTable.array[i2], 0, objectArray[i2], 0, arrayTable.array[i2].length);
        }
    }

    public ImmutableList<R> rowKeyList() {
        return this.rowList;
    }

    public ImmutableList<C> columnKeyList() {
        return this.columnList;
    }

    public V at(int n2, int n3) {
        Preconditions.checkElementIndex(n2, this.rowList.size());
        Preconditions.checkElementIndex(n3, this.columnList.size());
        return this.array[n2][n3];
    }

    @CanIgnoreReturnValue
    public V set(int n2, int n3, @Nullable V v2) {
        Preconditions.checkElementIndex(n2, this.rowList.size());
        Preconditions.checkElementIndex(n3, this.columnList.size());
        V v3 = this.array[n2][n3];
        this.array[n2][n3] = v2;
        return v3;
    }

    @GwtIncompatible
    public V[][] toArray(Class<V> clazz) {
        Object[][] objectArray = (Object[][])Array.newInstance(clazz, this.rowList.size(), this.columnList.size());
        for (int i2 = 0; i2 < this.rowList.size(); ++i2) {
            System.arraycopy(this.array[i2], 0, objectArray[i2], 0, this.array[i2].length);
        }
        return objectArray;
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void eraseAll() {
        for (Object[] objectArray : this.array) {
            Arrays.fill(objectArray, null);
        }
    }

    @Override
    public boolean contains(@Nullable Object object, @Nullable Object object2) {
        return this.containsRow(object) && this.containsColumn(object2);
    }

    @Override
    public boolean containsColumn(@Nullable Object object) {
        return this.columnKeyToIndex.containsKey(object);
    }

    @Override
    public boolean containsRow(@Nullable Object object) {
        return this.rowKeyToIndex.containsKey(object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        V[][] VArray = this.array;
        int n2 = VArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            V[] VArray2;
            for (V v2 : VArray2 = VArray[i2]) {
                if (!Objects.equal(object, v2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(@Nullable Object object, @Nullable Object object2) {
        Integer n2 = this.rowKeyToIndex.get(object);
        Integer n3 = this.columnKeyToIndex.get(object2);
        return n2 == null || n3 == null ? null : (V)this.at(n2, n3);
    }

    @Override
    public boolean isEmpty() {
        return this.rowList.isEmpty() || this.columnList.isEmpty();
    }

    @Override
    @CanIgnoreReturnValue
    public V put(R r2, C c2, @Nullable V v2) {
        Preconditions.checkNotNull(r2);
        Preconditions.checkNotNull(c2);
        Integer n2 = this.rowKeyToIndex.get(r2);
        Preconditions.checkArgument(n2 != null, "Row %s not in %s", r2, this.rowList);
        Integer n3 = this.columnKeyToIndex.get(c2);
        Preconditions.checkArgument(n3 != null, "Column %s not in %s", c2, this.columnList);
        return this.set(n2, n3, v2);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        super.putAll(table);
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public V remove(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    @CanIgnoreReturnValue
    public V erase(@Nullable Object object, @Nullable Object object2) {
        Integer n2 = this.rowKeyToIndex.get(object);
        Integer n3 = this.columnKeyToIndex.get(object2);
        if (n2 == null || n3 == null) {
            return null;
        }
        return this.set(n2, n3, null);
    }

    @Override
    public int size() {
        return this.rowList.size() * this.columnList.size();
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new AbstractIndexedListIterator<Table.Cell<R, C, V>>(this.size()){

            @Override
            protected Table.Cell<R, C, V> get(int n2) {
                return ArrayTable.this.getCell(n2);
            }
        };
    }

    @Override
    Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        return CollectSpliterators.indexed(this.size(), 273, this::getCell);
    }

    private Table.Cell<R, C, V> getCell(final int n2) {
        return new Tables.AbstractCell<R, C, V>(){
            final int rowIndex;
            final int columnIndex;
            {
                this.rowIndex = n2 / ArrayTable.this.columnList.size();
                this.columnIndex = n2 % ArrayTable.this.columnList.size();
            }

            @Override
            public R getRowKey() {
                return ArrayTable.this.rowList.get(this.rowIndex);
            }

            @Override
            public C getColumnKey() {
                return ArrayTable.this.columnList.get(this.columnIndex);
            }

            @Override
            public V getValue() {
                return ArrayTable.this.at(this.rowIndex, this.columnIndex);
            }
        };
    }

    private V getValue(int n2) {
        int n3 = n2 / this.columnList.size();
        int n4 = n2 % this.columnList.size();
        return this.at(n3, n4);
    }

    @Override
    public Map<R, V> column(C c2) {
        Preconditions.checkNotNull(c2);
        Integer n2 = this.columnKeyToIndex.get(c2);
        return n2 == null ? ImmutableMap.of() : new Column(n2);
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return this.columnKeyToIndex.keySet();
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap = this.columnMap;
        return columnMap == null ? (this.columnMap = new ColumnMap()) : columnMap;
    }

    @Override
    public Map<C, V> row(R r2) {
        Preconditions.checkNotNull(r2);
        Integer n2 = this.rowKeyToIndex.get(r2);
        return n2 == null ? ImmutableMap.of() : new Row(n2);
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return this.rowKeyToIndex.keySet();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        RowMap rowMap = this.rowMap;
        return rowMap == null ? (this.rowMap = new RowMap()) : rowMap;
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    Iterator<V> valuesIterator() {
        return new AbstractIndexedListIterator<V>(this.size()){

            @Override
            protected V get(int n2) {
                return ArrayTable.this.getValue(n2);
            }
        };
    }

    @Override
    Spliterator<V> valuesSpliterator() {
        return CollectSpliterators.indexed(this.size(), 16, this::getValue);
    }

    private class RowMap
    extends ArrayMap<R, Map<C, V>> {
        private RowMap() {
            super(ArrayTable.this.rowKeyToIndex);
        }

        @Override
        String getKeyRole() {
            return "Row";
        }

        @Override
        Map<C, V> getValue(int n2) {
            return new Row(n2);
        }

        @Override
        Map<C, V> setValue(int n2, Map<C, V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<C, V> put(R r2, Map<C, V> map) {
            throw new UnsupportedOperationException();
        }
    }

    private class Row
    extends ArrayMap<C, V> {
        final int rowIndex;

        Row(int n2) {
            super(ArrayTable.this.columnKeyToIndex);
            this.rowIndex = n2;
        }

        @Override
        String getKeyRole() {
            return "Column";
        }

        @Override
        V getValue(int n2) {
            return ArrayTable.this.at(this.rowIndex, n2);
        }

        @Override
        V setValue(int n2, V v2) {
            return ArrayTable.this.set(this.rowIndex, n2, v2);
        }
    }

    private class ColumnMap
    extends ArrayMap<C, Map<R, V>> {
        private ColumnMap() {
            super(ArrayTable.this.columnKeyToIndex);
        }

        @Override
        String getKeyRole() {
            return "Column";
        }

        @Override
        Map<R, V> getValue(int n2) {
            return new Column(n2);
        }

        @Override
        Map<R, V> setValue(int n2, Map<R, V> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<R, V> put(C c2, Map<R, V> map) {
            throw new UnsupportedOperationException();
        }
    }

    private class Column
    extends ArrayMap<R, V> {
        final int columnIndex;

        Column(int n2) {
            super(ArrayTable.this.rowKeyToIndex);
            this.columnIndex = n2;
        }

        @Override
        String getKeyRole() {
            return "Row";
        }

        @Override
        V getValue(int n2) {
            return ArrayTable.this.at(n2, this.columnIndex);
        }

        @Override
        V setValue(int n2, V v2) {
            return ArrayTable.this.set(n2, this.columnIndex, v2);
        }
    }

    private static abstract class ArrayMap<K, V>
    extends Maps.IteratorBasedAbstractMap<K, V> {
        private final ImmutableMap<K, Integer> keyIndex;

        private ArrayMap(ImmutableMap<K, Integer> immutableMap) {
            this.keyIndex = immutableMap;
        }

        @Override
        public Set<K> keySet() {
            return this.keyIndex.keySet();
        }

        K getKey(int n2) {
            return (K)((ImmutableSet)this.keyIndex.keySet()).asList().get(n2);
        }

        abstract String getKeyRole();

        abstract @Nullable V getValue(int var1);

        abstract @Nullable V setValue(int var1, V var2);

        @Override
        public int size() {
            return this.keyIndex.size();
        }

        @Override
        public boolean isEmpty() {
            return this.keyIndex.isEmpty();
        }

        Map.Entry<K, V> getEntry(final int n2) {
            Preconditions.checkElementIndex(n2, this.size());
            return new AbstractMapEntry<K, V>(){

                @Override
                public K getKey() {
                    return this.getKey(n2);
                }

                @Override
                public V getValue() {
                    return this.getValue(n2);
                }

                @Override
                public V setValue(V v2) {
                    return this.setValue(n2, v2);
                }
            };
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return new AbstractIndexedListIterator<Map.Entry<K, V>>(this.size()){

                @Override
                protected Map.Entry<K, V> get(int n2) {
                    return this.getEntry(n2);
                }
            };
        }

        @Override
        Spliterator<Map.Entry<K, V>> entrySpliterator() {
            return CollectSpliterators.indexed(this.size(), 16, this::getEntry);
        }

        @Override
        public boolean containsKey(@Nullable Object object) {
            return this.keyIndex.containsKey(object);
        }

        @Override
        public V get(@Nullable Object object) {
            Integer n2 = this.keyIndex.get(object);
            if (n2 == null) {
                return null;
            }
            return this.getValue(n2);
        }

        @Override
        public V put(K k2, V v2) {
            Integer n2 = this.keyIndex.get(k2);
            if (n2 == null) {
                throw new IllegalArgumentException(this.getKeyRole() + " " + k2 + " not in " + this.keyIndex.keySet());
            }
            return this.setValue(n2, v2);
        }

        @Override
        public V remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

