/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.j2objc.annotations.RetainedWith;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
abstract class AbstractBiMap<K, V>
extends ForwardingMap<K, V>
implements BiMap<K, V>,
Serializable {
    private transient @MonotonicNonNull Map<K, V> delegate;
    @RetainedWith
    transient @MonotonicNonNull AbstractBiMap<V, K> inverse;
    private transient @MonotonicNonNull Set<K> keySet;
    private transient @MonotonicNonNull Set<V> valueSet;
    private transient @MonotonicNonNull Set<Map.Entry<K, V>> entrySet;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    AbstractBiMap(Map<K, V> map, Map<V, K> map2) {
        this.setDelegates(map, map2);
    }

    private AbstractBiMap(Map<K, V> map, AbstractBiMap<V, K> abstractBiMap) {
        this.delegate = map;
        this.inverse = abstractBiMap;
    }

    @Override
    protected Map<K, V> delegate() {
        return this.delegate;
    }

    @CanIgnoreReturnValue
    K checkKey(@Nullable K k2) {
        return k2;
    }

    @CanIgnoreReturnValue
    V checkValue(@Nullable V v2) {
        return v2;
    }

    void setDelegates(Map<K, V> map, Map<V, K> map2) {
        Preconditions.checkState(this.delegate == null);
        Preconditions.checkState(this.inverse == null);
        Preconditions.checkArgument(map.isEmpty());
        Preconditions.checkArgument(map2.isEmpty());
        Preconditions.checkArgument(map != map2);
        this.delegate = map;
        this.inverse = this.makeInverse(map2);
    }

    AbstractBiMap<V, K> makeInverse(Map<V, K> map) {
        return new Inverse<V, K>(map, this);
    }

    void setInverse(AbstractBiMap<V, K> abstractBiMap) {
        this.inverse = abstractBiMap;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        return this.inverse.containsKey(object);
    }

    @Override
    @CanIgnoreReturnValue
    public V put(@Nullable K k2, @Nullable V v2) {
        return this.putInBothMaps(k2, v2, false);
    }

    @Override
    @CanIgnoreReturnValue
    public V forcePut(@Nullable K k2, @Nullable V v2) {
        return this.putInBothMaps(k2, v2, true);
    }

    private V putInBothMaps(@Nullable K k2, @Nullable V v2, boolean bl2) {
        this.checkKey(k2);
        this.checkValue(v2);
        boolean bl3 = this.containsKey(k2);
        if (bl3 && Objects.equal(v2, this.get(k2))) {
            return v2;
        }
        if (bl2) {
            this.inverse().remove(v2);
        } else {
            Preconditions.checkArgument(!this.containsValue(v2), "value already present: %s", v2);
        }
        V v3 = this.delegate.put(k2, v2);
        this.updateInverseMap(k2, bl3, v3, v2);
        return v3;
    }

    private void updateInverseMap(K k2, boolean bl2, V v2, V v3) {
        if (bl2) {
            this.removeFromInverseMap(v2);
        }
        this.inverse.delegate.put(v3, k2);
    }

    @Override
    @CanIgnoreReturnValue
    public V remove(@Nullable Object object) {
        return this.containsKey(object) ? (V)this.removeFromBothMaps(object) : null;
    }

    @CanIgnoreReturnValue
    private V removeFromBothMaps(Object object) {
        V v2 = this.delegate.remove(object);
        this.removeFromInverseMap(v2);
        return v2;
    }

    private void removeFromInverseMap(V v2) {
        this.inverse.delegate.remove(v2);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        this.delegate.replaceAll(biFunction);
        this.inverse.delegate.clear();
        Map.Entry<K, V> entry = null;
        Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry2 = iterator.next();
            K k2 = entry2.getKey();
            V v2 = entry2.getValue();
            V v3 = this.inverse.delegate.putIfAbsent(v2, k2);
            if (v3 == null) continue;
            entry = entry2;
            iterator.remove();
        }
        if (entry != null) {
            throw new IllegalArgumentException("value already present: " + entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.delegate.clear();
    }

    @Override
    public BiMap<V, K> inverse() {
        return this.inverse;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet == null ? (this.keySet = new KeySet()) : keySet;
    }

    @Override
    public Set<V> values() {
        ValueSet valueSet = this.valueSet;
        return valueSet == null ? (this.valueSet = new ValueSet()) : valueSet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    Iterator<Map.Entry<K, V>> entrySetIterator() {
        final Iterator<Map.Entry<K, V>> iterator = this.delegate.entrySet().iterator();
        return new Iterator<Map.Entry<K, V>>(){
            @Nullable Map.Entry<K, V> entry;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.entry = (Map.Entry)iterator.next();
                return new BiMapEntry(this.entry);
            }

            @Override
            public void remove() {
                CollectPreconditions.checkRemove(this.entry != null);
                Object v2 = this.entry.getValue();
                iterator.remove();
                AbstractBiMap.this.removeFromInverseMap(v2);
                this.entry = null;
            }
        };
    }

    static class Inverse<K, V>
    extends AbstractBiMap<K, V> {
        @GwtIncompatible
        private static final long serialVersionUID = 0L;

        Inverse(Map<K, V> map, AbstractBiMap<V, K> abstractBiMap) {
            super(map, abstractBiMap);
        }

        @Override
        K checkKey(K k2) {
            return this.inverse.checkValue(k2);
        }

        @Override
        V checkValue(V v2) {
            return this.inverse.checkKey(v2);
        }

        @GwtIncompatible
        private void writeObject(ObjectOutputStream objectOutputStream) {
            objectOutputStream.defaultWriteObject();
            objectOutputStream.writeObject(this.inverse());
        }

        @GwtIncompatible
        private void readObject(ObjectInputStream objectInputStream) {
            objectInputStream.defaultReadObject();
            this.setInverse((AbstractBiMap)objectInputStream.readObject());
        }

        @GwtIncompatible
        Object readResolve() {
            return this.inverse().inverse();
        }
    }

    private class EntrySet
    extends ForwardingSet<Map.Entry<K, V>> {
        final Set<Map.Entry<K, V>> esDelegate;

        private EntrySet() {
            this.esDelegate = AbstractBiMap.this.delegate.entrySet();
        }

        @Override
        protected Set<Map.Entry<K, V>> delegate() {
            return this.esDelegate;
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (!this.esDelegate.contains(object)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            AbstractBiMap.this.inverse.delegate.remove(entry.getValue());
            this.esDelegate.remove(entry);
            return true;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return AbstractBiMap.this.entrySetIterator();
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.standardToArray(TArray);
        }

        @Override
        public boolean contains(Object object) {
            return Maps.containsEntryImpl(this.delegate(), object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }
    }

    class BiMapEntry
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        BiMapEntry(Map.Entry<K, V> entry) {
            this.delegate = entry;
        }

        @Override
        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public V setValue(V v2) {
            AbstractBiMap.this.checkValue(v2);
            Preconditions.checkState(AbstractBiMap.this.entrySet().contains(this), "entry no longer in map");
            if (Objects.equal(v2, this.getValue())) {
                return v2;
            }
            Preconditions.checkArgument(!AbstractBiMap.this.containsValue(v2), "value already present: %s", v2);
            Object v3 = this.delegate.setValue(v2);
            Preconditions.checkState(Objects.equal(v2, AbstractBiMap.this.get(this.getKey())), "entry no longer in map");
            AbstractBiMap.this.updateInverseMap(this.getKey(), true, v3, v2);
            return v3;
        }
    }

    private class ValueSet
    extends ForwardingSet<V> {
        final Set<V> valuesDelegate;

        private ValueSet() {
            this.valuesDelegate = AbstractBiMap.this.inverse.keySet();
        }

        @Override
        protected Set<V> delegate() {
            return this.valuesDelegate;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(AbstractBiMap.this.entrySet().iterator());
        }

        @Override
        public Object[] toArray() {
            return this.standardToArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.standardToArray(TArray);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    private class KeySet
    extends ForwardingSet<K> {
        private KeySet() {
        }

        @Override
        protected Set<K> delegate() {
            return AbstractBiMap.this.delegate.keySet();
        }

        @Override
        public void clear() {
            AbstractBiMap.this.clear();
        }

        @Override
        public boolean remove(Object object) {
            if (!this.contains(object)) {
                return false;
            }
            AbstractBiMap.this.removeFromBothMaps(object);
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(AbstractBiMap.this.entrySet().iterator());
        }
    }
}

