/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtIncompatible;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.checkerframework.checker.nullness.qual.Nullable;
import sun.misc.Unsafe;

@GwtIncompatible
abstract class Striped64
extends Number {
    static final ThreadLocal<int[]> threadHashCode = new ThreadLocal();
    static final Random rng = new Random();
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell @Nullable [] cells;
    volatile transient long base;
    volatile transient int busy;
    private static final Unsafe UNSAFE;
    private static final long baseOffset;
    private static final long busyOffset;

    Striped64() {
    }

    final boolean casBase(long l2, long l3) {
        return UNSAFE.compareAndSwapLong(this, baseOffset, l2, l3);
    }

    final boolean casBusy() {
        return UNSAFE.compareAndSwapInt(this, busyOffset, 0, 1);
    }

    abstract long fn(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void retryUpdate(long l2, int[] nArray, boolean bl2) {
        int n2;
        int n3;
        if (nArray == null) {
            nArray = new int[1];
            threadHashCode.set(nArray);
            n3 = rng.nextInt();
            nArray[0] = n3 == 0 ? 1 : n3;
            n2 = nArray[0];
        } else {
            n2 = nArray[0];
        }
        n3 = 0;
        while (true) {
            long l3;
            int n4;
            Cell[] cellArray = this.cells;
            if (this.cells != null && (n4 = cellArray.length) > 0) {
                Cell[] cellArray2;
                Cell cell = cellArray[n4 - 1 & n2];
                if (cell == null) {
                    if (this.busy == 0) {
                        cellArray2 = new Cell(l2);
                        if (this.busy == 0 && this.casBusy()) {
                            boolean bl3 = false;
                            try {
                                int n5;
                                int n6;
                                Cell[] cellArray3 = this.cells;
                                if (this.cells != null && (n6 = cellArray3.length) > 0 && cellArray3[n5 = n6 - 1 & n2] == null) {
                                    cellArray3[n5] = cellArray2;
                                    bl3 = true;
                                }
                            }
                            finally {
                                this.busy = 0;
                            }
                            if (!bl3) continue;
                            return;
                        }
                    }
                    n3 = 0;
                } else if (!bl2) {
                    bl2 = true;
                } else {
                    l3 = cell.value;
                    if (cell.cas(l3, this.fn(l3, l2))) return;
                    if (n4 >= NCPU || this.cells != cellArray) {
                        n3 = 0;
                    } else if (n3 == 0) {
                        n3 = 1;
                    } else if (this.busy == 0 && this.casBusy()) {
                        try {
                            if (this.cells == cellArray) {
                                cellArray2 = new Cell[n4 << 1];
                                for (int i2 = 0; i2 < n4; ++i2) {
                                    cellArray2[i2] = cellArray[i2];
                                }
                                this.cells = cellArray2;
                            }
                        }
                        finally {
                            this.busy = 0;
                        }
                        n3 = 0;
                        continue;
                    }
                }
                n2 ^= n2 << 13;
                n2 ^= n2 >>> 17;
                n2 ^= n2 << 5;
                nArray[0] = n2;
                continue;
            }
            if (this.busy == 0 && this.cells == cellArray && this.casBusy()) {
                boolean bl4 = false;
                try {
                    if (this.cells == cellArray) {
                        Cell[] cellArray4 = new Cell[2];
                        cellArray4[n2 & 1] = new Cell(l2);
                        this.cells = cellArray4;
                        bl4 = true;
                    }
                }
                finally {
                    this.busy = 0;
                }
                if (!bl4) continue;
                return;
            }
            l3 = this.base;
            if (this.casBase(l3, this.fn(l3, l2))) return;
        }
    }

    final void internalReset(long l2) {
        Cell[] cellArray = this.cells;
        this.base = l2;
        if (cellArray != null) {
            for (Cell cell : cellArray) {
                if (cell == null) continue;
                cell.value = l2;
            }
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() {
                        Class<Unsafe> clazz = Unsafe.class;
                        for (Field field : clazz.getDeclaredFields()) {
                            field.setAccessible(true);
                            Object object = field.get(null);
                            if (!clazz.isInstance(object)) continue;
                            return (Unsafe)clazz.cast(object);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = Striped64.getUnsafe();
            Class<Striped64> clazz = Striped64.class;
            baseOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("base"));
            busyOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("busy"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }

    static final class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        Cell(long l2) {
            this.value = l2;
        }

        final boolean cas(long l2, long l3) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, l2, l3);
        }

        static {
            try {
                UNSAFE = Striped64.getUnsafe();
                Class<Cell> clazz = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("value"));
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }
}

