/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.cache.ForwardingCache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;

@GwtIncompatible
public abstract class ForwardingLoadingCache<K, V>
extends ForwardingCache<K, V>
implements LoadingCache<K, V> {
    protected ForwardingLoadingCache() {
    }

    @Override
    protected abstract LoadingCache<K, V> delegate();

    @Override
    public V get(K k2) {
        return this.delegate().get(k2);
    }

    @Override
    public V getUnchecked(K k2) {
        return this.delegate().getUnchecked(k2);
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> iterable) {
        return this.delegate().getAll(iterable);
    }

    @Override
    public V apply(K k2) {
        return this.delegate().apply(k2);
    }

    @Override
    public void refresh(K k2) {
        this.delegate().refresh(k2);
    }

    public static abstract class SimpleForwardingLoadingCache<K, V>
    extends ForwardingLoadingCache<K, V> {
        private final LoadingCache<K, V> delegate;

        protected SimpleForwardingLoadingCache(LoadingCache<K, V> loadingCache) {
            this.delegate = Preconditions.checkNotNull(loadingCache);
        }

        @Override
        protected final LoadingCache<K, V> delegate() {
            return this.delegate;
        }
    }
}

