/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.cache.AbstractCache;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.LinkedHashMap;
import java.util.concurrent.ExecutionException;

@GwtIncompatible
public abstract class AbstractLoadingCache<K, V>
extends AbstractCache<K, V>
implements LoadingCache<K, V> {
    protected AbstractLoadingCache() {
    }

    @Override
    public V getUnchecked(K k2) {
        try {
            return this.get(k2);
        }
        catch (ExecutionException executionException) {
            throw new UncheckedExecutionException(executionException.getCause());
        }
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> iterable) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (K k2 : iterable) {
            if (linkedHashMap.containsKey(k2)) continue;
            linkedHashMap.put(k2, this.get(k2));
        }
        return ImmutableMap.copyOf(linkedHashMap);
    }

    @Override
    public final V apply(K k2) {
        return this.getUnchecked(k2);
    }

    @Override
    public void refresh(K k2) {
        throw new UnsupportedOperationException();
    }
}

