/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LongAddable;
import com.google.common.cache.LongAddables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;

@GwtCompatible
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    public V get(K k2, Callable<? extends V> callable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ImmutableMap<K, V> getAllPresent(Iterable<?> iterable) {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        for (Object obj : iterable) {
            if (linkedHashMap.containsKey(obj)) continue;
            Object obj2 = obj;
            Object v2 = this.getIfPresent(obj);
            if (v2 == null) continue;
            linkedHashMap.put(obj2, v2);
        }
        return ImmutableMap.copyOf(linkedHashMap);
    }

    @Override
    public void put(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll(Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.invalidate(obj);
        }
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public static final class SimpleStatsCounter
    implements StatsCounter {
        private final LongAddable hitCount = LongAddables.create();
        private final LongAddable missCount = LongAddables.create();
        private final LongAddable loadSuccessCount = LongAddables.create();
        private final LongAddable loadExceptionCount = LongAddables.create();
        private final LongAddable totalLoadTime = LongAddables.create();
        private final LongAddable evictionCount = LongAddables.create();

        @Override
        public void recordHits(int n2) {
            this.hitCount.add(n2);
        }

        @Override
        public void recordMisses(int n2) {
            this.missCount.add(n2);
        }

        @Override
        public void recordLoadSuccess(long l2) {
            this.loadSuccessCount.increment();
            this.totalLoadTime.add(l2);
        }

        @Override
        public void recordLoadException(long l2) {
            this.loadExceptionCount.increment();
            this.totalLoadTime.add(l2);
        }

        @Override
        public void recordEviction() {
            this.evictionCount.increment();
        }

        @Override
        public CacheStats snapshot() {
            return new CacheStats(SimpleStatsCounter.negativeToMaxValue(this.hitCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.missCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.loadSuccessCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.loadExceptionCount.sum()), SimpleStatsCounter.negativeToMaxValue(this.totalLoadTime.sum()), SimpleStatsCounter.negativeToMaxValue(this.evictionCount.sum()));
        }

        private static long negativeToMaxValue(long l2) {
            return l2 >= 0L ? l2 : Long.MAX_VALUE;
        }

        public void incrementBy(StatsCounter statsCounter) {
            CacheStats cacheStats = statsCounter.snapshot();
            this.hitCount.add(cacheStats.hitCount());
            this.missCount.add(cacheStats.missCount());
            this.loadSuccessCount.add(cacheStats.loadSuccessCount());
            this.loadExceptionCount.add(cacheStats.loadExceptionCount());
            this.totalLoadTime.add(cacheStats.totalLoadTime());
            this.evictionCount.add(cacheStats.evictionCount());
        }
    }

    public static interface StatsCounter {
        public void recordHits(int var1);

        public void recordMisses(int var1);

        public void recordLoadSuccess(long var1);

        public void recordLoadException(long var1);

        public void recordEviction();

        public CacheStats snapshot();
    }
}

