/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Strings;
import com.google.common.base.VerifyException;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Verify {
    public static void verify(boolean bl2) {
        if (!bl2) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean bl2, @Nullable String string, Object ... objectArray) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, objectArray));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, char c2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c2)));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, int n2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, n2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, long l2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, l2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, char c2, char c3) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c2), Character.valueOf(c3)));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, int n2, char c2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, n2, Character.valueOf(c2)));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, long l2, char c2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, l2, Character.valueOf(c2)));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object, char c2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object, Character.valueOf(c2)));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, char c2, int n2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c2), n2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, int n2, int n3) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, n2, n3));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, long l2, int n2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, l2, n2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object, int n2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object, n2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, char c2, long l2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c2), l2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, int n2, long l2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, n2, l2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, long l2, long l3) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, l2, l3));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object, long l2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object, l2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, char c2, @Nullable Object object) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, Character.valueOf(c2), object));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, int n2, @Nullable Object object) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, n2, object));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, long l2, @Nullable Object object) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, l2, object));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object, object2, object3));
        }
    }

    public static void verify(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4) {
        if (!bl2) {
            throw new VerifyException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T t2) {
        return Verify.verifyNotNull(t2, "expected a non-null reference", new Object[0]);
    }

    @CanIgnoreReturnValue
    public static <T> T verifyNotNull(@Nullable T t2, @Nullable String string, Object ... objectArray) {
        Verify.verify(t2 != null, string, objectArray);
        return t2;
    }

    private Verify() {
    }
}

