/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;

@Beta
@GwtCompatible(emulated=true)
public final class Utf8 {
    public static int encodedLength(CharSequence charSequence) {
        int n2;
        int n3;
        int n4 = n3 = charSequence.length();
        for (n2 = 0; n2 < n3 && charSequence.charAt(n2) < '\u0080'; ++n2) {
        }
        while (n2 < n3) {
            char c2 = charSequence.charAt(n2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
            } else {
                n4 += Utf8.encodedLengthGeneral(charSequence, n2);
                break;
            }
            ++n2;
        }
        if (n4 < n3) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n4 + 0x100000000L));
        }
        return n4;
    }

    private static int encodedLengthGeneral(CharSequence charSequence, int n2) {
        int n3 = charSequence.length();
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 < '\u0800') {
                n4 += 127 - c2 >>> 31;
                continue;
            }
            n4 += 2;
            if ('\ud800' > c2 || c2 > '\udfff') continue;
            if (Character.codePointAt(charSequence, i2) == c2) {
                throw new IllegalArgumentException(Utf8.unpairedSurrogateMsg(i2));
            }
            ++i2;
        }
        return n4;
    }

    public static boolean isWellFormed(byte[] byArray) {
        return Utf8.isWellFormed(byArray, 0, byArray.length);
    }

    public static boolean isWellFormed(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        Preconditions.checkPositionIndexes(n2, n4, byArray.length);
        for (int i2 = n2; i2 < n4; ++i2) {
            if (byArray[i2] >= 0) continue;
            return Utf8.isWellFormedSlowPath(byArray, i2, n4);
        }
        return true;
    }

    private static boolean isWellFormedSlowPath(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        while (true) {
            byte by2;
            byte by3;
            if (n4 >= n3) {
                return true;
            }
            if ((by3 = byArray[n4++]) >= 0) continue;
            if (by3 < -32) {
                if (n4 == n3) {
                    return false;
                }
                if (by3 >= -62 && byArray[n4++] <= -65) continue;
                return false;
            }
            if (by3 < -16) {
                if (n4 + 1 >= n3) {
                    return false;
                }
                if (!((by2 = byArray[n4++]) > -65 || by3 == -32 && by2 < -96 || by3 == -19 && -96 <= by2) && byArray[n4++] <= -65) continue;
                return false;
            }
            if (n4 + 2 >= n3) {
                return false;
            }
            if ((by2 = byArray[n4++]) > -65 || (by3 << 28) + (by2 - -112) >> 30 != 0 || byArray[n4++] > -65 || byArray[n4++] > -65) break;
        }
        return false;
    }

    private static String unpairedSurrogateMsg(int n2) {
        return "Unpaired surrogate at index " + n2;
    }

    private Utf8() {
    }
}

