/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible(emulated=true)
public final class Throwables {
    @GwtIncompatible
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    @GwtIncompatible
    @VisibleForTesting
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    @GwtIncompatible
    private static final @Nullable Object jla = Throwables.getJLA();
    @GwtIncompatible
    private static final @Nullable Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @GwtIncompatible
    private static final @Nullable Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod();

    private Throwables() {
    }

    @GwtIncompatible
    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> clazz) {
        Preconditions.checkNotNull(throwable);
        if (clazz.isInstance(throwable)) {
            throw (Throwable)clazz.cast(throwable);
        }
    }

    @Deprecated
    @GwtIncompatible
    public static <X extends Throwable> void propagateIfInstanceOf(@Nullable Throwable throwable, Class<X> clazz) {
        if (throwable != null) {
            Throwables.throwIfInstanceOf(throwable, clazz);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    @GwtIncompatible
    public static void propagateIfPossible(@Nullable Throwable throwable) {
        if (throwable != null) {
            Throwables.throwIfUnchecked(throwable);
        }
    }

    @GwtIncompatible
    public static <X extends Throwable> void propagateIfPossible(@Nullable Throwable throwable, Class<X> clazz) {
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable);
    }

    @GwtIncompatible
    public static <X1 extends Throwable, X2 extends Throwable> void propagateIfPossible(@Nullable Throwable throwable, Class<X1> clazz, Class<X2> clazz2) {
        Preconditions.checkNotNull(clazz2);
        Throwables.propagateIfInstanceOf(throwable, clazz);
        Throwables.propagateIfPossible(throwable, clazz2);
    }

    @Deprecated
    @CanIgnoreReturnValue
    @GwtIncompatible
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2;
        Throwable throwable3 = throwable;
        boolean bl2 = false;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
            if (throwable == throwable3) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (bl2) {
                throwable3 = throwable3.getCause();
            }
            bl2 = !bl2;
        }
        return throwable;
    }

    @Beta
    public static List<Throwable> getCausalChain(Throwable throwable) {
        Throwable throwable2;
        Preconditions.checkNotNull(throwable);
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>(4);
        arrayList.add(throwable);
        Throwable throwable3 = throwable;
        boolean bl2 = false;
        while ((throwable2 = throwable.getCause()) != null) {
            throwable = throwable2;
            arrayList.add(throwable);
            if (throwable == throwable3) {
                throw new IllegalArgumentException("Loop in causal chain detected.", throwable);
            }
            if (bl2) {
                throwable3 = throwable3.getCause();
            }
            bl2 = !bl2;
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Beta
    @GwtIncompatible
    public static <X extends Throwable> X getCauseAs(Throwable throwable, Class<X> clazz) {
        try {
            return (X)((Throwable)clazz.cast(throwable.getCause()));
        }
        catch (ClassCastException classCastException) {
            classCastException.initCause(throwable);
            throw classCastException;
        }
    }

    @GwtIncompatible
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    @Beta
    @GwtIncompatible
    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList(Arrays.asList(throwable.getStackTrace()));
    }

    @Beta
    @GwtIncompatible
    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    @GwtIncompatible
    private static List<StackTraceElement> jlaStackTrace(final Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new AbstractList<StackTraceElement>(){

            @Override
            public StackTraceElement get(int n2) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, jla, new Object[]{throwable, n2});
            }

            @Override
            public int size() {
                return (Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, jla, new Object[]{throwable});
            }
        };
    }

    @GwtIncompatible
    private static Object invokeAccessibleNonThrowingMethod(Method method, Object object, Object ... objectArray) {
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw Throwables.propagate(invocationTargetException.getCause());
        }
    }

    @GwtIncompatible
    private static @Nullable Object getJLA() {
        try {
            Class<?> clazz = Class.forName(SHARED_SECRETS_CLASSNAME, false, null);
            Method method = clazz.getMethod("getJavaLangAccess", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @GwtIncompatible
    private static @Nullable Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    @GwtIncompatible
    private static @Nullable Method getSizeMethod() {
        try {
            Method method = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (method == null) {
                return null;
            }
            method.invoke(Throwables.getJLA(), new Throwable());
            return method;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    @GwtIncompatible
    private static @Nullable Method getJlaMethod(String string, Class<?> ... classArray) {
        try {
            return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod(string, classArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

