/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, objectArray));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, char c2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, int n2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, long l2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, char c2, char c3) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c2), Character.valueOf(c3)));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, char c2, int n2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c2), n2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, char c2, long l2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c2), l2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, char c2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, Character.valueOf(c2), object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, int n2, char c2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n2, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, int n2, int n3) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n2, n3));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, int n2, long l2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n2, l2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, int n2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, n2, object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, long l2, char c2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l2, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, long l2, int n2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l2, n2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, long l2, long l3) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l2, l3));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, long l2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, l2, object));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object, char c2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, Character.valueOf(c2)));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object, int n2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, n2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object, long l2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, l2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2, object3));
        }
    }

    public static void checkArgument(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4) {
        if (!bl2) {
            throw new IllegalArgumentException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
    }

    public static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean bl2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, Object ... objectArray) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, objectArray));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, char c2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, int n2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, n2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, long l2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, l2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, char c2, char c3) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c2), Character.valueOf(c3)));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, char c2, int n2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c2), n2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, char c2, long l2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c2), l2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, char c2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, Character.valueOf(c2), object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, int n2, char c2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, n2, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, int n2, int n3) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, n2, n3));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, int n2, long l2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, n2, l2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, int n2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, n2, object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, long l2, char c2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, l2, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, long l2, int n2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, l2, n2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, long l2, long l3) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, l2, l3));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, long l2, @Nullable Object object) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, l2, object));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object, char c2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, Character.valueOf(c2)));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object, int n2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, n2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object, long l2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, l2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2, object3));
        }
    }

    public static void checkState(boolean bl2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4) {
        if (!bl2) {
            throw new IllegalStateException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2) {
        if (t2 == null) {
            throw new NullPointerException();
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, Object ... objectArray) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, objectArray));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c2)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, char c2, char c3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c2), Character.valueOf(c3)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, char c2, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c2), n2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, char c2, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c2), l2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, char c2, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, Character.valueOf(c2), object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, int n2, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n2, Character.valueOf(c2)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, int n2, int n3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n2, n3));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, int n2, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n2, l2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, int n2, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, n2, object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, long l2, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l2, Character.valueOf(c2)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, long l2, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l2, n2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, long l2, long l3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l2, l3));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, long l2, @Nullable Object object) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, l2, object));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object, char c2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, Character.valueOf(c2)));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object, int n2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, n2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object, long l2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, l2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object, @Nullable Object object2) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, object2));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, object2, object3));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static <T> T checkNotNull(T t2, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3, @Nullable Object object4) {
        if (t2 == null) {
            throw new NullPointerException(Strings.lenientFormat(string, object, object2, object3, object4));
        }
        return t2;
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n2, int n3) {
        return Preconditions.checkElementIndex(n2, n3, "index");
    }

    @CanIgnoreReturnValue
    public static int checkElementIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException(Preconditions.badElementIndex(n2, n3, string));
        }
        return n2;
    }

    private static String badElementIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return Strings.lenientFormat("%s (%s) must be less than size (%s)", string, n2, n3);
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n2, int n3) {
        return Preconditions.checkPositionIndex(n2, n3, "index");
    }

    @CanIgnoreReturnValue
    public static int checkPositionIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndex(n2, n3, string));
        }
        return n2;
    }

    private static String badPositionIndex(int n2, int n3, @Nullable String string) {
        if (n2 < 0) {
            return Strings.lenientFormat("%s (%s) must not be negative", string, n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("negative size: " + n3);
        }
        return Strings.lenientFormat("%s (%s) must not be greater than size (%s)", string, n2, n3);
    }

    public static void checkPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n3 < n2 || n3 > n4) {
            throw new IndexOutOfBoundsException(Preconditions.badPositionIndexes(n2, n3, n4));
        }
    }

    private static String badPositionIndexes(int n2, int n3, int n4) {
        if (n2 < 0 || n2 > n4) {
            return Preconditions.badPositionIndex(n2, n4, "start index");
        }
        if (n3 < 0 || n3 > n4) {
            return Preconditions.badPositionIndex(n3, n4, "end index");
        }
        return Strings.lenientFormat("end index (%s) must not be less than start index (%s)", n3, n2);
    }
}

