/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public final class MoreObjects {
    public static <T> T firstNonNull(@Nullable T t2, @Nullable T t3) {
        if (t2 != null) {
            return t2;
        }
        if (t3 != null) {
            return t3;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object.getClass().getSimpleName());
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(clazz.getSimpleName());
    }

    public static ToStringHelper toStringHelper(String string) {
        return new ToStringHelper(string);
    }

    private MoreObjects() {
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String string) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(string);
        }

        @CanIgnoreReturnValue
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, @Nullable Object object) {
            return this.addHolder(string, object);
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, boolean bl2) {
            return this.addHolder(string, String.valueOf(bl2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, char c2) {
            return this.addHolder(string, String.valueOf(c2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, double d2) {
            return this.addHolder(string, String.valueOf(d2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, float f2) {
            return this.addHolder(string, String.valueOf(f2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, int n2) {
            return this.addHolder(string, String.valueOf(n2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper add(String string, long l2) {
            return this.addHolder(string, String.valueOf(l2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(@Nullable Object object) {
            return this.addHolder(object);
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(boolean bl2) {
            return this.addHolder(String.valueOf(bl2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(char c2) {
            return this.addHolder(String.valueOf(c2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(double d2) {
            return this.addHolder(String.valueOf(d2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(float f2) {
            return this.addHolder(String.valueOf(f2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(int n2) {
            return this.addHolder(String.valueOf(n2));
        }

        @CanIgnoreReturnValue
        public ToStringHelper addValue(long l2) {
            return this.addHolder(String.valueOf(l2));
        }

        public String toString() {
            boolean bl2 = this.omitNullValues;
            String string = "";
            StringBuilder stringBuilder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object object = valueHolder.value;
                if (!bl2 || object != null) {
                    stringBuilder.append(string);
                    string = ", ";
                    if (valueHolder.name != null) {
                        stringBuilder.append(valueHolder.name).append('=');
                    }
                    if (object != null && object.getClass().isArray()) {
                        Object[] objectArray = new Object[]{object};
                        String string2 = Arrays.deepToString(objectArray);
                        stringBuilder.append(string2, 1, string2.length() - 1);
                    } else {
                        stringBuilder.append(object);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return stringBuilder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(@Nullable Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            return this;
        }

        private ToStringHelper addHolder(String string, @Nullable Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            valueHolder.name = Preconditions.checkNotNull(string);
            return this;
        }

        private static final class ValueHolder {
            @Nullable String name;
            @Nullable Object value;
            @Nullable ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

