/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
public class Joiner {
    private final String separator;

    public static Joiner on(String string) {
        return new Joiner(string);
    }

    public static Joiner on(char c2) {
        return new Joiner(String.valueOf(c2));
    }

    private Joiner(String string) {
        this.separator = Preconditions.checkNotNull(string);
    }

    private Joiner(Joiner joiner) {
        this.separator = joiner.separator;
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A a2, Iterable<?> iterable) {
        return this.appendTo(a2, iterable.iterator());
    }

    @CanIgnoreReturnValue
    public <A extends Appendable> A appendTo(A a2, Iterator<?> iterator) {
        Preconditions.checkNotNull(a2);
        if (iterator.hasNext()) {
            a2.append(this.toString(iterator.next()));
            while (iterator.hasNext()) {
                a2.append(this.separator);
                a2.append(this.toString(iterator.next()));
            }
        }
        return a2;
    }

    @CanIgnoreReturnValue
    public final <A extends Appendable> A appendTo(A a2, Object[] objectArray) {
        return this.appendTo(a2, Arrays.asList(objectArray));
    }

    @CanIgnoreReturnValue
    public final <A extends Appendable> A appendTo(A a2, @Nullable Object object, @Nullable Object object2, Object ... objectArray) {
        return this.appendTo(a2, Joiner.iterable(object, object2, objectArray));
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterable<?> iterable) {
        return this.appendTo(stringBuilder, iterable.iterator());
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder stringBuilder, Iterator<?> iterator) {
        try {
            this.appendTo((Appendable)stringBuilder, iterator);
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        return stringBuilder;
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder stringBuilder, Object[] objectArray) {
        return this.appendTo(stringBuilder, (Iterable<?>)Arrays.asList(objectArray));
    }

    @CanIgnoreReturnValue
    public final StringBuilder appendTo(StringBuilder stringBuilder, @Nullable Object object, @Nullable Object object2, Object ... objectArray) {
        return this.appendTo(stringBuilder, Joiner.iterable(object, object2, objectArray));
    }

    public final String join(Iterable<?> iterable) {
        return this.join(iterable.iterator());
    }

    public final String join(Iterator<?> iterator) {
        return this.appendTo(new StringBuilder(), iterator).toString();
    }

    public final String join(Object[] objectArray) {
        return this.join(Arrays.asList(objectArray));
    }

    public final String join(@Nullable Object object, @Nullable Object object2, Object ... objectArray) {
        return this.join(Joiner.iterable(object, object2, objectArray));
    }

    public Joiner useForNull(final String string) {
        Preconditions.checkNotNull(string);
        return new Joiner(this){

            @Override
            CharSequence toString(@Nullable Object object) {
                return object == null ? string : Joiner.this.toString(object);
            }

            @Override
            public Joiner useForNull(String string2) {
                throw new UnsupportedOperationException("already specified useForNull");
            }

            @Override
            public Joiner skipNulls() {
                throw new UnsupportedOperationException("already specified useForNull");
            }
        };
    }

    public Joiner skipNulls() {
        return new Joiner(this){

            @Override
            public <A extends Appendable> A appendTo(A a2, Iterator<?> iterator) {
                Object obj;
                Preconditions.checkNotNull(a2, "appendable");
                Preconditions.checkNotNull(iterator, "parts");
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    if (obj == null) continue;
                    a2.append(Joiner.this.toString(obj));
                    break;
                }
                while (iterator.hasNext()) {
                    obj = iterator.next();
                    if (obj == null) continue;
                    a2.append(Joiner.this.separator);
                    a2.append(Joiner.this.toString(obj));
                }
                return a2;
            }

            @Override
            public Joiner useForNull(String string) {
                throw new UnsupportedOperationException("already specified skipNulls");
            }

            @Override
            public MapJoiner withKeyValueSeparator(String string) {
                throw new UnsupportedOperationException("can't use .skipNulls() with maps");
            }
        };
    }

    public MapJoiner withKeyValueSeparator(char c2) {
        return this.withKeyValueSeparator(String.valueOf(c2));
    }

    public MapJoiner withKeyValueSeparator(String string) {
        return new MapJoiner(this, string);
    }

    CharSequence toString(Object object) {
        Preconditions.checkNotNull(object);
        return object instanceof CharSequence ? (CharSequence)object : object.toString();
    }

    private static Iterable<Object> iterable(final Object object, final Object object2, final Object[] objectArray) {
        Preconditions.checkNotNull(objectArray);
        return new AbstractList<Object>(){

            @Override
            public int size() {
                return objectArray.length + 2;
            }

            @Override
            public Object get(int n2) {
                switch (n2) {
                    case 0: {
                        return object;
                    }
                    case 1: {
                        return object2;
                    }
                }
                return objectArray[n2 - 2];
            }
        };
    }

    public static final class MapJoiner {
        private final Joiner joiner;
        private final String keyValueSeparator;

        private MapJoiner(Joiner joiner, String string) {
            this.joiner = joiner;
            this.keyValueSeparator = Preconditions.checkNotNull(string);
        }

        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A a2, Map<?, ?> map) {
            return this.appendTo(a2, map.entrySet());
        }

        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder stringBuilder, Map<?, ?> map) {
            return this.appendTo(stringBuilder, (Iterable<? extends Map.Entry<?, ?>>)map.entrySet());
        }

        @Beta
        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A a2, Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.appendTo(a2, iterable.iterator());
        }

        @Beta
        @CanIgnoreReturnValue
        public <A extends Appendable> A appendTo(A a2, Iterator<? extends Map.Entry<?, ?>> iterator) {
            Preconditions.checkNotNull(a2);
            if (iterator.hasNext()) {
                Map.Entry<?, ?> entry = iterator.next();
                a2.append(this.joiner.toString(entry.getKey()));
                a2.append(this.keyValueSeparator);
                a2.append(this.joiner.toString(entry.getValue()));
                while (iterator.hasNext()) {
                    a2.append(this.joiner.separator);
                    Map.Entry<?, ?> entry2 = iterator.next();
                    a2.append(this.joiner.toString(entry2.getKey()));
                    a2.append(this.keyValueSeparator);
                    a2.append(this.joiner.toString(entry2.getValue()));
                }
            }
            return a2;
        }

        @Beta
        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder stringBuilder, Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.appendTo(stringBuilder, iterable.iterator());
        }

        @Beta
        @CanIgnoreReturnValue
        public StringBuilder appendTo(StringBuilder stringBuilder, Iterator<? extends Map.Entry<?, ?>> iterator) {
            try {
                this.appendTo((Appendable)stringBuilder, iterator);
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
            return stringBuilder;
        }

        public String join(Map<?, ?> map) {
            return this.join(map.entrySet());
        }

        @Beta
        public String join(Iterable<? extends Map.Entry<?, ?>> iterable) {
            return this.join(iterable.iterator());
        }

        @Beta
        public String join(Iterator<? extends Map.Entry<?, ?>> iterator) {
            return this.appendTo(new StringBuilder(), iterator).toString();
        }

        public MapJoiner useForNull(String string) {
            return new MapJoiner(this.joiner.useForNull(string), this.keyValueSeparator);
        }
    }
}

